! package variables
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/25  S. Takehiro   initial value of zeta
! 99/06/29  S. Takehiro   for binary alloy problem
!
!================================= ѿ =================================
module variables
  use dimension
  use coordinates, only    : xx, zz
  use phase
  use math
  use diffuse_boundary

  double precision, dimension(:,:), allocatable   ::  temp   ! 
  double precision, dimension(:,:), allocatable   ::  enth   ! 󥿥ԡ
  double precision, dimension(:,:), allocatable   ::  C      ! ǻ
  double precision, dimension(:,:), allocatable   ::  Cl     ! Ǥǻ
  double precision, dimension(:,:), allocatable   ::  fs     ! 
  double precision, dimension(:,:), allocatable   ::  psi    ! ήؿ
  double precision, dimension(:,:), allocatable   ::  zeta   ! 

  private
  public   :: temp, enth, C, Cl, fs, zeta, psi
  public   :: variables_init

  contains
   !----------------------------  ----------------------------
    subroutine variables_init
      integer                  ::  i, j              ! 롼ѿ
      double precision         ::  pi                ! ߼Ψ
      double precision         ::  r                 !

      pi = atan(1.0)*4.0 

     !------------- 
      allocate ( temp(nx,nz), enth(nx,nz) )
      allocate ( C(nx,nz), Cl(nx,nz), fs(nx,nz) )
      allocate ( zeta(nx,nz), psi(nx,nz) )

     !------------- 
      !psi = sin(pi*xx)*sin(pi*zz)
      !psi = ( (xx-0.5)**2 + (zz-0.5)**2)/2
      !psi = -zz
      psi = 0.0

      zeta = laplace(psi)
      call diffuse_boundary_zeta(zeta,psi) 

      !temp = 0.0 
      !temp = 20.0 
      temp = 1-zz
      !temp = xx
      !temp = temp + 0.01*cos(pi*xx)*sin(pi*zz)
      temp(nx/4,nz/4) = temp(nx/4,nz/4) + 0.01
      !temp(nx/2,nz/2) = temp(nx/2,nz/2) + 0.01
      !temp(3*nx/4,3*nz/4) = temp(3*nx/4,3*nz/4) + 0.01
      !temp = sin(pi*xx)*sin(pi*zz)
      !temp = 1.0 ; temp(:,nz) = 0.0 ; temp(nx/2,nz) = 1.001

      !temp = exp( - ( (xx-0.3)**2 + (zz-0.3)**2 )/0.05**2 )

      !temp = exp( - ( (xx-0.3)**2 + (zz-1)**2 )/0.1**2 )
      
      C = 0.0
      !C = 1.0-zz
      !C(nx/4,nz/4) = C(nx/4,nz/4) + 0.01
      !C = zz
      !C = xx
      !C = cos(pi*xx)
      do j=1,nz
         do i=1,nx
            if ( sqrt( (xx(i,j)-1.0)**2 + (zz(i,j)-0.3)**2 ) .lt. 0.2 )then
               C(i,j) = exp( - ( (xx(i,j)-1.0)**2 + (zz(i,j)-0.3)**2 )/0.1**2 )
            else
               C(i,j) = 0.0
            endif
         enddo
      enddo

     !-------------- ¾̤η׻
      fs = fs_T_C( temp, C )
      enth  = enthalpy_T_fs( temp, fs )
      Cl = C_liquid( C, temp, fs )

    end subroutine variables_init

end module variables

