! package variables
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/25  S. Takehiro   initial value of zeta
! 99/06/29  S. Takehiro   for binary alloy problem
! 99/08/18  S. Takehiro   for homogeneous initial condition
!
!================================= ѿ =================================
module variables
  use namelist
  use dimension
  use coordinates, only    : xx, zz
  use phase
  use derivative

  double precision, dimension(:,:), allocatable   ::  temp   ! 
  double precision, dimension(:,:), allocatable   ::  enth   ! 󥿥ԡ
  double precision, dimension(:,:), allocatable   ::  C      ! ǻ
  double precision, dimension(:,:), allocatable   ::  Cl     ! Ǥǻ
  double precision, dimension(:,:), allocatable   ::  fs     ! 
  double precision, dimension(:,:), allocatable   ::  psi    ! ήؿ
  double precision, dimension(:,:), allocatable   ::  zeta   ! 

  private
  public   :: temp, enth, C, Cl, fs, zeta, psi, variables_init

  contains
   !----------------------------  ----------------------------
    subroutine variables_init
      character(len=80)    :: filename=''
      integer          :: step
      logical          :: ofirst=.true.

      namelist /NMVARI/ filename, step

      if ( ofirst ) then
         ofirst = .false.
         write(6,*)'<<< INIT. COND. by netcdf File, 99/08/29 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMVARI )
      read( nm_read_num, NML=NMVARI, end=199 )
 199  write( nm_write_num, NML=NMVARI )

     !------------- ɸ, 
      call read_netcdf_init( filename )
      allocate( x(nx), z(nz) )
      allocate ( temp(nx,nz), zeta(nx,nz), psi(nx,nz) )
      allocate ( enth(nx,nz), C(nx,nz), fs(nx,nz), Cl(nx,nz) )
      call read_netcdf_axis

     !------------- 
      do istep = 1, step
         call read_netcdf_data(istep)
      enddo

    end subroutine variables_init

end module variables

