! package poisson-darcy
!     ˡ : Darcy  implicit ǰ
!     for 2-D thermal convection in a square box. 
!
! 99/08/19  S. Takehiro
!
!=======================================================================
module poisson_darcy

  use dimension
  use coordinates
  use timestep, only : time, istep, dt
  use variables, only : fs
  use dynamics_diffcoef, only : diff_Dx, diff_Dz
  use namelist
  implicit none

  integer     :: ixp = 2, iex = 5  ! x  nx=ixp*2**(iex-1)+1 
  integer     :: jzq = 2, jez = 5  ! z  nz=jzq*2**(jez-1)+1

  integer, dimension(17)         :: iparm     ! ѿ()
  double precision, dimension(6) :: fparm     ! ѿ(¿)
  double precision, allocatable  :: work(:)   ! ΰ
  integer, dimension(4)          :: mgopt     ! multigrid 
  integer                        :: ierror

  contains

   !=========================[ѥ᥿]=========================
    subroutine mudpack_init

      integer  :: nxa, nxb, nyc, nyd
      parameter ( nxa = 1, nxb = 1 )   ! B.C. in x direction
      parameter ( nyc = 1, nyd = 1 )   ! B.C. in y direction

      integer :: isx, isz, length      ! ΰλ
      parameter ( isx = 5, isz = 5 )

      integer          :: iguess=0, maxcy=1, method=2
      double precision :: tolmax
      integer          :: kcycle=2, iprer=2, ipost=1, intpol=3
      !!!integer          :: kcycle=1, iprer=2, ipost=1, intpol=1


      namelist /NMMUD/ ixp, iex, jzq, jez, &
                     & iguess, maxcy, method, tolmax, & 
                     & kcycle, iprer, ipost, intpol

     !-----------------(NAMELIST ɤ߹)-----------------
      if( .not. rewnml() ) write( nm_write_num, NML=NMMUD )
      read( nm_read_num, NML=NMMUD, end=999 )
 999  write( nm_write_num, NML=NMMUD )

      if ( nx .ne. ixp*2**(iex-1)+1 ) then
         call msgdmp('E','poisson-darcy','x dimension not match' )
      else if ( nz .ne. jzq*2**(jez-1)+1 ) then
         call msgdmp('E','poisson-darcy','z dimension not match' )
      endif

     !--------------------(ΰ)--------------------
      length = 4*(nx*nz*(10+isx+isz)+8*(nx+nz+2))/3 
      allocate( work(length) )

     !--------------------(ѿ)--------------------
      iparm(2:5) = (/nxa,nxb,nyc,nyd/)
      iparm(6:11) = (/ixp,jzq,iex,jez,nx,nz/)
      iparm(12:15) = (/iguess,maxcy,method,length/)

      fparm(1:5) = (/x(1),x(nx),z(1),z(nz),tolmax/)
      mgopt = (/kcycle,iprer,ipost,intpol/)

    end subroutine mudpack_init

  !======================(Darcy )======================
    double precision function diff_Dx_intp(xp,zp)
      implicit none
      double precision  :: xp, zp

      double precision, allocatable :: diff_Dx_val(:,:)
      double precision, allocatable :: xg(:), zg(:)
      double precision :: xs, zs
      integer          :: ix1, ix2, jz1, jz2, i, j

      allocate( diff_Dx_val(nx,nz-1), xg(nx-1), zg(nz) )

      diff_Dx_val = diff_Dx( fs )
      xg = x(1:nx-1) + dx/2 ; zg = z
     
      do i=1,nx-1    ; if ( xg(i) .le. xp    ) ix1 = i ; enddo
      do i=nx-1,1,-1 ; if ( xp    .le. xg(i) ) ix2 = i ; enddo

      do j=1,nz    ; if ( zg(j) .le. zp    ) jz1 = j ; enddo
      do j=nz,1,-1 ; if ( zp    .le. zg(j) ) jz2 = j ; enddo

      if ( ix1 .eq. ix2 ) then 
         if ( ix1 .ne. 1 ) ix1=ix1-1
         if ( ix1 .eq. 1 ) ix2=ix2+1
      endif
      if ( jz1 .eq. jz2 ) then 
         if ( jz1 .ne. 1 ) jz1=jz1-1
         if ( jz1 .eq. 1 ) jz2=jz2+1
      endif
 
      xs = ( xp - xg(ix1) )/( xg(ix2)-xg(ix1) )
      zs = ( zp - zg(jz1) )/( zg(jz2)-zg(jz1) )

      diff_Dx_intp =   (1-xs) * (1-zs) * diff_Dx_val(ix1,jz1) &
                   & +    xs  * (1-zs) * diff_Dx_val(ix2,jz1) &
                   & + (1-xs) *    zs  * diff_Dx_val(ix1,jz2) &
                   & +    xs  *    zs  * diff_Dx_val(ix2,jz2)

      deallocate( diff_Dx_val, xg, zg )
    end function diff_Dx_intp

    double precision function diff_Dz_intp(xp,zp)
      implicit none
      double precision :: xp, zp

      double precision, allocatable :: diff_Dz_val(:,:)
      double precision, allocatable :: xg(:), zg(:)
      double precision :: xs, zs
      integer          :: ix1, ix2, jz1, jz2, i, j

      allocate( diff_Dz_val(nx,nz-1), xg(nx), zg(nz-1) )

      diff_Dz_val = diff_Dz( fs )
      xg = x ; zg = z(1:nz-1) + dz/2
      
      do i=1,nx    ; if ( xg(i) .le. xp    ) ix1 = i ; enddo
      do i=nx,1,-1 ; if ( xp    .le. xg(i) ) ix2 = i ; enddo

      do j=1,nz-1    ; if ( zg(j) .le. zp    ) jz1 = j ; enddo
      do j=nz-1,1,-1 ; if ( zp    .le. zg(j) ) jz2 = j ; enddo

      if ( ix1 .eq. ix2 ) then 
         if ( ix1 .ne. 1 ) ix1=ix1-1
         if ( ix1 .eq. 1 ) ix2=ix2+1
      endif
      if ( jz1 .eq. jz2 ) then 
         if ( jz1 .ne. 1 ) jz1=jz1-1
         if ( jz1 .eq. 1 ) jz2=jz2+1
      endif

      xs = ( xp - xg(ix1) )/( xg(ix2)-xg(ix1) )
      zs = ( zp - zg(jz1) )/( zg(jz2)-zg(jz1) )

      diff_Dz_intp =   (1-xs) * (1-zs) * diff_Dz_val(ix1,jz1) &
                   & +    xs  * (1-zs) * diff_Dz_val(ix2,jz1) &
                   & + (1-xs) *    zs  * diff_Dz_val(ix1,jz2) &
                   & +    xs  *    zs  * diff_Dz_val(ix2,jz2)

      deallocate( diff_Dz_val, xg, zg )
    end function diff_Dz_intp

  !=========================()=========================
    double precision function sigx(x,z)
      implicit none
      double precision x,z

      sigx = 1.0d0 + diff_Dx_intp(x,z) * dt 

    end function sigx

    double precision function sigy(x,z)
        implicit none
        double precision x,z

        sigy = 1.0d0 + diff_Dz_intp(x,z) * dt 
    end function sigy

    double precision function xlmbda(x,z)
        implicit none
        double precision x,z

        xlmbda=0.0

    end function xlmbda

   !--------------( : ߡ)----------------
    subroutine bndyc(kbdy,xory,alfa,gbdy)
        implicit none
        integer kbdy
        double precision xory, alfa, gbdy

        xory = 0.0
        alfa=0.0
        gbdy=0.0

        return
    end subroutine bndyc

   !=========================[ղ]=========================
    function laplace_darcy_inv(dzeta) ! ->ή laplacian + Darcy ղ
      double precision, dimension(nx,nz)  :: dzeta
      double precision, dimension(nx,nz)  :: laplace_darcy_inv
      
      logical  :: ofirst=.true.

      if ( ofirst ) then 
         ofirst = .false.
         write(6,*)'<<< Solve vorticity eq. with implicit Darcy term by MUDPACK 99/08/19 >>>'
         call mudpack_init
      endif

      laplace_darcy_inv(:,1)  = 0.0   ! 
      laplace_darcy_inv(:,nz) = 0.0
      laplace_darcy_inv(1,:)  = 0.0
      laplace_darcy_inv(nx,:) = 0.0

      iparm(1)=0
      call mud2sa(iparm,fparm,work,sigx,sigy,xlmbda,bndyc,& 
                &  dzeta,laplace_darcy_inv,mgopt,ierror)
      iparm(1)=1
      call mud2sa(iparm,fparm,work,sigx,sigy,xlmbda,bndyc,&
                &  dzeta,laplace_darcy_inv,mgopt,ierror)

      if ( ierror .ne. 0 ) then
         write(6,*) 'step=', istep, 'time=', time
         write(6,*) 'ierror=',ierror, 'rel. error = ', fparm(6)
      endif
    end function laplace_darcy_inv

  end module poisson_darcy

