! package dynamics
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/25  S. Takehiro   mudpack, arakawa scheme in voriticiy equation 
! 99/08/29  S. Takehiro   use t+1/2 dt flow in calculating advection
!
!=========================== ϳ ʬ===========================
module dynamics_tint
  use base
  use math
  use poisson
  use advect
  use diffuse
  use dynamics_param
  use dynamics_diffcoef
  use variables
  use phase

  implicit none

  private
  public   :: dynamics_euler

  contains
   !------------------------ ʬ ------------------------
    subroutine dynamics_euler

        zeta = zeta + &
          & dt * ( -jacobian_arakawa(psi,zeta)                  &
          &        + alpha * g * dxd(temp) + beta*g*dxd(C)      &
          &        + visc_term( diff_visc(fs), psi )            &
          &        + diff_term( diff_Dx(fs), diff_Dz(fs), psi ) &
          &       )

        !psi = ( laplace_inv(zeta) + psi )/2.0       ! ® t+1/2dt ή

        enth = enth + &
          & dt * ( - jacobian_arakawa(psi,enth)                 &
          &        + diff_T( diff_Tx(fs), diff_Tz(fs), temp )   &
          &        + Q )

        C = C - dt * jacobian_mpdata(psi,Cl) 
        C = C + dt * diff_C( diff_Cx(fs), diff_Cz(fs), Cl ) 

!!$        C = C + &
!!$          & dt * ( - jacobian_mpdata(psi,Cl)                          &
!!$          &        + diff_C( diff_Cx(fs), diff_Cz(fs), Cl )    &
!!$          &      )

        temp = T_enth_C( enth, C ) 
        call diffuse_boundary_T( temp )
        call diffuse_boundary_C( C )

        fs  = fs_T_C( temp, C )            ! ٤ fs ׻
        enth  = enthalpy_T_fs( temp, fs )  ! ٥󥿥ԡ׻

        Cl   = C_liquid( C, temp, fs )

        psi = laplace_inv(zeta)
        call diffuse_boundary_zeta(zeta,psi)

    end subroutine dynamics_euler

end module dynamics_tint
