! package dynamics_param
!     for 2-D thermal convection in a square box. 
!
! 99/07/01  S. Takehiro   separate from the dynamics package
!
!============================ ϳإѥ᥿ ============================
module dynamics_param
  use namelist
  use dynamics_diffcoef
  use diffuse_boundary

  implicit none

! [NMDYN]  ϳإå
  logical ::  opr_inf = .false.           ! ץɥå
  logical ::  ondim   = .false.           ! ̵å

! [NMDYND]  ͭѥ᥿
    double precision    ::  Q     =  0.0  ! Ǯ
    double precision    ::  alpha =  0.1  ! ǮĥΨ
    double precision    ::  beta  =  0.1  ! ̩/
    double precision    ::  g     = 10.0  ! ϲ®
  
! [NMDYNN]  ̵ѥ᥿
    double precision    ::  Pr = 1.0      ! ץɥ
    double precision    ::  Ra = 1e5      ! 쥤꡼
    double precision    ::  Rs = 0.0      ! 쥤꡼
    double precision    ::  Le = 1.0      ! 륤

  private
    public  ::  opr_inf, ondim
    public  ::  alpha, beta, g, Q
    public  ::  Pr, Ra, Rs, Le

    public  ::  dynamics_param_init

  contains

  !------------------------- ϳذ -------------------------
    subroutine dynamics_param_init

      namelist /NMDYN/  ondim, opr_inf

      if( .not. rewnml() ) write( nm_write_num, NML=NMDYN )
      read( nm_read_num, NML=NMDYN, end=199 )
 199  write( nm_write_num, NML=NMDYN )

      if ( ondim ) then
         call dynamics_param_ndim
      else
         call dynamics_param_dim
      endif

      call diffuse_boundary_init

    end subroutine dynamics_param_init

  !------------------------ ͭѥ᥿ -----------------------
    subroutine dynamics_param_dim

      namelist /NMDYND/ alpha, beta, g, Q

      if( .not. rewnml() ) write( nm_write_num, NML=NMDYND )
      read( nm_read_num, NML=NMDYND, end=399 )
 399  write( nm_write_num, NML=NMDYND )

      call dynamics_diffcoef_init

    end subroutine dynamics_param_dim

  !------------------------ ̵ѥ᥿ ------------------------
    subroutine dynamics_param_ndim

      namelist /NMDYNN/ Ra, Pr, Rs, Le

      if( .not. rewnml() ) write( nm_write_num, NML=NMDYNN )
      read( nm_read_num, NML=NMDYNN, end=499 )
 499  write( nm_write_num, NML=NMDYNN )

      g=1.0
      alpha   = Ra  ; beta = Rs

      kappa_l = 1.0 ; Visc_l = Pr
      if( Le .le. 0.0 ) then
	  write( 6,* ) '### WARNING(dynamics_param_ndim) ### ', &
                       ' Illegal Lewis number, diffusion coeff. set to 0'
	  Dc_l    = 0.0
      else
          Dc_l    = 1.0/Le
      endif 

    end subroutine dynamics_param_ndim

  end module dynamics_param
