! package dynamics_diffcoef
!     for 2-D thermal convection in a square box. 
!
! 99/05/31  S. Takehiro
! 99/08/20  S. Takehiro  Ʒ˽ʬ
!
!============================= Ȼ =============================
module dynamics_diffcoef
  use dimension
  use namelist

  implicit none
  private

  double precision   ::   kappa_s = 1.0D0  ! ǮȻ
  double precision   ::   kappa_l = 1.0D0  ! ǮȻ

  double precision   ::   Dc_s = 0.0D0     ! ʪȻ
  double precision   ::   Dc_l = 1.0D0     ! ʪȻ

  double precision   ::   Visc_s = 1.0D2   ! Ǵ
  double precision   ::   Visc_m = 1.0D0   ! mushy region Ǵ
  double precision   ::   Visc_l = 1.0D0   ! Ǵ

  double precision   ::   Da_s = 0.0D0     ! 
  double precision   ::   Da_l = 0.0D0     ! 

  public dynamics_diffcoef_init
  public diff_T_init, diff_C_init, diff_V_init, diff_D_init
  public diff_Tx, diff_Tz, diff_Cx, diff_Cz 
  public diff_visc, diff_Dx, diff_Dz 

  public kappa_s, kappa_l, Dc_s, Dc_l
  public Visc_s, Visc_m, Visc_l, Da_s, Da_l

  contains

   !----------------------------  ----------------------------
    subroutine dynamics_diffcoef_init

      logical   :: ofirst = .true. 

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'<<< Dynamics with Phase Change 99/06/29 >>>'
      endif

      call diff_T_init
      call diff_C_init
      call diff_V_init
      call diff_D_init

    end subroutine dynamics_diffcoef_init

 !============================= ǮȻ =============================

   !----------------------------  ----------------------------
    subroutine diff_T_init
      logical   :: ofirst = .true. 

      namelist /NMHDIF/ kappa_s, kappa_l

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'<<< Thermal diffusion coefficient 99/06/29 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMHDIF )
      read( nm_read_num, NML=NMHDIF, end=999 )
 999  write( nm_write_num, NML=NMHDIF )

    end subroutine diff_T_init

   !--------------------- ǮȻ ---------------------
    function diff_Tx( fs )
      double precision, dimension(:,:)                     :: fs
      double precision, dimension(size(fs,1)-1,size(fs,2)) :: diff_Tx

      integer :: i, j

      do j = 1, size(fs,2)
         do i = 1, size(fs,1)-1
            if ( ( fs(i,j) .ge. 1.0 ) .or. ( fs(i+1,j) .ge. 1.0 ) )then
               diff_Tx(i,j) = kappa_s
            else
               diff_Tx(i,j) =  kappa_s * ( fs(i,j)+fs(i+1,j) )/2  &
                          & + kappa_l * ( 1 - (fs(i,j)+fs(i+1,j))/2 )
            endif
         enddo
      enddo
    end function diff_Tx

    function diff_Tz( fs )
      double precision, dimension(:,:)                     :: fs
      double precision, dimension(size(fs,1),size(fs,2)-1) :: diff_Tz

      integer :: i, j

      do j = 1, size(fs,2)-1
         do i = 1, size(fs,1)
            if ( ( fs(i,j) .ge. 1.0 ) .or. ( fs(i,j+1) .ge. 1.0 ) )then
               diff_Tz(i,j) = kappa_s
            else
               diff_Tz(i,j) =  kappa_s * ( fs(i,j)+fs(i,j+1) )/2  &
                          & + kappa_l * ( 1 - (fs(i,j)+fs(i,j+1))/2 )
            endif
         enddo
      enddo
    end function diff_Tz

  !============================= ʪȻ =============================

   !-----------------------  -----------------------
    subroutine diff_C_init
      logical   :: ofirst = .true. 

      namelist /NMCDIF/ Dc_s, Dc_l

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'##### Compositional diffusion coefficient 99/08/20 #####'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMCDIF )
      read( nm_read_num, NML=NMCDIF, end=998 )
 998  write( nm_write_num, NML=NMCDIF )

    end subroutine diff_C_init

   !----------------------- ʪȻ -----------------------
    function diff_Cx( fs )
      double precision, dimension(:,:)                     :: fs
      double precision, dimension(size(fs,1)-1,size(fs,2)) :: diff_Cx

      integer :: i, j

      do j = 1, size(fs,2)
         do i = 1, size(fs,1)-1
            if ( ( fs(i,j) .ge. 1.0 ) .or. ( fs(i+1,j) .ge. 1.0 ) )then
               diff_Cx(i,j) = Dc_s
            else
               diff_Cx(i,j) = Dc_l * ( 1 - (fs(i+1,j)+fs(i,j))/2 )

               diff_Cx(i,j) =  Dc_s * ( fs(i,j)+fs(i+1,j) )/2  &
                           & + Dc_l * ( 1 - (fs(i,j)+fs(i+1,j))/2 )
            endif
         enddo
      enddo
    end function diff_Cx

    function diff_Cz( fs )
      double precision, dimension(:,:)                     :: fs
      double precision, dimension(size(fs,1),size(fs,2)-1) :: diff_Cz

      integer :: i, j

      do j = 1, size(fs,2)-1
         do i = 1, size(fs,1)
            if ( ( fs(i,j) .ge. 1.0 ) .or. ( fs(i,j+1) .ge. 1.0 ) )then
               diff_Cz(i,j) = Dc_s
            else
               diff_Cz(i,j) = Dc_l * ( 1 - (fs(i,j)+fs(i,j+1))/2 )

               diff_Cz(i,j) =  Dc_s * ( fs(i,j)+fs(i,j+1) )/2  &
                           & + Dc_l * ( 1 - (fs(i,j)+fs(i,j+1))/2 )
            endif
         enddo
      enddo
    end function diff_Cz

  !============================= ǴȻ =============================

   !------------------------  ------------------------
    subroutine diff_V_init
      logical   :: ofirst = .true. 

      namelist /NMVISC/ Visc_s, Visc_m, Visc_l

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'##### Viscous coefficient 99/08/20 #####'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMVISC )
      read( nm_read_num, NML=NMVISC, end=997 )
 997  write( nm_write_num, NML=NMVISC )

    end subroutine diff_V_init

   !------------------------ Ǵ ------------------------
    function diff_visc( fs )

      double precision, dimension(:,:)                   :: fs
      double precision, dimension(size(fs,1),size(fs,2)) :: diff_visc

      integer i, j

      do j=1,size(fs,2)
         do i=1,size(fs,1)
            if ( fs(i,j) .ge. 1.0 ) then            ! 
               diff_visc(i,j) = Visc_s
            else if ( fs(i,j) .le. 0.0  ) then      ! 
               diff_visc(i,j) = Visc_l
            else
               diff_visc(i,j) = Visc_m              ! +
            endif
         enddo
      enddo

    end function diff_visc

  !============================= ǴȻ =============================

   !------------------------  ------------------------
    subroutine diff_D_init
      logical   :: ofirst = .true. 

      namelist /NMDARC/ Da_s, Da_l

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'##### Darcy coefficient 99/08/20 #####'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMDARC )
      read( nm_read_num, NML=NMDARC, end=996 )
 996  write( nm_write_num, NML=NMDARC )

    end subroutine diff_D_init

   !------------------------ Darcy  ------------------------
    function diff_Dx( fs )
      double precision, dimension(:,:)                     :: fs
      double precision, dimension(size(fs,1)-1,size(fs,2)) :: diff_Dx

      integer :: i, j

      do j = 1, size(fs,2)
         do i = 1, size(fs,1)-1
!!$            if ( ( fs(i,j) .ge. 1.0 ) .or. ( fs(i+1,j) .ge. 1.0 ) )then
!!$               diff_Dx(i,j) = Da_s
!!$            else
!!$               diff_Dx(i,j) =  Da_s * (fs(i,j)+fs(i+1,j))/2  &
!!$                           & + Da_l * ( 1 - (fs(i,j)+fs(i+1,j))/2 )
!!$            endif

            if ( ( fs(i,j) .le. 0.0 ) .and. ( fs(i+1,j) .le. 0.0 ) )then
               diff_Dx(i,j) = Da_l
            else
               diff_Dx(i,j) = Da_s * ((fs(i+1,j)+fs(i,j))/2 )**3 &
                             !& / (1-(fs(i+1,j)+fs(i,j))/2)**2  &
                             & + Da_l
            endif
         enddo
      enddo
    end function diff_Dx

    function diff_Dz( fs )
      double precision, dimension(:,:)                     :: fs
      double precision, dimension(size(fs,1),size(fs,2)-1) :: diff_Dz

      integer :: i, j

      do j = 1, size(fs,2)-1
         do i = 1, size(fs,1)
!!$            if ( ( fs(i,j) .ge. 1.0 ) .or. ( fs(i,j+1) .ge. 1.0 ) )then
!!$               diff_Dz(i,j) = Da_s
!!$            else
!!$               diff_Dz(i,j) =  Da_s * ( fs(i,j)+fs(i,j+1) )/2  &
!!$                           & + Da_l * ( 1 - (fs(i,j)+fs(i,j+1))/2 )
!!$            endif

            if ( ( fs(i,j) .le. 0.0 ) .and. ( fs(i,j+1) .le. 0.0 ) )then
               diff_Dz(i,j) = Da_l
            else
               diff_Dz(i,j) = Da_s * ((fs(i,j)+fs(i,j+1))/2 )**3 & 
                             !& / (1-(fs(i,j+1)+fs(i,j))/2)**2 &
                             & + Da_l
            endif
         enddo
      enddo
    end function diff_Dz

  end module dynamics_diffcoef

