! package main 
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/09/09  S. Takehiro
!
program dblsol

  use dimension
  use coordinates
  use variables
  use average
  use timestep
  use phase_relation, only : phase_param_init
  use phase
  use dynamics_param
  use dynamics_tint
  use output
  use input

  implicit none

!============================== ɸ ==============================
  call coordinates_init

!==============================  ==============================
  call input_variables
  !call variables_init

!============================ ѥ᥿ ============================
  call timestep_init
  call phase_param_init
  call dynamics_param_init

  call output_init
  call output_data

!============================== ֥롼 ==============================
  do istep=1,nt
    time = dt*istep
    call dynamics_euler                                ! ʬ 

    if ( mod(istep,ndisp) .eq. 0 )then
       call output_data
       write (6,*) 'step = ', istep, 'time =', time
       write (6,*) 'averaged composition =', avr_xz(C)
       write (6,*) 'averaged temperature =', avr_xz(temp)
       call maxmin(psi,nx,nz,1,nx,nz,'psi' )
       call maxmin(temp,nx,nz,1,nx,nz,'temp' )
       call maxmin(C,nx,nz,1,nx,nz,'C' )
    endif

  enddo

!================================  ================================
  call output_close
  stop

end program dblsol
