! package main 
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
!
program dbldif_init

  use dimension
  use coordinates

  use math
  use variables
  use diffuse_boundary
  use output_netcdf

  implicit none
  character(len=16)  :: file='dbldif_init.data'
  double precision   :: pi

!============================== ɸ ==============================
  call coordinates_init

  allocate ( temp(nx,nz), C(nx,nz) )
  allocate ( zeta(nx,nz), psi(nx,nz) )

!================================  ================================

  pi = atan(1.0d0)*4.0

      psi = 0.0
      !psi = sin(2*pi*xx)*sin(pi*zz)*0.01

      zeta = laplace(psi)
      call diffuse_boundary_zeta(zeta,psi) 

      !temp =0.0
      !temp = 1-zz
      temp = 0.5*(1-zz)**2
      !temp = zz
      !temp(nx/2,nz/4) = temp(nx/2,nz/4) + 0.01
      temp(nx/2,2) = temp(nx/2,2) + 0.01
      !temp = temp + cos(2*pi*xx)*sin(pi*zz)*0.01
      
      !C = 0.0
      !C = 1.0-zz
      !C(nx/4,nz/4) = C(nx/4,nz/4) + 0.01
      !C(nx/2,2) = C(nx/2,2) + 0.01
      !C = exp( - ( (xx-0.5)**2+(zz-0.5)**2)/0.1**2 ) 
      !C(:nx/10,:) = 0.0 ; C(9*nx/10:,:) = 0.0
      !C(:,:nz/10) = 0.0 ; C(:,9*nz/10:) = 0.0


!=================================  =================================
  call output_netcdf_init( file )
  call output_netcdf_data( file )

  stop

end program dbldif_init

