! package read_netcdf
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/25  S. Takehiro for double
!
!============================= netcdf  =============================
module read_netcdf
  use dimension
  use coordinates, only : x, z
  use timestep, only    : time, nt

  use diffuse_boundary
  use dynamics_param
  use dynamics_diffcoef
  use variables

  implicit none

  integer              :: ncid = 10      ! netcdf file specification number. 
  integer              :: xid, zid, timeid
  integer              :: tempid, psiid, compid
  integer,dimension(3) :: ncdimid
  integer              :: status

  private
  public   :: read_netcdf_init, read_netcdf_axis
  public   :: read_netcdf_data, read_netcdf_close

  contains

!============================= ɤ߹߽ ===========================
  subroutine read_netcdf_init( filename )
    include 'netcdf.inc'
    character(len=*)   :: filename

    character(len=53)  :: title
    character(len=12)  :: x_longname, z_longname
    character(len=4)   :: time_longname
    character(len=11)  :: temp_longname
    character(len=15)  :: psi_longname
    character(len=11)  :: comp_longname

   !---------------------- ե륪ץ ----------------------
    status = nf_open( filename, NF_NOWRITE, ncid )
    if ( status .ne. NF_NOERR ) &
       &   call msgdmp('E','read_netcdf_init','file open error.' )

   !-------------------------- ȥ --------------------------
    status = nf_get_att_text ( ncid, NF_GLOBAL, 'title', title )

   !------------------------- ѥ᥿ -------------------------
    call dynamics_param_input_nc( ncid )

   !-------------------------  ---------------------------
    call diffuse_boundary_input_nc( ncid )

   !------------------------- ɸѿ --------------------------
    status = nf_inq_dimid( ncid, 'x', ncdimid(1) )
    status = nf_inq_dimid( ncid, 'z', ncdimid(2) )
    status = nf_inq_dimid( ncid, 'time',  ncdimid(3) )

    status = nf_inq_dimlen( ncid, ncdimid(1), nx )
    status = nf_inq_dimlen( ncid, ncdimid(2), nz )
    status = nf_inq_dimlen( ncid, ncdimid(3), nt )

    status = nf_inq_varid( ncid, 'x', xid )
    status = nf_get_att_text( ncid, xid, 'longname', x_longname )

    status = nf_inq_varid( ncid, 'z', zid )
    status = nf_get_att_text( ncid, zid, 'longname', z_longname )

    status = nf_inq_varid( ncid, 'time', timeid )
    status = nf_get_att_text( ncid, timeid, 'longname', time_longname )

   !-------------------- ѿ(, ήؿ) --------------------
    status = nf_inq_varid( ncid, 'temp', tempid )
    status = nf_get_att_text( ncid, tempid, 'longname', temp_longname)

    status = nf_inq_varid( ncid, 'psi', psiid )
    status = nf_get_att_text( ncid, psiid, 'longname', psi_longname)

    status = nf_inq_varid( ncid, 'C', compid )
    status = nf_get_att_text( ncid, compid, 'longname', comp_longname)

  end subroutine read_netcdf_init

!============================= ɸɤ߹ =============================
  subroutine read_netcdf_axis
    include 'netcdf.inc'
    status = nf_get_var_double ( ncid, xid, x )
    status = nf_get_var_double ( ncid, zid, z )
  end subroutine read_netcdf_axis

!============================ ǡɤ߹ ============================
  subroutine read_netcdf_data(it)
    include 'netcdf.inc'
    integer    ::  it

    status = nf_get_var1_double ( ncid, timeid, it, time )

    write( 6,* ) '### reading ### ', it, time

    status = nf_get_vara_double & 
            & ( ncid, psiid, (/1,1,it/), (/nx,nz,1/), psi )
    status = nf_get_vara_double & 
            & ( ncid, tempid, (/1,1,it/), (/nx,nz,1/), temp )
    status = nf_get_vara_double & 
            & ( ncid, compid, (/1,1,it/), (/nx,nz,1/), C )
  end subroutine read_netcdf_data

!============================= ϸ =============================
  subroutine read_netcdf_close
    include 'netcdf.inc'
  
    status = nf_close( ncid )

  end subroutine read_netcdf_close

end module read_netcdf
