! package output_netcdf
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/06/29  S. Takehiro   for otfix_left, otfix_right
! 99/08/19  S. Takehiro   close a netcdf file in each output. 
! 99/09/16  S. Takehiro   move boundary/parameter attributes 
!
!============================= netcdf  =============================
module output_netcdf
  use dimension
  use coordinates, only : x, z
  use timestep, only    : time, istep
  use diffuse_boundary
  use dynamics_param
  use dynamics_diffcoef
  use variables

  implicit none

  integer              :: ncid = 10      ! netcdf file specification number. 
  integer              :: xid, zid, timeid
  integer              :: tempid, psiid, compid
  integer,dimension(3) :: ncdimid
  integer              :: status

  private
  public   :: output_netcdf_init, output_netcdf_data, output_netcdf_close

  contains

!============================= Ͻ ===========================
  subroutine output_netcdf_init( filename )
    include 'netcdf.inc'
    character(len=*)    :: filename

   !------------------------ ե ------------------------
    status = nf_create( filename, NF_NOCLOBBER, ncid )
    if ( status .ne. NF_NOERR ) &
       &   call msgdmp('E','ouput_init','file open error.' )

   !-------------------------- ȥ --------------------------
    status = nf_put_att_text & 
       & ( ncid, NF_GLOBAL, 'title', 53, &
       &   '2-D double diffusive convection in a rectangular box' )

   !------------------------- ѥ᥿ -------------------------
    call dynamics_param_output_nc( ncid )

   !-------------------------  ---------------------------
    call diffuse_boundary_output_nc( ncid )

   !------------------------- ɸѿ --------------------------
    status = nf_def_dim( ncid, 'x', nx, ncdimid(1) )
    status = nf_def_dim( ncid, 'z', nz, ncdimid(2) )
    status = nf_def_dim( ncid, 'time', NF_UNLIMITED, ncdimid(3) )

    status = nf_def_var( ncid, 'x', NF_DOUBLE, 1, ncdimid(1), xid )
    status = nf_put_att_text( ncid, xid, 'longname', 12, 'X coordinate')

    status = nf_def_var( ncid, 'z', NF_DOUBLE, 1, ncdimid(2), zid )
    status = nf_put_att_text( ncid, zid, 'longname', 12, 'Z coordinate')

    status = nf_def_var( ncid, 'time', NF_DOUBLE, 1, ncdimid(3), timeid )
    status = nf_put_att_text( ncid, timeid, 'longname', 4, 'time')

   !-------------------- ѿ(, ήؿ) --------------------
    status = nf_def_var( ncid, 'temp', NF_DOUBLE, 3, ncdimid, tempid )
    status = nf_put_att_text( ncid, tempid, 'longname', 11, 'temperature')

    status = nf_def_var( ncid, 'psi', NF_DOUBLE, 3, ncdimid, psiid )
    status = nf_put_att_text( ncid, psiid, 'longname', 15, 'stream function')

    status = nf_def_var( ncid, 'C', NF_DOUBLE, 3, ncdimid, compid )
    status = nf_put_att_text( ncid, compid, 'longname', 11, 'composition')

    status = nf_enddef(ncid)
    if ( status .ne. NF_NOERR ) &
       & call msgdmp('E','ouput_init','cannot leave define mode.' )

    status = nf_put_var_double ( ncid, xid, x )
    status = nf_put_var_double ( ncid, zid, z )

    status = nf_close( ncid )
  end subroutine output_netcdf_init

!================================  ================================
  subroutine output_netcdf_data( filename )
    include 'netcdf.inc'
    integer    ::  i
    character(len=*)    :: filename

    status = nf_open( filename, NF_WRITE, ncid )
    if ( status .ne. NF_NOERR ) &
       &   call msgdmp('E','ouput_netcdf','file open error.' )

    status = nf_inq_dimlen( ncid, timeid, i )
    i = i+1
    write( 6,* ) i, istep, time
    status = nf_put_var1_double ( ncid, timeid, i, time )

    status = nf_put_vara_double & 
            & ( ncid, psiid, (/1,1,i/), (/nx,nz,1/), psi )
    status = nf_put_vara_double & 
            & ( ncid, tempid, (/1,1,i/), (/nx,nz,1/), temp )
    status = nf_put_vara_double & 
            & ( ncid, compid, (/1,1,i/), (/nx,nz,1/), C )

    status = nf_close( ncid )
  end subroutine output_netcdf_data

!============================= ϸ =============================
  subroutine output_netcdf_close
    include 'netcdf.inc'
  
    status = nf_close( ncid )

  end subroutine output_netcdf_close

end module output_netcdf

