! package output_dcl
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/27  S. Takehiro   for large arrays
! 99/06/29  S. Takehiro   for otfix_left, otfix_right
! 99/09/09  S. Takehiro   for dbldif
!
!=============================== dcl  ===============================
module output_dcl

  use dimension
  use coordinates, only : x, z
  use timestep, only : time, istep

  use diffuse_boundary
  use dynamics_param
  use variables
  use average

  implicit none
  private

  integer, dimension(:), allocatable :: ibr          ! ѿ
  integer                            :: NB, nbr3

  real    :: vxmin=0.15, vxmax=0.9                ! ӥ塼ݡ
  real    :: vymin=0.15, vymax=0.9                ! ӥ塼ݡ
  integer :: idivx=2,    idivy=2                  ! ʬ
  character(len=1) :: cdivfm='y'                  ! դ()

  public    :: output_dcl_init, output_dcl_data, output_dcl_close
  public    :: output_dcl_data_header, output_dcl_data_2D
  public    :: output_dcl_data_1Dx, output_dcl_data_1Dz

  public  :: vxmin, vxmax, vymin, vymax
  public  :: idivx, idivy, cdivfm

contains

!=============================  ===========================
  subroutine output_dcl_init(iws)
    integer          :: iws

    call gropn( iws )
    call slmgn( 0.05, 0.05, 0.15, 0.15 ) 
    call sldiv( cdivfm, idivx, idivy )
    call sgiset( 'INDEX', 3 )
    call gliget('NBITSPW', NB )

    nbr3 = ( ( nx + 2 )*( nz + 2 )* 2 / NB + 1 ) *3
    allocate ( ibr(nbr3) )
  end subroutine output_dcl_init

!===============================  ===============================
  subroutine output_dcl_data
    call output_dcl_data_header
    call output_dcl_data_2D
  end subroutine output_dcl_data

!============================ إå ==========================
  subroutine output_dcl_data_header
    character(len=27)    ::  htime         ! ʸѿ
    character(len=46)    ::  hparam        ! ʸѿ
    character(len=56)    ::  hboundary     ! ʸѿ
    character(len=1)     ::  csgi          ! dcl ؿ

   !-------------------------- ȥ --------------------------
    call slsttl( '2-D binary system', 'T', -1.0, 0.0, 0.02, 1 ) 

   !----------------------------  ----------------------------
    write ( htime ,'(A7,I5,A9,F6.3)') 'step = ', istep, ', time = ', time
    call slsttl( htime, 'T', 1.0, 0.0, 0.018, 3 ) 

   !------------------------- ѥ᥿ -------------------------
    if ( ondim ) then
      if ( opr_inf ) then
         write ( hparam,'(A3,ES8.1,A4,ES8.1,A7,A4,ES8.1)')   &
               & 'Ra=', Ra, ' Rs=', Rs, ' Pr=inf.',', Le=', Le
       else
         write ( hparam,'(A3,ES8.1,A4,ES8.1,A4,F4.1,A4,ES8.1)' ) & 
               & 'Ra=', Ra, ' Rs=', Rs, ' Pr=', Pr, ' Le=', Le
       endif
    else
       write ( hparam,'(A2,F4.1,A3,F4.1,A3,F4.1,A3,F4.1)') &
               & csgi(152)//'=', alpha, ' '//csgi(153)//'=',beta, &
               & ' g=', g, ' Q=',Q 
    endif
    call slsttl( hparam, 'B', -1.0, 0.0, 0.008, 2 ) 

   !--------------------------  --------------------------
    if ( otfix_top ) then
       write ( hboundary ,'(A7,F4.1)') 'Ttop = ', tftop
    else
       write ( hboundary ,'(A7,F4.1)') 'Ftop = ', tftop
    endif

    if ( otfix_bottom ) then
       write ( hboundary(12:) ,'(A12,F4.1)') ', Tbottom = ', tfbtm
    else
       write ( hboundary(12:) ,'(A12,F4.1)') ', Fbottom = ', tfbtm
    endif

    if ( otfix_left ) then
       write ( hboundary(28:) ,'(A10,F4.1)') ', Tleft = ', tfleft
    else
       write ( hboundary(28:) ,'(A10,F4.1)') ', Fleft = ', tfleft
    endif
    if ( otfix_right ) then
       write ( hboundary(42:) ,'(A11,F4.1)') ', Tright = ', tfright
    else
       write ( hboundary(42:) ,'(A11,F4.1)') ', Fright = ', tfright
    endif

    call slsttl( hboundary, 'B', 1.0, 0.0, 0.008, 4 ) 
  end subroutine output_dcl_data_header

!============================ (2D) ==========================
  subroutine output_dcl_data_2D

   !-------------------------- ήؿ --------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
    call grstrn( 1 )
    call grstrf
    call usdaxs
    call udgclb( real(psi), nx, nx, nz, 0 ) 
    call udcntz( real(psi), nx, nx, nz, ibr, nbr3 ) 
    call sgtxzv ( 0.5, 0.95, 'stream function', 0.04, 0, 0, 3 )

   !----------------------------  ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
    call grstrn( 1 )
    call grstrf
    call usdaxs
    call uegtla( 0.0, 1.0, 0.02 ) 
    call uetone( real(temp), nx, nx, nz )
    call udgcla( 0.0, 1.0, 0.1 )
    call udcntz( real(temp), nx, nx, nz, ibr, nbr3 ) 
    call sgtxzv ( 0.5, 0.95, 'temperature', 0.04, 0, 0, 3 )

   !---------------------------- ǻ ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
    call grstrn( 1 )
    call grstrf
    call usdaxs
    call uegtla( 0.0, 1.0, 0.02 ) 
    call uetone( real(C), nx, nx, nz )
    call udgcla( 0.0, 1.0, 0.1 )
    call udcntz( real(C), nx, nx, nz, ibr, nbr3 ) 
    call sgtxzv ( 0.5, 0.95, 'composition', 0.04, 0, 0, 3 )

   !----------------------------  ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
    call grstrn( 1 )
    call grstrf
    call usdaxs
!!$    call uegtla( 0.0, 1.0, 0.02 ) 
!!$    if ( ondim ) then
!!$       call uetone( real( Ra*temp-Rs*C ), nx, nx, nz )
!!$    else
!!$       call uetone( real( (alpha*temp-beta*C)*g ), nx, nx, nz )
!!$    endif
!!$    call udgcla( 0.0, 1.0, 0.1 )
    if ( ondim ) then
       call udgclb( real( Ra*temp-Rs*C ), nx, nx, nz, 0 ) 
       call udcntz( real( Ra*temp-Rs*C ), nx, nx, nz, ibr, nbr3 ) 
    else
       call udgclb( real( (alpha*temp-beta*C)*g ), nx, nx, nz, 0 ) 
       call udcntz( real( (alpha*temp-beta*C)*g ), nx, nx, nz, ibr, nbr3 ) 
    endif
    call sgtxzv ( 0.5, 0.95, 'buoyancy', 0.04, 0, 0, 3 )

  end subroutine output_dcl_data_2D

!============================ (1D-X) ==========================
  subroutine output_dcl_data_1Dx(iz)
    integer :: iz

    if ( iz .gt. nz ) call msgdmp('E','output_dcl_data_1Dx','IZ EXCEEDS NZ')

   !-------------------------- ήؿ --------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('X', ' ', 'psi', ' ' )
    if ( iz .eq. 0 ) then
       call usgrph( nx, real(x), real(avr_z(psi)) )
    else
       call usgrph( nx, real(x), real(psi(:,iz)) )
    end if
    call sgtxzv ( 0.5, 0.95, 'stream function', 0.04, 0, 0, 3 )

   !----------------------------  ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('X', ' ', 'temp', ' ' )
    if ( iz .eq. 0 ) then
       call usgrph( nx, real(x), real(avr_z(temp)) )
    else
       call usgrph( nx, real(x), real(temp(:,iz)) )
    end if
    call sgtxzv ( 0.5, 0.95, 'temperature', 0.04, 0, 0, 3 )

   !---------------------------- ǻ ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('X', ' ', 'C', ' ' )
    if ( iz .eq. 0 ) then
       call usgrph( nx, real(x), real(avr_z(C)) )
    else
       call usgrph( nx, real(x), real(C(:,iz)) )
    end if
    call sgtxzv ( 0.5, 0.95, 'composition', 0.04, 0, 0, 3 )

   !----------------------------  ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('X', ' ', 'B', ' ' )
    if ( iz .eq. 0 ) then
       if ( ondim ) then
          call usgrph( nx, real(x), real(avr_z(Ra*temp-Rs*C)) )
       else
          call usgrph( nx, real(x), real(avr_z((alpha*temp-beta*C)*g)) )
       endif
    else
       if ( ondim ) then
          call usgrph( nx, real(x), real(Ra*temp(:,iz)-Rs*C(:,iz)  ) )
       else
          call usgrph( nx, real(x), real( (alpha*temp(:,iz)-beta*C(:,iz))*g ) )
       endif
    end if
    call sgtxzv ( 0.5, 0.95, 'buoyancy', 0.04, 0, 0, 3 )

  end subroutine output_dcl_data_1Dx


!============================ (1D-Z) ==========================
  subroutine output_dcl_data_1Dz(ix)
    integer :: ix

    if ( ix .gt. nx ) call msgdmp('E','output_dcl_data_1Dz','IX EXCEEDS NX')

   !-------------------------- ήؿ --------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('psi', ' ', 'Z', ' ' )
    if ( ix .eq. 0 ) then
       call usgrph( nz, real(avr_x(psi)), real(z) )
    else
       call usgrph( nz, real(psi(ix,:)), real(z) )
    end if
    call sgtxzv ( 0.5, 0.95, 'stream function', 0.04, 0, 0, 3 )

   !----------------------------  ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('temp', ' ', 'Z', ' ' )
    if ( ix .eq. 0 ) then
       call usgrph( nz, real(avr_x(temp)), real(z) )
    else
       call usgrph( nz, real(temp(ix,:)), real(z) )
    end if
    call sgtxzv ( 0.5, 0.95, 'temperature', 0.04, 0, 0, 3 )

   !---------------------------- ǻ ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('C', ' ', 'Z', ' ' )
    if ( ix .eq. 0 ) then
       call usgrph( nx, real(avr_x(C)), real(z) )
    else
       call usgrph( nx, real(C(ix,:)), real(z) )
    end if
    call sgtxzv ( 0.5, 0.95, 'composition', 0.04, 0, 0, 3 )

   !----------------------------  ----------------------------
    call grfrm
    call grsvpt( vxmin, vxmax, vymin, vymax )
    call grstrn( 1 )
    call ussttl('C', ' ', 'Z', ' ' )
    if ( ix .eq. 0 ) then
       if ( ondim ) then
          call usgrph( nx, real(avr_x(Ra*temp-Rs*C)), real(z)  )
       else
          call usgrph( nx, real(avr_x((alpha*temp-beta*C)*g)), real(z) )
       endif
    else
       if ( ondim ) then
          call usgrph( nx, real(Ra*temp(ix,:)-Rs*C(ix,:) ), real(z) )
       else
          call usgrph( nx, real( (alpha*temp(ix,:)-beta*C(ix,:))*g ), real(z) )
       endif
    end if
    call sgtxzv ( 0.5, 0.95, 'buoyancy', 0.04, 0, 0, 3 )

  end subroutine output_dcl_data_1Dz

!=============================  ===========================
  
  subroutine output_dcl_close

    call grcls
    deallocate ( ibr )

  end subroutine output_dcl_close

end module output_dcl
