! package input
!     for 2-D thermal convection in a square box. 
!
! 99/09/08  S. Takehiro
!
!============================= netcdf  =============================
module input
  use namelist
  use dimension
  use timestep, only    : time
  use coordinates, only : x, z
  use variables
  use read_netcdf

  implicit none

  private
  public   :: input_variables

  contains
!============================= ɤ߹ ===========================
    subroutine input_variables
      character(len=80)    :: file=''
      integer              :: step=1
      logical              :: ofirst=.true.

      integer :: i, nxold, nzold

      namelist /NMIVAR/ step, file

      if ( ofirst ) then
         ofirst = .false.
         write(6,*)'<<< INITIAL COND. by netcdf file, 99/09/09 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMIVAR )
      read( nm_read_num, NML=NMIVAR, end=199 )
 199  write( nm_write_num, NML=NMIVAR )

      if ( file .eq. '' .or. step .eq. 0 ) then
         write(6,*)' ### file not found. '
!!$         write(6,*)' ### initial values set internally'
!!$         call variables_init
         write(6,*)' ### use defalut initial values'
      else
        !------------- ɸ, 
         nxold = nx ; nzold = nz
         call read_netcdf_init( file )
         if ( (nxold .ne. nx) .or. (nzold .ne. nz) ) then
            call msgdmp('E','input',' nx, nz different ' )
         endif
!!$         allocate ( temp(nx,nz), C(nx,nz) )
!!$         allocate ( zeta(nx,nz), psi(nx,nz) )

!!$         call read_netcdf_axis

        !------------- 
         do i = 1, step
            call read_netcdf_data(i)
         enddo
      endif
    end subroutine input_variables

  end module input
