! package convcont
!     contour plot for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
!
program convcont

  use base
  use variables
  !use dynamics_param
  !use dynamics
  use read_netcdf
  use output_dcl

  implicit none

  character(len=80)    :: filename=''
  integer              :: iws, iarg

  real :: vxlen, vzlen

!============================ ե̾ ============================
  call OSQARN(iarg)
  if ( iarg .ge. 1 )then
     call OSGARG( 1, filename )
  else
     call msgdmp('E','ddcont','Usage : ddcont filename' )
  endif

!============================== ɸ ==============================
  call read_netcdf_init( filename )
  allocate( x(nx), z(nz) )
  allocate ( temp(nx,nz), C(nx,nz), zeta(nx,nz), psi(nx,nz) )

  call read_netcdf_axis

  vxlen = x(nx) - x(1)  ; vzlen = z(nz) - z(1) 
  if ( vxlen .gt. vzlen ) then
     vzlen = (vzlen/vxlen)*0.9 ; vxlen = 0.9
     vxmin = 0.1 ; vxmax = 0.9
     vymin = 0.5 - vzlen/2; vymax = 0.5 + vzlen/2
  else
     vxlen = (vxlen/vzlen)*0.9 ; vzlen=0.9
     vxmin = 0.5 - vxlen/2; vxmax = 0.5 + vxlen/2
     vymin = 0.1 ; vymax = 0.9
  endif
  
!===============================  ==============================
  call sgpwsn
  read ( 5, * ) iws
  call output_dcl_init(iws)

!============================== ǡ =============================
  do istep = 1, nt
     call read_netcdf_data(istep)
     call output_dcl_data
  enddo

!================================= λ ================================
  call read_netcdf_close
  call output_dcl_close

end program convcont

