! package variables
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/25  S. Takehiro   initial value of zeta
! 99/09/08  S. Takehiro   for double diffusive system
!
!================================= ѿ =================================
module variables
  use dimension
  use coordinates, only    : xx, zz
  use math
  use diffuse_boundary

  double precision, dimension(:,:), allocatable   ::  temp   ! 
  double precision, dimension(:,:), allocatable   ::  C      ! ǻ
  double precision, dimension(:,:), allocatable   ::  zeta   ! 
  double precision, dimension(:,:), allocatable   ::  psi    ! ήؿ

  private
  public   :: temp, C, zeta, psi
  public   :: variables_init

  contains
   !----------------------------  ----------------------------
    subroutine variables_init
      integer                  ::  i, j              ! 롼ѿ
      double precision         ::  pi                ! ߼Ψ
      double precision         ::  r                 !

      pi = atan(1.0)*4.0 

     !------------- 
      allocate ( temp(nx,nz), C(nx,nz) )
      allocate ( zeta(nx,nz), psi(nx,nz) )

     !------------- 
      psi = 0.0

      zeta = laplace(psi)
      call diffuse_boundary_zeta(zeta,psi) 

      !temp = 1-zz
      temp = zz
      !temp(nx/4,nz/4) = temp(nx/4,nz/4) + 0.01
      
      C = 0.0
      !C = 1.0-zz
      C(nx/4,nz/4) = C(nx/4,nz/4) + 0.01

!!$      do j=1,nz
!!$         do i=1,nx
!!$            if ( sqrt( (xx(i,j)-0.3)**2 + (zz(i,j)-0.3)**2 ) .lt. 0.2 )then
!!$               C(i,j) = exp( - ( (xx(i,j)-0.3)**2 + (zz(i,j)-0.3)**2 )/0.1**2 )
!!$            else
!!$               C(i,j) = 0.0
!!$            endif
!!$         enddo
!!$      enddo

     !-------------- ¾̤η׻
    end subroutine variables_init

end module variables

