! package variables
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/25  S. Takehiro   initial value of zeta
! 99/06/29  S. Takehiro   for binary alloy problem
! 99/08/18  S. Takehiro   for homogeneous initial condition
!
!================================= ѿ =================================
module variables
  use namelist
  use dimension
  use coordinates, only    : xx, zz
  use phase
  use derivative

  double precision, dimension(:,:), allocatable   ::  temp   ! 
  double precision, dimension(:,:), allocatable   ::  C      ! ǻ
  double precision, dimension(:,:), allocatable   ::  psi    ! ήؿ
  double precision, dimension(:,:), allocatable   ::  zeta   ! 

  private
  public   :: temp, enth, C, zeta, psi, variables_init

  contains
   !----------------------------  ----------------------------
    subroutine variables_init
      double precision :: psi0=0.0, temp0=0.0, C0=0.0  ! ()
      logical          :: ofirst=.true.

      namelist /NMVARI/ psi0, temp0, C0

      if ( ofirst ) then
         ofirst = .false.
         write(6,*)'<<< HOMOGENEOUS INIT. COND. 99/08/17 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMVARI )
      read( nm_read_num, NML=NMVARI, end=199 )
 199  write( nm_write_num, NML=NMVARI )

     !------------- 
      allocate ( temp(nx,nz), C(nx,nz) )
      allocate ( zeta(nx,nz), psi(nx,nz) )

     !------------- 
      psi = psi0
      zeta = laplace(psi)

      temp = temp0

      C = C0
    end subroutine variables_init

end module variables

