! package dynamics
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/05/25  S. Takehiro   mudpack, arakawa scheme in voriticiy equation 
!
!=========================== ϳ ʬ===========================
module dynamics_tint

  use base
  use math
  use diffuse
  use advect
  use poisson

  use dynamics_param
  use dynamics_diffcoef
  use variables

  implicit none

  !private
  public   :: dynamics_euler

  contains
   !------------------------ ʬ ------------------------
    subroutine dynamics_euler

        zeta = zeta + &
          & dt * ( -jacobian_arakawa(psi,zeta)              &
          &        + alpha * g * dxd(temp) - beta*g*dxd(C)  &
          &        + visc_term( diff_visc, psi )            &
          &        + diff_term( diff_Dx, diff_Dz, psi )     &
          &       )

        temp = temp + &
          & dt * ( - jacobian_arakawa(psi,temp)         &
          &        + diff_T( diff_Tx, diff_Tz, temp )   &
          &        + Q )

        C = C - dt * jacobian_mpdata(psi,C) 
        C = C + dt * diff_C( diff_Cx, diff_Cz, C ) 

        call diffuse_boundary_T( temp )
        call diffuse_boundary_C( C )

        psi = laplace_inv(zeta)
        call diffuse_boundary_zeta(zeta,psi)

    end subroutine dynamics_euler

end module dynamics_tint
