! package dynamics_param
!     for 2-D thermal convection in a square box. 
!
! 99/07/01  S. Takehiro   separate from the dynamics package
!
!============================ ϳإѥ᥿ ============================
module dynamics_param
  use namelist
  use dynamics_diffcoef
  use diffuse_boundary

  implicit none
  include 'netcdf.inc'

! [NMDYN]  ϳإå
  logical ::  opr_inf = .false.           ! ץɥå
  logical ::  ondim   = .false.           ! ̵å

! [NMDYND]  ͭѥ᥿
    double precision    ::  alpha =  0.1  ! ǮĥΨ
    double precision    ::  beta  =  0.1  ! ̩/
    double precision    ::  g     = 10.0  ! ϲ®
    double precision    ::  Q     =  0.0  ! Ǯ
  
! [NMDYNN]  ̵ѥ᥿
    double precision    ::  Pr = 1.0      ! ץɥ
    double precision    ::  Ra = 1e5      ! 쥤꡼
    double precision    ::  Rs = 0.0      ! 쥤꡼
    double precision    ::  Le = 1.0      ! 륤
!   double precision    ::  Q     =  0.0  ! Ǯ

  private
    public  ::  opr_inf, ondim
    public  ::  alpha, beta, g, Q
    public  ::  Pr, Ra, Rs, Le

    public  ::  dynamics_param_init
    public  ::  dynamics_param_output_nc
    public  ::  dynamics_param_input_nc
  contains

!=========================== ϳذ ===========================
    subroutine dynamics_param_init

      namelist /NMDYN/  ondim, opr_inf

      if( .not. rewnml() ) write( nm_write_num, NML=NMDYN )
      read( nm_read_num, NML=NMDYN, end=199 )
 199  write( nm_write_num, NML=NMDYN )

      if ( ondim ) then
         call dynamics_param_ndim
      else
         call dynamics_param_dim
      endif

      call diffuse_boundary_init

    end subroutine dynamics_param_init

  !-------------------- ѥ᥿ ---------------------
    subroutine dynamics_param_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_int1 & 
         & ( ncid, NF_GLOBAL, 'ondim', NF_BYTE, 1, ondim )
      status = nf_put_att_int1 & 
         & ( ncid, NF_GLOBAL, 'opr_inf', NF_BYTE, 1, opr_inf )

      if ( ondim )then
         call dynamics_param_ndim_output_nc( ncid )
      else
         call dynamics_param_dim_output_nc( ncid )
      endif
    end subroutine dynamics_param_output_nc

  !-------------------- ѥ᥿ ---------------------
    subroutine dynamics_param_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_int1 & 
         & ( ncid, NF_GLOBAL, 'ondim', ondim )
      status = nf_get_att_int1 & 
         & ( ncid, NF_GLOBAL, 'opr_inf',opr_inf )

      if ( ondim )then
         call dynamics_param_ndim_input_nc( ncid )
      else
         call dynamics_param_dim_input_nc( ncid )
      endif

    end subroutine dynamics_param_input_nc

!=========================== ͭѥ᥿ ===========================
    subroutine dynamics_param_dim

      namelist /NMDYND/ alpha, beta, g, Q

      if( .not. rewnml() ) write( nm_write_num, NML=NMDYND )
      read( nm_read_num, NML=NMDYND, end=399 )
 399  write( nm_write_num, NML=NMDYND )

      call dynamics_diffcoef_init

    end subroutine dynamics_param_dim

  !-------------------- ѥ᥿ ---------------------
    subroutine dynamics_param_dim_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'alpha', NF_DOUBLE, 1, alpha )
      status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'beta', NF_DOUBLE, 1, beta )
      status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'gravity', NF_DOUBLE, 1, g )
      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Internal_heating', NF_DOUBLE, 1, Q )

      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Thermal_diffusivity', NF_DOUBLE, 1, kappa )
      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Comp_diffusivity', NF_DOUBLE, 1, Dc )
      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Viscocity', NF_DOUBLE, 1, Visc )
      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Darcy_coeff', NF_DOUBLE, 1, Da )
    end subroutine dynamics_param_dim_output_nc

  !-------------------- ѥ᥿ ---------------------
    subroutine dynamics_param_dim_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_double & 
          & ( ncid, NF_GLOBAL, 'alpha', alpha )
      status = nf_get_att_double & 
          & ( ncid, NF_GLOBAL, 'beta', beta )
      status = nf_get_att_double & 
            & ( ncid, NF_GLOBAL, 'gravity', g )
      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Internal_heating', Q )

      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Thermal_diffusivity', kappa )
      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Comp_diffusivity', Dc )
      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Viscocity', Visc )
      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Darcy_coeff', Da )

    end subroutine dynamics_param_dim_input_nc

!========================= ̵ѥ᥿ =========================
    subroutine dynamics_param_ndim

      namelist /NMDYNN/ Ra, Pr, Rs, Le, Q

      if( .not. rewnml() ) write( nm_write_num, NML=NMDYNN )
      read( nm_read_num, NML=NMDYNN, end=499 )
 499  write( nm_write_num, NML=NMDYNN )

      g=1.0
      alpha   = Pr*Ra  ; beta = Pr*Rs

      kappa = 1.0 ; Visc = Pr
      if( Le .le. 0.0 ) then
	  write( 6,* ) '### WARNING(dynamics_param_ndim) ### ', &
                       ' Illegal Lewis number, diffusion coeff. set to 0'
	  Dc    = 0.0
      else
          Dc    = 1.0/Le
      endif 

      call diff_T_init
      call diff_C_init
      call diff_V_init
      call diff_D_init

    end subroutine dynamics_param_ndim

  !-------------------- ѥ᥿ ---------------------
    subroutine dynamics_param_ndim_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'Rayleigh_number', NF_DOUBLE, 1, Ra )
      status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'Comp_Rayleigh_number', NF_DOUBLE, 1, Rs )
      status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'Prandtl_number', NF_DOUBLE, 1, Pr )
      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Lewis_number', NF_DOUBLE, 1, Le )
      status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Internal_heating', NF_DOUBLE, 1, Q )
     end subroutine dynamics_param_ndim_output_nc

  !-------------------- ѥ᥿ ---------------------
    subroutine dynamics_param_ndim_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_double & 
          & ( ncid, NF_GLOBAL, 'Rayleigh_number', Ra )

      status = nf_get_att_double & 
          & ( ncid, NF_GLOBAL, 'Comp_Rayleigh_number', Rs )

      status = nf_get_att_double & 
          & ( ncid, NF_GLOBAL, 'Prandtl_number', Pr )

      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Lewis_number', Le )

      status = nf_get_att_double &
          & ( ncid, NF_GLOBAL, 'Internal_heating', Q )
    end subroutine dynamics_param_ndim_input_nc

  end module dynamics_param
