! package dynamics_diffcoef
!     for 2-D thermal convection in a square box. 
!
! 99/05/31  S. Takehiro
! 99/08/20  S. Takehiro  Ʒ˽ʬ
!
!============================= Ȼ =============================
module dynamics_diffcoef
  use dimension
  use namelist

  implicit none
  private

  double precision   ::   kappa = 1.0D0  ! ǮȻ
  double precision   ::   Dc = 0.0D0     ! ʪȻ
  double precision   ::   Visc = 1.0D0   ! Ǵ
  double precision   ::   Da = 0.0D0     !  darcy 

  double precision, dimension(:,:), allocatable :: diff_Tx   ! ǮȻ (x)
  double precision, dimension(:,:), allocatable :: diff_Tz   ! ǮȻ (z)
  double precision, dimension(:,:), allocatable :: diff_Cx   ! ʪȻ (x)
  double precision, dimension(:,:), allocatable :: diff_Cz   ! ʪȻ (z)
  double precision, dimension(:,:), allocatable :: diff_Visc ! Ǵ
  double precision, dimension(:,:), allocatable :: diff_Dx   ! Darcy  (x)
  double precision, dimension(:,:), allocatable :: diff_Dz   ! Darcy  (x)

  public dynamics_diffcoef_init
  public diff_T_init, diff_C_init, diff_V_init, diff_D_init
  public diff_Tx, diff_Tz, diff_Cx, diff_Cz 
  public diff_visc, diff_Dx, diff_Dz 

  public kappa, Dc, Visc, Da

  contains

   !----------------------------  ----------------------------
    subroutine dynamics_diffcoef_init

      logical   :: ofirst = .true. 
      namelist /NMDIFF/ kappa, Dc, Visc, Da

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'<<< Dynamics constant diffusion coefficients 99/09/09 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMDIFF )
      read( nm_read_num, NML=NMDIFF, end=999 )
 999  write( nm_write_num, NML=NMDIFF )

      call diff_T_init
      call diff_C_init
      call diff_V_init
      call diff_D_init

    end subroutine dynamics_diffcoef_init

 !============================= ǮȻ =============================
    subroutine diff_T_init
      allocate ( diff_Tx(nx-1,nz), diff_Tz(nx,nz-1) )
      diff_Tx = kappa
      diff_Tz = kappa
    end subroutine diff_T_init

  !============================= ʪȻ =============================
    subroutine diff_C_init
      allocate ( diff_Cx(nx-1,nz), diff_Cz(nx,nz-1) )
      diff_Cx = Dc
      diff_Cz = Dc
    end subroutine diff_C_init

  !============================= ǴȻ =============================
    subroutine diff_V_init
      allocate ( diff_Visc(nx,nz) )
      diff_visc = Visc
    end subroutine diff_V_init

  !============================= ǴȻ =============================
    subroutine diff_D_init
      allocate ( diff_Dx(nx-1,nz), diff_Dz(nx,nz-1) )
      diff_Dx  = Da
      diff_Dz  = Da
    end subroutine diff_D_init

  end module dynamics_diffcoef

