program test_poisson

  !use dimension
  use coordinates, only : dx, dz, xcycl, zcycl
  use dblfft
  use dblsint
  use dblfftsin
  use dblsinfft
  use poisson
  implicit none

      integer,parameter          :: nx=21, nz=17
      double precision,parameter :: xlngth=1.0, zlngth=1.0
      integer,parameter          :: kx=2, kz=2
      double precision, dimension(nx,nz)  :: xx, zz, zeta, psi, psi_a
      integer :: i, j
      double precision :: pi

      xcycl = .true.  ; zcycl = .false.   ! 

      pi = atan(1.0)*4.0

      dx = xlngth/real(nx-1) ; dz = zlngth/real(nz-1)
      do j=1,nz
         do i=1,nx
            xx(i,j) = (i-1)*dx
            zz(i,j) = (j-1)*dz
         enddo
      enddo

      !zeta  = sin(kx*pi*xx)*sin(kz*pi*zz) 
      zeta = cos(kx*pi*xx)*sin(kz*pi*zz) 
      !zeta = sin(kx*pi*xx)*cos(kz*pi*zz)  
      !zeta = cos(kx*pi*xx)*cos(kz*pi*zz) 

      psi_a = - 1/( (kx*pi)**2 + (kz*pi)**2 ) * zeta
      psi = laplace_inv(zeta)

      call gropn(1)
      call grfrm
      call grswnd( 0.0, 1.0, 0.0, 1.0 )
      call uspfit
      call grstrf
      call usdaxs
      call udcntr( real(psi), nx, nx, nz )

      call grfrm
      call grswnd( 0.0, 1.0, 0.0, 1.0 )
      call uspfit
      call grstrf
      call usdaxs
      call udcntr( real(psi_a), nx, nx, nz )

      call grcls

      stop
    end program test_poisson

