! package main 
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
!
program convbox

  use dimension
  use coordinates
  use variables
  use timestep
  use phase
  use poisson_darcy
  use dynamics_diffcoef, only : diff_D_init

  implicit none
  double precision :: pi

!============================== ɸ ==============================
  call coordinates_init

!============================ ѥ᥿ ============================
  call timestep_init
  call diff_D_init

!==============================  ==============================
  call variables_init

  pi = atan(1.0d0)*4.0
  temp = sin(pi*xx) * sin(pi*zz)
  fs = 0.0
  !fs = 1.0
  write (6,*) nx, nz
  fs(nx/2:,:) = 1.0
  !fs = 0.5* (1 + tanh ( (zz-0.5)/0.05 ) )

  psi = laplace_darcy_inv(temp)

    call gropn(1)
    call grfrm
    call grswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)))
    call uspfit
    call grstrf
    call usdaxs

    call udcntr(real(fs),nx,nx,nz)

    call grfrm
    call grswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)))
    call uspfit
    call grstrf
    call usdaxs

    call udcntr(real(psi),nx,nx,nz)
    call grcls

  stop
end
