program test_div

  use coordinates, only : dx, dz, xcycl, zcycl
  use derivative_div
  implicit none

  integer, parameter :: nx=21, nz=17
  double precision,parameter :: xlngth=1.0, zlngth=1.0
  double precision, dimension(0:nx,nz) :: flux_x
  double precision, dimension(nx,0:nz) :: flux_z
  double precision, dimension(nx,nz) :: div_a, div_b

  double precision, dimension(0:nx,nz)  :: xx_1, zz_1
  double precision, dimension(nx,0:nz)  :: xx_2, zz_2
  double precision, dimension(nx,nz)    :: xx, zz
  integer :: i, j
  double precision :: pi

  xcycl = .true.  ; zcycl = .false.   ! 

  pi = atan(1.0)*4.0

  dx = xlngth/real(nx-1) ; dz = zlngth/real(nz-1)

  do j=1,nz; do i=0,nx
     xx_1(i,j) = (i-0.5)*dx ; zz_1(i,j) = (j-1)*dz
  enddo; enddo

  do j=0,nz ; do i=1,nx
     xx_2(i,j) = (i-1)*dx ;  zz_2(i,j) = (j-0.5)*dz
  enddo ; enddo

  do j=1,nz ; do i=1,nx
     xx(i,j) = (i-1)*dx ;  zz(i,j) = (j-1)*dz
  enddo ; enddo
  
  flux_x = 0.0 ; flux_z = 0.0 

  !flux_x = sin(2*pi*xx_1)
  flux_z = sin(2*pi*zz_2)

  div_a = div(flux_x,flux_z)
  !div_b = 2*pi*cos(2*pi*xx)
  div_b = 2*pi*cos(2*pi*zz)

  call gropn(1)
  call grfrm
  call grswnd( 0.0, 1.0, 0.0, 1.0 )
  call uspfit
  call grstrf
  call usdaxs
  call udcntr( real(div_a), nx, nx, nz )

  !call usgrph( nx, real(xx(:,1)), real(div_a(:,1)) )

  call grfrm
  call grswnd( 0.0, 1.0, 0.0, 1.0 )
  call uspfit
  call grstrf
  call usdaxs
  call udcntr( real(div_b), nx, nx, nz )
  
  call grcls

  stop
end program test_div




