program test_diffuse

  use dimension
  use coordinates
  use math
  use diffuse

  implicit none
  double precision :: pi
  double precision,allocatable  :: f(:,:), dfdt(:,:)
  double precision,allocatable  :: diff_x(:,:), diff_z(:,:)

!============================== ɸ ==============================
  call coordinates_init

  pi = atan(1.0d0)*4.0

  allocate( f(nx,nz), dfdt(nx,nz) )
  allocate( diff_x(nx-1,nz), diff_z(nx,nz-1) )

  diff_x = 1.0 ; diff_z = 1.0

  !f = sin(pi*xx)*sin(pi*zz)
  !f = cos(pi*xx)* cos(pi*zz)
  !f = cos(2*pi*xx)*cos(2*pi*zz)
  f = sin(2*pi*xx)*cos(2*pi*zz)
  !f = cos(2*pi*xx)*sin(2*pi*zz)
  !f = sin(2*pi*xx)*sin(2*pi*zz)
  !f = (zz-0.5)**2 * (xx-0.5)**2

  !dfdt = diff_T( diff_x, diff_z, f )
  !dfdt = diff_term( diff_x, diff_z, f )

  otfix_top  =.false.  ; otfix_bottom = .false.
  otfix_left = .false. ; otfix_right  = .false. 
  tfbtm = 0.0; tftop = 0.0 ; tfleft = 0.0; tfright =0.0

  !dfdt = diff_T( diff_x, diff_z, f )
  dfdt = diff_C( diff_x, diff_z, f )

  call gropn(1)
    call grfrm
    call grsvpt( 0.2, 0.8, 0.2, 0.8 )
    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
    call grstrn( 1 )
    call grstrf
    call usdaxs
    !call uegtla( 0.0, 1.0, 0.02 ) 
    !call udgcla( 0.0, 1.0, 0.1 )
    call udcntr( real(f), nx, nx, nz )

    call grfrm
    call grsvpt( 0.2, 0.8, 0.2, 0.8 )
    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
    call grstrn( 1 )
    call grstrf
    call usdaxs
    !call uegtla( 0.0, 1.0, 0.02 ) 
    !call udgcla( 0.0, 1.0, 0.1 )
    call udcntr( real(dfdt), nx, nx, nz )
    write(6,*) avr_xz(dfdt)

    call grfrm
    call usgrph( nz, real(x), real(dfdt(:,nz)) )
    call uulin ( nz, real(x), real(dfdt(:,1)) )

    call grfrm
    call usgrph( nz, real(z), real(dfdt(nx,:)) )
    call uulin( nz, real(z), real(dfdt(1,:)) )

    call grcls
    stop
  end program test_diffuse

