program test_dblfft

  !use dimension
  use coordinates, only : dx, dz
  use dblfft
  use dblsint
  use dblfftsin
  use dblsinfft
  use poisson
  implicit none

      integer,parameter          :: nx=21, nz=17
      double precision,parameter :: xlngth=1.0, zlngth=2.0
      double precision, dimension(nx,nz)  :: xx, zz, psi, psi_f, psi_b
      integer :: i, j
      double precision :: pi

      pi = atan(1.0)*4.0

      dx = xlngth/real(nx-1) ; dz = zlngth/real(nz-1)
      do j=1,nz
         do i=1,nx
            xx(i,j) = (i-1)*dx
            zz(i,j) = (j-1)*dz
         enddo
      enddo

      !psi = sin(2*pi*xx)*sin(4*pi*zz) 
      !psi = cos(2*pi*xx)*sin(4*pi*zz) 
      psi = sin(2*pi*xx)*cos(4*pi*zz) 
      !psi = cos(2*pi*xx)*cos(4*pi*zz) 

!
! dblsint Υå
!!$      psi_f(2:nx-1,2:nz-1) = dblsintf(psi(2:nx-1,2:nz-1))
!!$      psi_b(2:nx-1,2:nz-1) = dblsintb(psi_f(2:nx-1,2:nz-1))
!!$      psi_b(nx,:) =0.0; psi_b(1,:) =0.0 ; psi_b(:,nz) = 0.0; psi_b(:,1)=0.0

! dblfftsin Υå
!!$      psi_f(1:nx-1,2:nz-1) = dblfftfsin(psi(1:nx-1,2:nz-1))
!!$      psi_b(1:nx-1,2:nz-1) = dblfftbsin(psi_f(1:nx-1,2:nz-1))
!!$      psi_b(nx,:) =psi_b(1,:) ; psi_b(:,nz) = 0.0; psi_b(:,1)=0.0

! dblsinfft Υå
      psi_f(2:nx-1,1:nz-1) = dblsinfftf(psi(2:nx-1,1:nz-1))
      psi_b(2:nx-1,1:nz-1) = dblsinfftb(psi_f(2:nx-1,1:nz-1))
      psi_b(nx,:) = 0.0 ; psi_b(1,:)=0.0 ; psi_b(:,nz) = psi_b(:,1)

! dblfft Υå
!!$      psi_f(1:nx-1,1:nz-1) = dblfftf(psi(1:nx-1,1:nz-1))
!!$      psi_b(1:nx-1,1:nz-1) = dblfftb(psi_f(1:nx-1,1:nz-1))
!!$      psi_b(nx,:) = psi_b(1,:) ; psi_b(:,nz) = psi_b(:,1)

      do j=1,7
         write(6,'(I4,5f8.3)') j, ( psi_f(i,j), i=1,5 )
         !write(6,*) j, ( psi(i,j), i=1,5 )
      enddo

      call gropn(1)
      call grfrm
      call grswnd( 0.0, 1.0, 0.0, 1.0 )
      call uspfit
      call grstrf
      call usdaxs
      call udcntr( real(psi), nx, nx, nz )

      call grfrm
      call grswnd( 0.0, 1.0, 0.0, 1.0 )
      call uspfit
      call grstrf
      call usdaxs
      call udcntr( real(psi_b), nx, nx, nz )

      call grcls

      stop
    end program test_dblfft

    
