program test_advect

  use base
  use advect
  use average

  implicit none
  double precision :: pi
  double precision,allocatable  :: psi(:,:), f(:,:), dfdt(:,:)

!============================== ɸ ==============================
  call coordinates_init
  call timestep_init

  pi = atan(1.0d0)*4.0

  allocate( psi(nx,nz), f(nx,nz), dfdt(nx,nz) )

  !psi = sin(pi*xx)*sin(pi*zz)
  !psi = cos(2*pi*xx)*sin(2*pi*zz)
  !psi = sin(2*pi*xx)
  !psi = xx
  psi = -zz
  !psi = ( (xx-0.5)**2 + (zz-0.5)**2 ) * 0.5  ! βž

  !f = exp( - ( (xx-0.3)**2 + (zz-0.3)**2 )/0.1**2 )
  !f = sin(2*pi*zz)
  f = (xx-0.3)*exp( - ( (xx-0.3)**2 + (zz-0.3)**2 )/0.1**2 )
  !f (nx/2:,:) = 0.0 ;  f (:nx/10,:) = 0.0
  !f (:,nz/2:) = 0.0 ;  f (:,:nz/10) = 0.0

  !f = xx 
  !f = xx**2 + zz**2

  call gropn(1)

  do istep=1,nt
    !f = f - dt * jacobian_arakawa(psi,f) 
    f = f - dt * jacobian_mpdata(psi,f) 

    if ( mod(istep,ndisp) .eq. 0 )then
       write (6,*) 'step = ', istep, 'time =', time, avr_xz(f)

!!$    call grfrm
!!$    call grsvpt( 0.2, 0.8, 0.2, 0.8 )
!!$    call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
!!$    call grstrn( 1 )
!!$    call grstrf
!!$    call usdaxs
!!$    !call uegtla( 0.0, 1.0, 0.02 ) 
!!$    !call udgcla( 0.0, 1.0, 0.1 )
!!$    call udcntr( real(psi), nx, nx, nz )

       call grfrm
       call grsvpt( 0.2, 0.8, 0.2, 0.8 )
       call sgswnd( real(x(1)), real(x(nx)), real(z(1)), real(z(nz)) )
       call grstrn( 1 )
       call grstrf
       call usdaxs
       !call uegtla( 0.0, 1.0, 0.02 ) 
       !call udgcla( 0.0, 1.0, 0.05 )
       call udgcla( -1.0, 1.0, 0.05 )
       !call udgcla( -0.1, 0.1, 0.005 )
       call udcntr( real(f), nx, nx, nz )

!       call usgrph( nx, real(x), real(f(:,nz/3)) )
    endif
 enddo
 call grcls
 stop
end program test_advect
