! package poisson
!     for 2-D thermal convection in a square box. 
!
! 99/05/25  S. Takehiro
!
!=======================================================================
module poisson

  use coordinates, only : xcycl, zcycl
  use dblfft
  use dblsint
  use dblfftsin
  use dblsinfft
  implicit none

  private
  public :: laplace_inv

  contains

  function laplace_inv(a)    !  0 ޤ laplacian ղ
    double precision, dimension(:,:)                  :: a
    double precision, dimension(size(a,1),size(a,2))  :: laplace_inv

    if ( xcycl .and. zcycl ) then
       laplace_inv = laplace_inv_dblfft(a)
    else if ( (.not. xcycl) .and. zcycl ) then
       laplace_inv = laplace_inv_dblsinfft(a)
    else if ( xcycl .and. (.not. zcycl) ) then
       laplace_inv = laplace_inv_dblfftsin(a)
    else
       laplace_inv = laplace_inv_dblsint(a)
    endif

  end function laplace_inv

end module poisson
