! package dblsint
!     for 2-D thermal convection in a square box. 
!
! 99/10/02  S. Takehiro
!
!=======================================================================
module dblsint

  use coordinates, only : dx, dz
  implicit none
  private
  public dblsintf, dblsintb, laplace_inv_dblsint

  contains
 !----------------------------------------------------------------------
  function dblsintz(a)

    double precision, dimension(:,:)  :: a   ! ͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsintz

    double precision, dimension(3*(size(a,1)+15))  :: wsavex
    double precision, dimension(3*(size(a,2)+15))  :: wsavez
    double precision, dimension(:,:), allocatable    :: x
    double precision, dimension(:,:), allocatable    :: xt
    integer  :: nx, nz

    nx=size(a,1) ; nz=size(a,2)

    call VSINTI(nx,wsavex)
    call VSINTI(nz,wsavez)

    allocate ( x(nx,nz+1), xt(nx,nz+1) )
    x(1:nx,1:nz)=a
    call VSINT(nx,nz,x,xt,nx,wsavez)
    dblsintz=x(1:nx,1:nz)
    deallocate ( x, xt )

    allocate ( x(nz,nx+1), xt(nz,nx+1) )
    x(1:nz,1:nx) = transpose( dblsintz )
    call VSINT(nz,nx,x,xt,nz,wsavex)
    dblsintz=transpose( x(1:nz,1:nx) )
    deallocate ( x, xt )

  end function dblsintz

 !----------------------------------------------------------------------
  function dblsintf(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsintf

    dblsintf = dblsintz(a)
  end function dblsintf

  function dblsintb(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsintb

    dblsintb = dblsintz(a)

  end function dblsintb

 !----------------------------------------------------------------------
  function laplace_inv_dblsint(a)  !  0 ޤ laplacian ղ
    double precision, dimension(:,:)                  :: a
    double precision, dimension(size(a,1),size(a,2))  :: laplace_inv_dblsint
    double precision, dimension(:,:), allocatable  :: work

    integer           :: nx, nz, i, j
    double precision  :: pi, xlength, zlength

    pi = atan(1.0d0)*4

    nx=size(a,1)      ; nz=size(a,2)
    allocate( work(nx-2,nz-2) )
    xlength=(nx-1)*dx ; zlength=(nz-1)*dz
    work = a(2:nx-1,2:nz-1)

    work=dblsintf(work)
    do j=1,nz-2 ; do i=1,nx-2
       work(i,j)= - work(i,j)/ & 
          &      ( (pi*i/xlength)**2 + (pi*j/zlength)**2 )
    enddo; enddo
    work = dblsintb(work)

    laplace_inv_dblsint(2:nx-1,2:nz-1) = work
    laplace_inv_dblsint(1,:)  = 0.0
    laplace_inv_dblsint(nx,:) = 0.0
    laplace_inv_dblsint(:,1)  = 0.0
    laplace_inv_dblsint(:,nz) = 0.0

  end function laplace_inv_dblsint

end module dblsint
