! package dblsinfft
!     for 2-D thermal convection in a square box. 
!
! 99/10/02  S. Takehiro
!
!=======================================================================
module dblsinfft

  use coordinates, only : dx, dz
  implicit none
  private
  public dblsinfftf, dblsinfftb, laplace_inv_dblsinfft

  contains
 !----------------------------------------------------------------------
  function dblsinfftz(a,oback)   ! 2 ťաꥨѴ (x sin Ѵ, z Fourier)
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsinfftz
    logical :: oback

    double precision, dimension(3*size(a,1)+15)  :: wsavex
    double precision, dimension(size(a,2)+15)    :: wsavez
    double precision, dimension(:,:), allocatable    :: x
    double precision, dimension(:,:), allocatable    :: xt
    integer  :: nx, nz

    nx=size(a,1) ; nz=size(a,2)

    call VSINTI(nx,wsavex)
    call VRFFTI(nz,wsavez)

    allocate ( x(nx,nz), xt(nx,nz) )

    x=a
    if ( oback ) then
       call VRFFTB(nx,nz,x,xt,nx,wsavez)
    else
       call VRFFTF(nx,nz,x,xt,nx,wsavez)
    endif
    dblsinfftz = x
    deallocate ( x, xt )

    allocate ( x(nz,nx+1), xt(nz,nx+1) )
    x(1:nz,1:nx) = transpose( dblsinfftz )
    call VSINT(nz,nx,x,xt,nz,wsavex)
    dblsinfftz=transpose( x(1:nz,1:nx) )

    deallocate ( x, xt )

  end function dblsinfftz

 !----------------------------------------------------------------------
  function dblsinfftf(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsinfftf

    dblsinfftf = dblsinfftz(a,.false.)
  end function dblsinfftf

  function dblsinfftb(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsinfftb

    dblsinfftb = dblsinfftz(a,.true.)
  end function dblsinfftb

 !----------------------------------------------------------------------
  function laplace_inv_dblsinfft(a) ! ͤޤ laplacian ղ
    double precision, dimension(:,:)                  :: a
    double precision, dimension(size(a,1),size(a,2))  :: laplace_inv_dblsinfft
    double precision, dimension(:,:), allocatable     :: work

    integer           :: nx, nz, i, j, ikz
    double precision  :: pi, xlength, zlength

    pi = atan(1.0d0)*4

    nx=size(a,1)      ; nz=size(a,2)
    allocate( work(nx-2,nz-1) )
    xlength=(nx-1)*dx ; zlength=(nz-1)*dz
    work = a(2:nx-1,1:nz-1)

    work=dblsinfftf(work)
    do j=1,nz-1 ; do i=1,nx-2
       ikz = int(j/2)            ! Ǥȿ(0,1,1,2,2,..)
       work(i,j)= - work(i,j)/ & 
          &      ( (pi*i/xlength)**2 + (2*pi*ikz/zlength)**2 )
    enddo; enddo
    work = dblsinfftb(work)

    laplace_inv_dblsinfft(2:nx-1,1:nz-1) = work
    laplace_inv_dblsinfft(1,:)  = 0.0
    laplace_inv_dblsinfft(nx,:) = 0.0
    laplace_inv_dblsinfft(:,nz) = laplace_inv_dblsinfft(:,1)

  end function laplace_inv_dblsinfft

end module dblsinfft

