! package dblfftsin
!     for 2-D thermal convection in a square box. 
!
! 99/10/02  S. Takehiro
!
!=======================================================================
module dblfftsin

  use coordinates, only : dx, dz
  implicit none
  private
  public dblfftfsin, dblfftbsin, laplace_inv_dblfftsin

  contains
 !----------------------------------------------------------------------
  function dblfftsinz(a,oback)   ! 2 ťաꥨѴ (x  Fourier, z sin Ѵ)
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblfftsinz
    logical :: oback

    double precision, dimension(size(a,1)+15)    :: wsavex
    double precision, dimension(3*size(a,2)+15)  :: wsavez
    double precision, dimension(:,:), allocatable    :: x
    double precision, dimension(:,:), allocatable    :: xt
    integer  :: nx, nz

    nx=size(a,1) ; nz=size(a,2)

    call VRFFTI(nx,wsavex)
    call VSINTI(nz,wsavez)

    allocate ( x(nx,nz+1), xt(nx,nz+1) )
    x(1:nx,1:nz)=a
    call VSINT(nx,nz,x,xt,nx,wsavez)
    dblfftsinz=x(1:nx,1:nz)
    deallocate ( x, xt )

    allocate( x(nz,nx), xt(nz,nx) )
    x=transpose( dblfftsinz )
    if ( oback ) then
       call VRFFTB(nz,nx,x,xt,nz,wsavex)
    else
       call VRFFTF(nz,nx,x,xt,nz,wsavex)
    endif
    dblfftsinz=transpose( x )
    deallocate ( x, xt )

  end function dblfftsinz

 !----------------------------------------------------------------------
  function dblfftfsin(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblfftfsin

    dblfftfsin = dblfftsinz(a,.false.)
  end function dblfftfsin

  function dblfftbsin(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblfftbsin

    dblfftbsin = dblfftsinz(a,.true.)
  end function dblfftbsin

 !----------------------------------------------------------------------
  function laplace_inv_dblfftsin(a) ! ͤޤ laplacian ղ
    double precision, dimension(:,:)                  :: a
    double precision, dimension(size(a,1),size(a,2))  :: laplace_inv_dblfftsin
    double precision, dimension(:,:), allocatable     :: work

    integer           :: nx, nz, i, j, ikx
    double precision  :: pi, xlength, zlength

    pi = atan(1.0d0)*4

    nx=size(a,1)      ; nz=size(a,2)
    allocate( work(nx-1,nz-2) )
    xlength=(nx-1)*dx ; zlength=(nz-1)*dz
    work = a(1:nx-1,2:nz-1)

    work=dblfftfsin(work)
    do j=1,nz-2 ; do i=1,nx-1
       ikx = int(i/2)            ! Ǥȿ(0,1,1,2,2,..)
       work(i,j)= - work(i,j)/ & 
          &      ( (2*pi*ikx/xlength)**2 + (pi*j/zlength)**2 )
    enddo; enddo
    work = dblfftbsin(work)

    laplace_inv_dblfftsin(1:nx-1,2:nz-1) = work
    laplace_inv_dblfftsin(:,1)  = 0.0
    laplace_inv_dblfftsin(:,nz) = 0.0
    laplace_inv_dblfftsin(nx,:) = laplace_inv_dblfftsin(1,:)

  end function laplace_inv_dblfftsin

end module dblfftsin
