! package dblfft
!     for 2-D thermal convection in a square box. 
!
! 99/10/02  S. Takehiro
!
!=======================================================================
module dblfft

  use coordinates, only : dx, dz
  implicit none
  private
  public dblfftf, dblfftb, laplace_inv_dblfft

  contains
 !----------------------------------------------------------------------
  function dblfftz(a,oback)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblfftz
    logical :: oback

    double precision, dimension(size(a,1)+15)  :: wsavex
    double precision, dimension(size(a,2)+15)  :: wsavez
    double precision, dimension(:,:), allocatable    :: x
    double precision, dimension(:,:), allocatable    :: xt
    integer  :: nx, nz

    nx=size(a,1) ; nz=size(a,2)
    allocate ( x(nx,nz), xt(nx,nz) )

    call VRFFTI(nx,wsavex)
    call VRFFTI(nz,wsavez)

    x=a
    if ( oback ) then
       call VRFFTB(nx,nz,x,xt,nx,wsavez)
    else
       call VRFFTF(nx,nz,x,xt,nx,wsavez)
    endif
    dblfftz = x 
    deallocate ( x, xt )

    allocate ( x(nz,nx), xt(nz,nx) )
    xt = transpose( dblfftz )
    if ( oback ) then
       call VRFFTB(nz,nx,xt,x,nz,wsavex)
    else
       call VRFFTF(nz,nx,xt,x,nz,wsavex)
    endif
    dblfftz=transpose( xt )
    deallocate ( x, xt )

  end function dblfftz

 !----------------------------------------------------------------------
  function dblfftf(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblfftf

    dblfftf = dblfftz(a,.false.)
  end function dblfftf

  function dblfftb(a)   ! 2 ťաꥨѴ
    double precision, dimension(:,:)  :: a   ! Ҷͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblfftb

    dblfftb = dblfftz(a,.true.)
  end function dblfftb

 !----------------------------------------------------------------------
  function laplace_inv_dblfft(a)  !  0 ޤ laplacian ղ
    double precision, dimension(:,:)                  :: a
    double precision, dimension(size(a,1),size(a,2))  :: laplace_inv_dblfft
    double precision, dimension(:,:), allocatable     :: work

    integer           :: nx, nz, i, j, ikx, ikz
    double precision  :: pi, xlength, zlength

    pi = atan(1.0d0)*4

    nx=size(a,1)      ; nz=size(a,2)
    allocate ( work(nx-1,nz-1) )
    xlength=(nx-1)*dx ; zlength=(nz-1)*dz
    work = a(1:nx-1,1:nz-1)

    work=dblfftf(work)
    do j=1,nz-1 ; do i=1,nx-1
       ikx = int(i/2) ; ikz = int(j/2)      ! Ǥȿ(0,1,1,2,2,..)
       if ( (ikx .eq. 0) .and. (ikz .eq. 0) )then
          work(i,j)= 0.0                    ! ľήʬ 0 Ǥ٤
       else
          work(i,j)= - work(i,j)/ & 
               &      ( (2*pi*ikx/xlength)**2 + (2*pi*ikz/zlength)**2 )
       endif
    enddo; enddo

    laplace_inv_dblfft(1:nx-1,1:nz-1) = dblfftb(work)
    laplace_inv_dblfft(nx,:) = laplace_inv_dblfft(1,:)
    laplace_inv_dblfft(:,nz) = laplace_inv_dblfft(:,1)

  end function laplace_inv_dblfft
end module dblfft
