! package poisson
!     for 2-D thermal convection in a square box. 
!
! 99/05/27  S. Takehiro  utilize vsint, vsinti
!
!=======================================================================
module poisson

  use coordinates, only : dx, dz
  implicit none

  contains

  function dblsint(a)

    double precision, dimension(:,:)  :: a   ! ͤ 2 
    double precision, dimension(size(a,1),size(a,2)) :: dblsint

    double precision, dimension(3*(size(a,1)+15))  :: wsavex
    double precision, dimension(3*(size(a,2)+15))  :: wsavez
    double precision, dimension(:,:), allocatable  :: x
    double precision, dimension(:,:), allocatable  :: xt
    integer  :: nx, nz

    nx=size(a,1) ; nz=size(a,2)

    call VSINTI(nx,wsavex) ; call VSINTI(nz,wsavez)

    allocate ( x(nx,nz+1), xt(nx,nz+1) )
    x(1:nx,1:nz)=a
    call VSINT(nx,nz,x,xt,nx,wsavez)
    dblsint=x(1:nx,1:nz)
    deallocate ( x, xt )

    allocate ( x(nz,nx+1), xt(nz,nx+1) )
    x(1:nz,1:nx) = transpose( dblsint )
    call VSINT(nz,nx,x,xt,nz,wsavex)
    dblsint=transpose( x(1:nz,1:nx) )
    deallocate ( x, xt )

  end function dblsint

  function laplace_inv(a)    !  0 ޤ laplacian ղ
    double precision, dimension(:,:)                  :: a
    double precision, dimension(size(a,1),size(a,2))  :: laplace_inv
    double precision, dimension(size(a,1)-2,size(a,2)-2)  :: work

    integer          :: nx, nz, i, j
    double precision             :: pi, xlength, zlength

    pi = atan(1.0)*4

    nx=size(a,1)      ; nz=size(a,2)
    xlength=(nx-1)*dx ; zlength=(nz-1)*dz
    work = a(2:nx-1,2:nz-1)

    work=dblsint(work)
    do j=1,nz-2 ; do i=1,nx-2
       work(i,j)= - work(i,j)/ & 
          &      ( (pi*i/xlength)**2 + (pi*j/zlength)**2 )
    enddo; enddo
    work = dblsint(work)

    laplace_inv=0.0
    laplace_inv(2:nx-1,2:nz-1) = work

  end function laplace_inv

end module poisson
