! package averages
!     for 2-D thermal convection in a square box. 
!
! 99/08/24  S. Takehiro
! 
!======================================================================
module average

  use coordinates, only : dx, dz
  implicit none
  private

  public :: avr_xz, avr_x, avr_z

  contains

    double precision function avr_xz(a)
      double precision :: a(:,:)
      integer :: nx, nz
      nx = size(a,1) ; nz = size(a,2)

      avr_xz =    sum( a(2:nx-1,2:nz-1) ) * dx * dz                 &
           &   + (   sum(a(2:nx-1,1)) + sum(a(2:nx-1,nz))           & 
           &       + sum(a(1,2:nz-1)) + sum(a(nx,2:nz-1)) )/2*dx*dz &
           &   + ( a(1,1) + a(1,nz) + a(nx,1) + a(nx,nz) )/4*dx*dz 
    end function avr_xz

    function avr_x(a)
      double precision :: a(:,:)
      double precision :: avr_x(size(a,2))
      integer :: i, nx, nz
      nx = size(a,1) ; nz = size(a,2)

      do i = 1, nz
         avr_x(i) =  a(1,i) * dx/2 + sum( a(2:nx-1,i) ) * dx + a(nx,i) * dx/2 
      enddo
    end function avr_x

    function avr_z(a)
      double precision :: a(:,:)
      double precision :: avr_z(size(a,1))

      integer :: i, nx, nz
      nx = size(a,1) ; nz = size(a,2)

      do i = 1, nx
         avr_z(i) =  a(i,1) * dz/2 + sum( a(i,2:nz-1) ) * dz + a(i,nz) * dz/2 
      enddo
    end function avr_z

  end module average
