! package derivative_mpdata
!     for 2-D thermal convection in a square box. 
!
! 99/05/05  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/08/20  S. Takehiro   B.C. 
! 99/08/24  S. Takehiro   Ǥͤ. ʬ 2/4 ܤ. ¸
! 99/08/29  S. Takehiro   0 򤵤뤿, 줢Ʒ׻
! 99/09/06  S. Takehiro   줢
! 
!======================================================================
module dynbase_mpdata
  use namelist
  use dimension
  use coordinates, only : dx, dz
  use timestep, only    : dt
  use mpdata_gridtrans
  use mpdata_derivatives
  implicit none

  contains
   !------------------------------------------
    function jacobian_mpdata(psi,f)
      double precision, dimension(nx,nz),   intent(in) :: f   ! scalar (on SG)
      double precision, dimension(nx,nz),   intent(in) :: psi ! scalar (on SG)
      double precision, dimension(nx,nz) :: jacobian_mpdata   ! scalar (on SG)

      ! 򹭤ΰǷ׻
      double precision, dimension(:,:), allocatable  :: u_vgz ! flow   (on VGZ)
      double precision, dimension(:,:), allocatable  :: w_vgx ! flow   (on VGX)
      double precision, dimension(:,:), allocatable  :: u     ! flow   (on VGX)
      double precision, dimension(:,:), allocatable  :: w     ! flow   (on VGZ)
      double precision, dimension(:,:), allocatable  :: f_w   ! scalor (on SG)

      double precision :: eps = 1e-15      ! MPDATA 0 
      integer          :: itr = 3          ! MPDATA ȿ

      logical  :: ofirst=.true.

      namelist /NMDJAC/ eps, itr

      if ( ofirst ) then 
         ofirst = .false.
         write(6,*)'<<< ADVECTION SCHEME BY MPDATA 99/09/06 >>>'

         if( .not. rewnml() ) write( nm_write_num, NML=NMDJAC )
         read( nm_read_num, NML=NMDJAC, end=999 )
999      write( nm_write_num, NML=NMDJAC )
         eps_mpdata = eps ; mpdata_iteration = itr
      endif

      allocate( u_vgz(nx,0:nz), w_vgx(0:nx,nz) )
      allocate( u(0:nx,nz), w(nx,0:nz) )
      allocate( f_w(nx,nz) )

      u_vgz(:,1:nz-1) = -( psi(:,2:nz) - psi(:,1:nz-1) )/dz
      u_vgz(:,0) = 0.0 ; u_vgz(:,nz) = 0.0
      u = vgz2vgx(u_vgz) 
      u(1:nx-1,1) = 2 * u(1:nx-1,1) ; u(1:nx-1,nz) = 2 * u(1:nx-1,nz) 

      w_vgx(1:nx-1,:) =   (psi(2:nx,:) - psi(1:nx-1,:))/dx
      w_vgx(0,:) = 0.0 ; w_vgx(nx,:) = 0.0
      w = vgx2vgz(w_vgx)
      w(1,1:nz-1) = 2 * w(1,1:nz-1) ; w(nx,1:nz-1) = 2 * w(nx,1:nz-1) 


      f_w = f                                  ! 夲줷ʤ
      jacobian_mpdata = flux_div_mpdata(f_w,u,w)

      !jacobian_mpdata = flux_div_mpdata(f,u,w)
      !jacobian_mpdata = &        ! ñʤήʬξ
      !   & div(flux_x_upstream(f,u),flux_z_upstream(f,w))

      deallocate( u_vgz, w_vgx )
      deallocate( u, w )
      deallocate( f_w )

    end function jacobian_mpdata
   
  end module dynbase_mpdata
