! package dynamics_diffusion
!     for 2-D thermal convection in a square box. 
!
! 99/08/20  S. Takehiro  
! 99/09/26  S. Takehiro  cyclic boundary in the x direction 
!
!================== Ȼ׻(եå) ====================
module dynbase_diffusion_cyclic

  use dimension
  use derivative_cyclic
  use coordinates,    only : dx, dz
  use dynbase_boundary

  private
  public  :: diff_T, diff_C, visc_term

  contains

   !======================= ǮȻ =======================
    function diff_T( diff_Tx, diff_Tz, T )

      double precision, dimension(nx,nz)      :: T
      double precision, dimension(nx-1,nz)    :: diff_Tx
      double precision, dimension(nx,nz-1)    :: diff_Tz
      double precision, dimension(nx,nz)      :: diff_T

      diff_T = diff_term( diff_Tx, diff_Tz, T )

     !----- եåν :  1/2  ----
      if ( .not. otfix_top ) then
         diff_T(:,nz) = diff_T(:,nz) + tftop / (dz/2)
         !diff_T(:,nz) = diff_T(:,nz) + tftop / dz
      endif

      if ( .not. otfix_bottom ) then
         diff_T(:,1) = diff_T(:,1) - tfbtm / (dz/2)
         !diff_T(:,1) = diff_T(:,1) - tfbtm / dz
      endif

    end function diff_T

   !======================= Ȼ =======================

    function diff_C( diff_Cx, diff_Cz, C )

      double precision, dimension(nx,nz)      :: C
      double precision, dimension(nx-1,nz)    :: diff_Cx
      double precision, dimension(nx,nz-1)    :: diff_Cz
      double precision, dimension(nx,nz)      :: diff_C

      diff_C = diff_term( diff_Cx, diff_Cz, C )

     !----- եåν :  1/2  ----
      if ( .not. ocfix_top ) then
         diff_C(:,nz) = diff_C(:,nz) + cftop / (dz/2)
      endif

      if ( .not. ocfix_bottom ) then
         diff_C(:,1) = diff_C(:,1) - cfbtm / (dz/2)
      endif

    end function diff_C

   !======================= Ǵ + =======================
    function visc_term( rmu, psi )
      double precision, dimension(nx,nz) :: rmu
      double precision, dimension(nx,nz) :: psi
      double precision, dimension(nx,nz) :: visc_term

      double precision, dimension(:,:), allocatable    :: psitmp
      double precision, dimension(:,:), allocatable    :: dx2dz2psi, dxdzpsi

      allocate( psitmp(nx,0:nz+1) )
      allocate( dx2dz2psi(nx,0:nz+1), dxdzpsi(nx,0:nz+1) )

      psitmp = 0.0
      psitmp(:,1:nz) = psi

      if ( oslip )then                         !  free-slip 
         psitmp(:,0)    = 2*psitmp(:,1)  - psitmp(:,2)
         psitmp(:,nz+1) = 2*psitmp(:,nz) - psitmp(:,nz-1)

      else                                     !  rigid
         psitmp(:,0)    = psitmp(:,2)
         psitmp(:,nz+1) = psitmp(:,nz-1)
      endif

      dx2dz2psi = dxd2(psitmp) - dzd2(psitmp)
      dxdzpsi   = dxdz(psitmp)

      visc_term =    dxd2( rmu*dx2dz2psi(:,1:nz) ) &
               &   - dzd2( rmu*dx2dz2psi(:,1:nz) ) &
               &   + 4*dxdz( rmu*dxdzpsi(:,1:nz) )

      deallocate( psitmp )
      deallocate( dx2dz2psi, dxdzpsi )

    end function visc_term

  end module dynbase_diffusion
