! package dynamics_diffusion
!     for 2-D thermal convection in a square box. 
!
! 99/08/20  S. Takehiro  
! 99/08/26  S. Takehiro  zeta ׻ˤ. 
! 99/09/26  S. Takehiro  
!
!============================  ==============================
module dynbase_boundary_cyclic

  use dimension
  use namelist
  use derivative
  implicit none
  include 'netcdf.inc'

! [NMBNDD]  ϳض
    logical :: oslip = .true.             ! ϳض凉å

! [NMBNDR]  Ǯ
    logical ::  otfix_top    = .true.     ! Ǯ凉å
    logical ::  otfix_bottom = .true.     ! 

    double precision    ::  tftop   = 0.0D0 ! 嶭( or ٷ)
    double precision    ::  tfbtm   = 1.0D0 ! 

! [NMBNDR]  
    logical ::  ocfix_top    = .false.    ! 凉å
    logical ::  ocfix_bottom = .false.    ! 

    double precision    ::  cftop   = 0.0D0 ! 嶭( or )
    double precision    ::  cfbtm   = 0.0D0 ! 

  private
    public  ::  oslip
    public  ::  otfix_top, otfix_bottom
    public  ::  tftop, tfbtm
    public  ::  ocfix_top, ocfix_bottom
    public  ::  cftop, cfbtm

    public  :: dynbase_boundary_init_T, dynbase_boundary_init_C
    public  :: dynbase_boundary_init_D, dynbase_boundary_init
    public  :: dynbase_boundary_T, dynbase_boundary_C
    public  :: dynbase_boundary_zeta
    !public  :: zeta_psi

    public  :: dynbase_boundary_output_nc
    public  :: dynbase_boundary_input_nc

  contains

 !========================== ѥ᥿ ============================

   !--------------- ϳضѥ᥿ ---------------
    subroutine dynbase_boundary_init_D
      namelist /NMBNDD/ oslip

      if( .not. rewnml() ) write( nm_write_num, NML=NMBNDD )
      read( nm_read_num, NML=NMBNDD, end=297 )
 297  write( nm_write_num, NML=NMBNDD )
    end subroutine dynbase_boundary_init_D

    subroutine dynbase_boundary_D_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_int1 &
         & ( ncid, NF_GLOBAL, 'oslip', NF_BYTE, 1, oslip )
    end subroutine dynbase_boundary_D_output_nc

    subroutine dynbase_boundary_D_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_int1 &
           & ( ncid, NF_GLOBAL, 'oslip', oslip )
    end subroutine dynbase_boundary_D_input_nc

   !--------------- Ǯѥ᥿ ---------------
    subroutine dynbase_boundary_init_T
      namelist /NMBNDT/ otfix_top, tftop, otfix_bottom, tfbtm

      if( .not. rewnml() ) write( nm_write_num, NML=NMBNDT )
      read( nm_read_num, NML=NMBNDT, end=299 )
 299  write( nm_write_num, NML=NMBNDT )
    end subroutine dynbase_boundary_init_T

    subroutine dynbase_boundary_T_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_int1 &
         & ( ncid, NF_GLOBAL, 'otfix_top', NF_BYTE, 1, otfix_top )
      status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'tftop', NF_DOUBLE, 1, tftop )

      status = nf_put_att_int1 &
         & ( ncid, NF_GLOBAL, 'otfix_bottom', NF_BYTE, 1, otfix_bottom )
      status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'tfbtm', NF_DOUBLE, 1, tfbtm )

    end subroutine dynbase_boundary_T_output_nc

    subroutine dynbase_boundary_T_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_int1 &
           & ( ncid, NF_GLOBAL, 'otfix_top', otfix_top )
      status = nf_get_att_double &
           & ( ncid, NF_GLOBAL, 'tftop', tftop )

      status = nf_get_att_int1 &
           & ( ncid, NF_GLOBAL, 'otfix_bottom', otfix_bottom )
      status = nf_get_att_double &
           & ( ncid, NF_GLOBAL, 'tfbtm', tfbtm )

    end subroutine dynbase_boundary_T_input_nc

   !--------------- ѥ᥿ ---------------
    subroutine dynbase_boundary_init_C
      namelist /NMBNDC/ ocfix_top, cftop, ocfix_bottom, cfbtm

      if( .not. rewnml() ) write( nm_write_num, NML=NMBNDC )

      read( nm_read_num, NML=NMBNDC, end=298 )
 298  write( nm_write_num, NML=NMBNDC )
    end subroutine dynbase_boundary_init_C

    subroutine dynbase_boundary_C_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_int1 &
         & ( ncid, NF_GLOBAL, 'ocfix_top', NF_BYTE, 1, ocfix_top )
      status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'cftop', NF_DOUBLE, 1, cftop )

      status = nf_put_att_int1 &
         & ( ncid, NF_GLOBAL, 'ocfix_bottom', NF_BYTE, 1, ocfix_bottom )
      status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'cfbtm', NF_DOUBLE, 1, cfbtm )

    end subroutine dynbase_boundary_C_output_nc

    subroutine dynbase_boundary_C_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_int1 &
           & ( ncid, NF_GLOBAL, 'ocfix_top', ocfix_top )
      status = nf_get_att_double &
           & ( ncid, NF_GLOBAL, 'cftop', cftop )

      status = nf_get_att_int1 &
           & ( ncid, NF_GLOBAL, 'ocfix_bottom', ocfix_bottom )
      status = nf_get_att_double &
           & ( ncid, NF_GLOBAL, 'cfbtm', cfbtm )

    end subroutine dynbase_boundary_C_input_nc

   !--------------- ѥ᥿ ---------------
    subroutine dynbase_boundary_init
      call dynbase_boundary_init_T
      call dynbase_boundary_init_C
      call dynbase_boundary_init_D
    end subroutine dynbase_boundary_init

    subroutine dynbase_boundary_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ

      call dynbase_boundary_T_output_nc( ncid )
      call dynbase_boundary_C_output_nc( ncid )
      call dynbase_boundary_D_output_nc( ncid )
    end subroutine dynbase_boundary_output_nc

    subroutine dynbase_boundary_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ

      call dynbase_boundary_T_input_nc( ncid )
      call dynbase_boundary_C_input_nc( ncid )
      call dynbase_boundary_D_input_nc( ncid )
    end subroutine dynbase_boundary_input_nc

 !======================= Ǯ =======================
    subroutine dynbase_boundary_T( T )
      double precision, dimension(nx,nz)      :: T

     !----- Ǯ(ٸ) ----
      if ( otfix_top ) then                        ! z 
         T(:,nz) = tftop                           !   ٸ
      ! else
      !    T(:,nz) = T(:,nz-1) + tftop * dz        !   ٷٸ
      endif

      if ( otfix_bottom ) then                     ! z 
         T(:,1) = tfbtm                            !   ٸ
      ! else
      !   T(:,1) = T(:,2) - tfbtm * dz             !   ٷٸ
      endif

    end subroutine dynbase_boundary_T

 !=======================  =======================
    subroutine dynbase_boundary_C( C )
      double precision, dimension(nx,nz)      :: C

      if ( ocfix_top ) then                        ! z 
         C(:,nz) = cftop                           !   
      ! else
      !    C(:,nz) = C(:,nz-1) + cftop * dz        !   ٸ
      endif

      if ( ocfix_bottom ) then                     ! z 
         C(:,1) = cfbtm                            !   
      ! else
      !   C(:,1) = C(:,2) - cfbtm * dz             !   ٸ
      endif

    end subroutine dynbase_boundary_C

 !========================= ٶ׻ =========================
    subroutine dynbase_boundary_zeta( zeta, psi )
      double precision, dimension(nx,nz)    :: zeta
      double precision, dimension(nx,nz)    :: psi

      double precision, dimension(:,:), allocatable    :: psi_w
      double precision, dimension(:,:), allocatable    :: zeta_w

      allocate( psi_w(0:nx+1,0:nz+1), zeta_w(0:nx+1,0:nz+1) )

      psi_w = 0.0
      psi_w(1:nx,1:nz) = psi

      psi_w(0,:)    = psi_w(nx-1,:)
      psi_w(nx+1,:) = 2*psi_w(2,:)

      if ( oslip )then                         !  free-slip 
         psi_w(:,0)    = 2*psi_w(:,1)  - psi_w(:,2)
         psi_w(:,nz+1) = 2*psi_w(:,nz) - psi_w(:,nz-1)
      else                                     !  rigid
         psi_w(:,0)    = psi_w(:,1)
         psi_w(:,nz+1) = psi_w(:,nz)
      endif

      zeta_w = laplace(psi_w)
      
      !zeta(1,:)  = zeta_w(1,:)
      !zeta(nx,:) = zeta_w(nx,:)
      zeta(:,1)  = zeta_w(:,1)
      zeta(:,nz) = zeta_w(:,nz)

      deallocate( psi_w, zeta_w )

    end subroutine dynbase_boundary_zeta

  end module dynbase_boundary
