! package dynamics
!     for 2-D thermal convection in a square box. 
!
! 99/05/25  S. Takehiro   from derivative
! 99/08/21  S. Takehiro   $B6-3&$G$N(B flux $B$r(B implement. $BMWJ]B8@-$N%A%'%C%/(B.
! 99/08/24  S. Takehiro   $B6-3&$G$NCM$r=$@5(B. $BMWAGLL@QJ,(B 2/4 $BG\$9$k(B. 
!
!=======================================================================
module dynbase_arakawa

  use derivative, only     : j_arakawa
  use dynbase_boundary, only : oslip
  implicit none

  contains

  function jacobian_arakawa(psi,f)
    double precision, dimension(:,:)                     :: psi, f
    double precision, dimension(size(psi,1),size(psi,2)) :: jacobian_arakawa

    double precision, dimension(:,:),allocatable :: psi_w, f_w, jacob_w
    integer                                      :: nx, nz

    logical  :: ofirst=.true.

    if ( ofirst ) then 
       ofirst = .false.
       write(6,*)'<<< ADVECTION SCHEME BY ARAKAWA JACOBIAN 99/08/24 >>>'
    endif

    nx = size(psi,1) ; nz = size(psi,2)

    allocate( psi_w(0:nx+1,0:nz+1), f_w(0:nx+1,0:nz+1) )
    allocate( jacob_w(0:nx+1,0:nz+1) )

    ! $BN.@~(B
      psi_w = 0.0d0 ; psi_w(1:nx,1:nz) = psi
           psi_w(0,1:nz)    = psi(1,:) ;  psi_w(nx+1,1:nz) = psi(nx,:)
           psi_w(1:nx,0)    = psi(:,1) ;  psi_w(1:nx,nz+1) = psi(:,nz)
           psi_w(0,0)       = psi(1,1) 
           psi_w(nx+1,0)    = psi(nx,1) 
           psi_w(0,nz+1)    = psi(1,nz) 
           psi_w(nx+1,nz+1) = psi(nx,nz) 

      ! f $B$N6-3&>r7o$h$j(B. df/dn = 0 $B$rMQ$$$k(B
      f_w = 0.0 ; f_w(1:nx,1:nz) = f
           f_w(0,1:nz)    = f(2,:) ;  f_w(nx+1,1:nz) = f(nx-1,:)
           f_w(1:nx,0)    = f(:,2) ;  f_w(1:nx,nz+1) = f(:,nz-1)
           f_w(0,0)       = f(2,2) 
           f_w(nx+1,0)    = f(nx-1,2) 
           f_w(0,nz+1)    = f(2,nz-1) 
           f_w(nx+1,nz+1) = f(nx-1,nz-1) 

    jacob_w = j_arakawa(psi_w,f_w)
    jacobian_arakawa = jacob_w(1:nx,1:nz)

      ! $B6-3&$N=hM}(B. $BLL@QH>J,$J$N$G(B 2 $BG\$9$k(B
        jacobian_arakawa(1,2:nz-1) = jacobian_arakawa(1,2:nz-1)*2 
        jacobian_arakawa(nx,2:nz-1) = jacobian_arakawa(nx,2:nz-1)*2 
        jacobian_arakawa(2:nx-1,1) = jacobian_arakawa(2:nx-1,1)*2 
        jacobian_arakawa(2:nx-1,nz) = jacobian_arakawa(2:nx-1,nz)*2 

      ! $B6-3&$N=hM}(B. $B3Q$O(B 4 $BG\$9$k(B
        jacobian_arakawa(1,1) = jacobian_arakawa(1,1)*4
        jacobian_arakawa(nx,1) = jacobian_arakawa(nx,1)*4
        jacobian_arakawa(1,nz) = jacobian_arakawa(1,nz)*4
        jacobian_arakawa(nx,nz) = jacobian_arakawa(nx,nz)*4 

    deallocate( psi_w, f_w, jacob_w )
  end function jacobian_arakawa

end module dynbase_arakawa
