! package dynamics
!     for 2-D thermal convection in a square box. 
!
! 99/09/26  S. Takehiro   cyclic b.c. 
!
!=======================================================================
module derivative_div

  use coordinates, only : dx, dz, xcycl, zcycl
  implicit none
  private

  public :: div, diff_term

  contains

 !-------------------- ȯ (divergence ) ----------------------
  function div(flux_x,flux_z)
    double precision, dimension(0:,:),intent(in)    :: flux_x  ! flux field 
                                                               !    (on VGX)
    double precision, dimension(:,0:),intent(in)    :: flux_z  ! flux field
                                                               !    (on VGZ)
    double precision, &
         & dimension(size(flux_z,1),size(flux_x,2)) :: div     ! scalor field

    integer                                         :: nx, nz

    nx = size(flux_z,1) ; nz = size(flux_x,2) 

   !--- ΰ׻
    div(2:nx-1,2:nz-1) = &
         &    ( flux_x(2:nx-1,2:nz-1) - flux_x(1:nx-2,2:nz-1) )/dx &
         &  + ( flux_z(2:nx-1,2:nz-1) - flux_z(2:nx-1,1:nz-2) )/dz

   !--- ǤȾʬ, Υեå 0
    if ( (.not. xcycl) .and. (.not. zcycl) ) then
        div(1,2:nz-1) = &    ! ü
             &   ( flux_x(1,2:nz-1) - 0.0 ) / (dx/2) &
             & + ( flux_z(1,2:nz-1) - flux_z(1,1:nz-2) )/dz

        div(nx,2:nz-1) = &   ! ü
             &   ( 0.0 - flux_x(nx-1,2:nz-1) ) / (dx/2) &
             & + ( flux_z(nx,2:nz-1) - flux_z(nx,1:nz-2) )/dz

        div(2:nx-1,1) = &    ! ü
             &   ( flux_x(2:nx-1,1) - flux_x(1:nx-2,1) )/dx &
             & + ( flux_z(2:nx-1,1) - 0.0 ) / (dz/2)

        div(2:nx-1,nz) = &   ! ü
             &   ( flux_x(2:nx-1,nz) - flux_x(1:nx-2,nz) )/dx &
             & + ( 0.0 - flux_z(2:nx-1,nz-1)) / (dz/2)

        div(1,1) = &    ! 
             &   ( flux_x(1,1) - 0.0 ) / (dx/2) &
             & + ( flux_z(1,1) - 0.0 ) / (dz/2) 

        div(nx,1) = &   ! 
             &   ( 0.0 - flux_x(nx-1,1) ) / (dx/2) &
             & + ( flux_z(nx,1) - 0.0 ) / (dz/2) 

        div(1,nz) = &   ! 
             &   ( flux_x(1,nz) - 0.0 ) / (dx/2) &
             & + ( 0.0 - flux_z(1,nz-1) ) / (dz/2) 

        div(nx,nz) = &   ! 
             &   ( 0.0 - flux_x(nx-1,nz) ) / (dx/2) &
             & + ( 0.0 - flux_z(nx,nz-1) ) / (dz/2) 

   !--- x Ū (z ǤȾʬ, Υեå 0)
    elseif ( xcycl .and. (.not. zcycl) ) then
        div(1,2:nz-1) = &    ! ü
             &   ( flux_x(1,2:nz-1) - flux_x(nx-1,2:nz-1) ) / dx &
             & + ( flux_z(1,2:nz-1) - flux_z(1,1:nz-2) )/dz
        div(nx,2:nz-1) = &   ! ü
             &   ( flux_x(1,2:nx-1) - flux_x(nx-1,2:nz-1) ) / dx &
             & + ( flux_z(nx,2:nz-1) - flux_z(nx,1:nz-2) )/dz

        div(2:nx-1,1) = &    ! ü
             &   ( flux_x(2:nx-1,1) - flux_x(1:nx-2,1) )/dx &
             & + ( flux_z(2:nx-1,1) - 0.0 ) / (dz/2)

        div(2:nx-1,nz) = &   ! ü
             &   ( flux_x(2:nx-1,nz) - flux_x(1:nx-2,nz) )/dx &
             & + ( 0.0 - flux_z(2:nx-1,nz-1)) / (dz/2)

        div(1,1) = &    ! 
             &   ( flux_x(1,1) - flux_x(nx-1,1) ) / dx &
             & + ( flux_z(1,1) - 0.0 ) / (dz/2) 

        div(nx,1) = &   ! 
             &   ( flux_x(1,1) - flux_x(nx-1,1) ) / dx &
             & + ( flux_z(nx,1) - 0.0 ) / (dz/2) 

        div(1,nz) = &   ! 
             &   ( flux_x(1,nz) - flux_x(nx-1,nz) ) / dx &
             & + ( 0.0 - flux_z(1,nz-1) ) / (dz/2) 

        div(nx,nz) = &   ! 
             &   ( flux_x(1,nz) - flux_x(nx-1,nz) ) / dx &
             & + ( 0.0 - flux_z(nx,nz-1) ) / (dz/2) 

   !--- z Ū (x ǤȾʬ, Υեå 0)
    elseif ( (.not. xcycl) .and. zcycl ) then
        div(1,2:nz-1) = &    ! ü
             &   ( flux_x(1,2:nz-1) - 0.0 ) / (dx/2) &
             & + ( flux_z(1,2:nz-1) - flux_z(1,1:nz-2) )/dz

        div(nx,2:nz-1) = &   ! ü
             &   ( 0.0 - flux_x(nx-1,2:nz-1) ) / (dx/2) &
             & + ( flux_z(nx,2:nz-1) - flux_z(nx,1:nz-2) )/dz

        div(2:nx-1,1) = &    ! ü
             &   ( flux_x(2:nx-1,1) - flux_x(1:nx-2,1) )/dx &
             & + ( flux_z(2:nx-1,1) - flux_z(2:nx-1,nz-1) ) / dz

        div(2:nx-1,nz) = &   ! ü
             &   ( flux_x(2:nx-1,nz) - flux_x(1:nx-2,nz) )/dx &
             & + ( flux_z(2:nx-1,1) - flux_z(2:nx-1,nz-1)) / dz

        div(1,1) = &    ! 
             &   ( flux_x(1,1) - 0.0 ) / (dx/2) &
             & + ( flux_z(1,1) - flux_z(1,nz-1) ) / dz 

        div(nx,1) = &   ! 
             &   ( 0.0 - flux_x(nx-1,1) ) / (dx/2) &
             & + ( flux_z(nx,1) - flux_z(nx,nz-1)) / dz

        div(1,nz) = &   ! 
             &   ( flux_x(1,nz) - 0.0 ) / (dx/2) &
             & + ( flux_z(1,1) - flux_z(1,nz-1) ) / dz

        div(nx,nz) = &   ! 
             &   ( 0.0 - flux_x(nx-1,nz) ) / (dx/2) &
             & + ( flux_z(nx,1) - flux_z(nx,nz-1) ) / dz

   !--- x,z Ū 
    elseif ( xcycl .and. zcycl ) then
        div(1,2:nz-1) = &    ! ü
             &   ( flux_x(1,2:nz-1) - flux_x(nx-1,2:nz-1) )/ dx &
             & + ( flux_z(1,2:nz-1) - flux_z(1,1:nz-2) ) /dz

        div(nx,2:nz-1) = &   ! ü
             &   ( flux_x(1,2:nz-1) - flux_x(nx-1,2:nz-1) ) / dx &
             & + ( flux_z(nx,2:nz-1) - flux_z(nx,1:nz-2) ) /dz

        div(2:nx-1,1) = &    ! ü
             &   ( flux_x(2:nx-1,1) - flux_x(1:nx-2,1) )/dx &
             & + ( flux_z(2:nx-1,1) - flux_z(2:nx-1,nz-1) ) /dz

        div(2:nx-1,nz) = &   ! ü
             &   ( flux_x(2:nx-1,nz) - flux_x(1:nx-2,nz) )/dx &
             & + ( flux_z(2:nx-1,1)  - flux_z(2:nx-1,nz-1)) /dz

        div(1,1) = &    ! 
             &   ( flux_x(1,1) - flux_x(nx-1,1) ) / dx &
             & + ( flux_z(1,1) - flux_z(1,nz-1) ) / dz 

        div(nx,1) = &   ! 
             &   ( flux_x(1,1)  - flux_x(nx-1,1) ) / dx &
             & + ( flux_z(nx,1) - flux_z(nx,nz-1) ) /dz 

        div(1,nz) = &   ! 
             &   ( flux_x(1,1)  - flux_x(nx-1,1) ) / dx &
             & + ( flux_z(nx,1) - flux_z(nx,nz-1) ) /dz 

        div(nx,nz) = &   ! 
             &   ( flux_x(1,1)  - flux_x(nx-1,1) ) / dx &
             & + ( flux_z(nx,1) - flux_z(nx,nz-1) ) /dz 

     endif
  end function div

 !-------------------------- Ȼ --------------------------
  function diff_term( diff_x, diff_z, a )
    double precision, dimension(:,:)                   :: a
    double precision, dimension(size(a,1)-1,size(a,2)) :: diff_x
    double precision, dimension(size(a,1),size(a,2)-1) :: diff_z
    double precision, dimension(size(a,1),size(a,2))   :: diff_term

    double precision, dimension(:,:), allocatable  :: flux_x, flux_z

    integer :: nx, nz

    nx = size(a,1) ; nz = size(a,2)

    allocate( flux_x(0:nx,nz), flux_z(nx,0:nz) )
                          ! ۤȾǤեå
                          ! ǥեå 0 ǤγȻ׻

    flux_x = 0.0d0 ; flux_z = 0.0d0

    flux_x(1:nx-1,:) = - diff_x(1:nx-1,:) * ( a(2:nx,:) - a(1:nx-1,:) )/dx
    if ( xcycl ) then
       flux_x(0,:)      = flux_x(nx-1,:)  ! 
       flux_x(nx,:)     = flux_x(1,:)     ! 
    endif

    flux_z(:,1:nz-1) = - diff_z(:,1:nz-1) * ( a(:,2:nz) - a(:,1:nz-1) )/dz
    if ( zcycl ) then
       flux_z(:,0)      = flux_z(:,nz-1)  ! 
       flux_z(:,nz)     = flux_z(:,1)     ! 
    endif

    diff_term = - div( flux_x, flux_z )

    deallocate( flux_x, flux_z )
  end function diff_term

end module derivative_div
