! package dynamics_diffusion
!     for 2-D thermal convection in a square box. 
!
! 99/08/20  S. Takehiro  
! 99/10/04  S. Takehiro  cyclic. b.c.
!
!================== Ȼ׻(եå) ====================
module diffuse_diffusion

  use dimension
  use derivative_base, only: dxd2, dzd2, dxdz
  use derivative_div, only : diff_term
  use coordinates,    only : dx, dz, xcycl, zcycl
  use diffuse_boundary

  private
  public  :: diff_T, diff_C, visc_term

  contains

   !======================= ǮȻ =======================
    function diff_T( diff_Tx, diff_Tz, T )

      double precision, dimension(nx,nz)      :: T
      double precision, dimension(nx-1,nz)    :: diff_Tx
      double precision, dimension(nx,nz-1)    :: diff_Tz
      double precision, dimension(nx,nz)      :: diff_T

      diff_T = diff_term( diff_Tx, diff_Tz, T )

     !----- եåν :  1/2  ----

      if ( .not. zcycl ) then
         if ( .not. otfix_top ) then
            diff_T(:,nz) = diff_T(:,nz) + tftop / (dz/2)
            !diff_T(:,nz) = diff_T(:,nz) + tftop / dz
         endif

         if ( .not. otfix_bottom ) then
            diff_T(:,1) = diff_T(:,1) - tfbtm / (dz/2)
            !diff_T(:,1) = diff_T(:,1) - tfbtm / dz
         endif
      endif

      if ( .not. xcycl ) then
         if ( .not. otfix_left ) then
            diff_T(1,:) = diff_T(1,:) - tfleft / (dx/2)
            !diff_T(1,:) = diff_T(1,:) - tfleft / dx
         endif

         if ( .not. otfix_right ) then
            diff_T(nx,:) = diff_T(nx,:) + tfright / (dx/2)
            !diff_T(nx,:) = diff_T(nx,:) + tfright / dx
         endif
      endif

    end function diff_T

   !======================= Ȼ =======================

    function diff_C( diff_Cx, diff_Cz, C )

      double precision, dimension(nx,nz)      :: C
      double precision, dimension(nx-1,nz)    :: diff_Cx
      double precision, dimension(nx,nz-1)    :: diff_Cz
      double precision, dimension(nx,nz)      :: diff_C

      diff_C = diff_term( diff_Cx, diff_Cz, C )

     !----- եåν :  1/2  ----
      if ( .not. zcycl ) then
         if ( .not. ocfix_top ) then
            diff_C(:,nz) = diff_C(:,nz) + cftop / (dz/2)
         endif

         if ( .not. ocfix_bottom ) then
            diff_C(:,1) = diff_C(:,1) - cfbtm / (dz/2)
         endif
      endif

      if ( .not. xcycl ) then
         if ( .not. ocfix_left ) then
            diff_C(1,:) = diff_C(1,:) - cfleft / (dx/2)
         endif

         if ( .not. ocfix_right ) then
            diff_C(nx,:) = diff_C(nx,:) + cfright / (dx/2)
         endif
      endif

    end function diff_C

   !======================= Ǵ + =======================
    function visc_term( rmu, psi )
      double precision, dimension(nx,nz) :: rmu
      double precision, dimension(nx,nz) :: psi
      double precision, dimension(nx,nz) :: visc_term

      double precision, dimension(:,:), allocatable    :: psi_w
      double precision, dimension(:,:), allocatable    :: dx2dz2psi, dxdzpsi

      allocate( psi_w(0:nx+1,0:nz+1) )
      allocate( dx2dz2psi(0:nx+1,0:nz+1), dxdzpsi(0:nx+1,0:nz+1) )

      psi_w = 0.0
      psi_w(1:nx,1:nz) = psi

      if ( oslip )then                         !  free-slip 
         if ( .not. xcycl ) then                          ! 
            psi_w(0,:)    = 2*psi_w(1,:)  - psi_w(2,:) 
            psi_w(nx+1,:) = 2*psi_w(nx,:) - psi_w(nx-1,:)
         else
            psi_w(0,:)    = psi_w(nx-1,:)
            psi_w(nx+1,:) = psi_w(2,:)
         endif
           
         if ( .not. zcycl ) then                          ! 岼
            psi_w(:,0)    = 2*psi_w(:,1)  - psi_w(:,2)
            psi_w(:,nz+1) = 2*psi_w(:,nz) - psi_w(:,nz-1)
         else
            psi_w(:,0)    = psi_w(:,nz-1)
            psi_w(:,nz+1) = psi_w(:,2)
         endif

         if ( (.not. xcycl) .and. (.not. zcycl) ) then    ! Ͷ
            psi_w(0,0)       = 2*psi_w(1,1)   - psi_w(2,2) 
            psi_w(nx+1,0)    = 2*psi_w(nx,1)  - psi_w(nx-1,2) 
            psi_w(0,nz+1)    = 2*psi_w(1,nz)  - psi_w(2,nz-1) 
            psi_w(nx+1,nz+1) = 2*psi_w(nx,nz) - psi_w(nx-1,nz-1) 
         endif
      else                                     !  rigid
         if ( .not. xcycl ) then                          ! 
            psi_w(0,:)    = psi_w(2,:)
            psi_w(nx+1,:) = psi_w(nx-1,:)
         else
            psi_w(0,:)    = psi_w(nx-1,:)
            psi_w(nx+1,:) = psi_w(2,:)
         endif
           
         if ( .not. zcycl ) then                          ! 岼
            psi_w(:,0)    = psi_w(:,2)
            psi_w(:,nz+1) = psi_w(:,nz-1)
         else
            psi_w(:,0)    = psi_w(:,nz-1)
            psi_w(:,nz+1) = psi_w(:,2)
         endif

         if ( (.not. xcycl) .and. (.not. zcycl) ) then    ! Ͷ
            psi_w(0,0)       = psi_w(2,2) 
            psi_w(nx+1,0)    = psi_w(nx-1,2) 
            psi_w(0,nz+1)    = psi_w(2,nz-1) 
            psi_w(nx+1,nz+1) = psi_w(nx-1,nz-1) 
         endif
      endif

      dx2dz2psi = dxd2(psi_w) - dzd2(psi_w)
      dxdzpsi   = dxdz(psi_w)

      visc_term =    dxd2( rmu*dx2dz2psi(1:nx,1:nz) ) &
               &   - dzd2( rmu*dx2dz2psi(1:nx,1:nz) ) &
               &   + 4*dxdz( rmu*dxdzpsi(1:nx,1:nz) )

      deallocate( psi_w )
      deallocate( dx2dz2psi, dxdzpsi )

    end function visc_term

  end module diffuse_diffusion
