! package dynamics_diffusion
!     for 2-D thermal convection in a square box. 
!
! 99/08/20  S. Takehiro  
! 99/08/26  S. Takehiro  zeta ׻ˤ. 
! 99/10/04  S. Takehiro  cyclic b.c.
!
!============================  ==============================
module diffuse_boundary

  use dimension
  use namelist
  use derivative_base,  only : laplace
  use coordinates, only : xcycl, zcycl
  implicit none
  include 'netcdf.inc'

! [NMBNDD]  ϳض
    logical :: oslip = .true.             ! ϳض凉å

! [NMBNDR]  Ǯ
    logical ::  otfix_top    = .true.     ! Ǯ凉å
    logical ::  otfix_bottom = .true.     ! 
    logical ::  otfix_left   = .false.    !
    logical ::  otfix_right  = .false.    !

    double precision    ::  tftop   = 0.0D0 ! 嶭( or ٷ)
    double precision    ::  tfbtm   = 1.0D0 ! 
    double precision    ::  tfleft  = 0.0D0 ! 
    double precision    ::  tfright = 0.0D0 ! 

! [NMBNDR]  
    logical ::  ocfix_top    = .false.    ! 凉å
    logical ::  ocfix_bottom = .false.    ! 
    logical ::  ocfix_left   = .false.    !
    logical ::  ocfix_right  = .false.    !

    double precision    ::  cftop   = 0.0D0 ! 嶭( or )
    double precision    ::  cfbtm   = 0.0D0 ! 
    double precision    ::  cfleft  = 0.0D0 ! 
    double precision    ::  cfright = 0.0D0 ! 

  private
    public  ::  oslip
    public  ::  otfix_top, otfix_bottom, otfix_left, otfix_right
    public  ::  tftop, tfbtm, tfleft, tfright
    public  ::  ocfix_top, ocfix_bottom, ocfix_left, ocfix_right
    public  ::  cftop, cfbtm, cfleft, cfright

    public  :: diffuse_boundary_init_T, diffuse_boundary_init_C
    public  :: diffuse_boundary_init_D, diffuse_boundary_init
    public  :: diffuse_boundary_T, diffuse_boundary_C
    public  :: diffuse_boundary_zeta
    !public  :: zeta_psi

    public  :: diffuse_boundary_output_nc
    public  :: diffuse_boundary_input_nc

  contains

 !========================== ѥ᥿ ============================

   !--------------- ϳضѥ᥿ ---------------
    subroutine diffuse_boundary_init_D
      namelist /NMBNDD/ oslip

      if( .not. rewnml() ) write( nm_write_num, NML=NMBNDD )
      read( nm_read_num, NML=NMBNDD, end=297 )
 297  write( nm_write_num, NML=NMBNDD )
    end subroutine diffuse_boundary_init_D

    subroutine diffuse_boundary_D_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_put_att_int1 &
         & ( ncid, NF_GLOBAL, 'oslip', NF_BYTE, 1, oslip )
    end subroutine diffuse_boundary_D_output_nc

    subroutine diffuse_boundary_D_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      status = nf_get_att_int1 &
           & ( ncid, NF_GLOBAL, 'oslip', oslip )
    end subroutine diffuse_boundary_D_input_nc

   !--------------- Ǯѥ᥿ ---------------
    subroutine diffuse_boundary_init_T
      namelist /NMBNDT/ otfix_top, tftop, otfix_bottom, tfbtm,   & 
       &                otfix_left, otfix_right, tfleft, tfright 

      if( .not. rewnml() ) write( nm_write_num, NML=NMBNDT )
      read( nm_read_num, NML=NMBNDT, end=299 )
 299  write( nm_write_num, NML=NMBNDT )
    end subroutine diffuse_boundary_init_T

    subroutine diffuse_boundary_T_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      if ( .not. zcycl ) then
         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'otfix_top', NF_BYTE, 1, otfix_top )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'tftop', NF_DOUBLE, 1, tftop )

         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'otfix_bottom', NF_BYTE, 1, otfix_bottom )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'tfbtm', NF_DOUBLE, 1, tfbtm )
      endif

      if ( .not. xcycl ) then
         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'otfix_left', NF_BYTE, 1, otfix_left )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'tfleft', NF_DOUBLE, 1, tfleft )

         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'otfix_right', NF_BYTE, 1, otfix_right )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'tfright', NF_DOUBLE, 1, tfright )
      endif
    end subroutine diffuse_boundary_T_output_nc

    subroutine diffuse_boundary_T_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      if ( .not. zcycl ) then
         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'otfix_top', otfix_top )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'tftop', tftop )

         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'otfix_bottom', otfix_bottom )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'tfbtm', tfbtm )
      endif

      if ( .not. xcycl ) then
         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'otfix_left', otfix_left )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'tfleft', tfleft )

         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'otfix_right', otfix_right )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'tfright', tfright )
      endif
    end subroutine diffuse_boundary_T_input_nc

   !--------------- ѥ᥿ ---------------
    subroutine diffuse_boundary_init_C
      namelist /NMBNDC/ ocfix_top, cftop, ocfix_bottom, cfbtm,   & 
       &                ocfix_left, ocfix_right, cfleft, cfright 

      if( .not. rewnml() ) write( nm_write_num, NML=NMBNDC )

      read( nm_read_num, NML=NMBNDC, end=298 )
 298  write( nm_write_num, NML=NMBNDC )
    end subroutine diffuse_boundary_init_C

    subroutine diffuse_boundary_C_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      if ( .not. zcycl ) then
         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'ocfix_top', NF_BYTE, 1, ocfix_top )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'cftop', NF_DOUBLE, 1, cftop )

         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'ocfix_bottom', NF_BYTE, 1, ocfix_bottom )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'cfbtm', NF_DOUBLE, 1, cfbtm )
      endif

      if ( .not. xcycl ) then
         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'ocfix_left', NF_BYTE, 1, ocfix_left )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'cfleft', NF_DOUBLE, 1, cfleft )

         status = nf_put_att_int1 &
            & ( ncid, NF_GLOBAL, 'ocfix_right', NF_BYTE, 1, ocfix_right )
         status = nf_put_att_double &
            & ( ncid, NF_GLOBAL, 'cfright', NF_DOUBLE, 1, cfright )
      endif
    end subroutine diffuse_boundary_C_output_nc

    subroutine diffuse_boundary_C_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ
      integer :: status  ! netcdf ؿѿ

      if ( .not. zcycl ) then
         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'ocfix_top', ocfix_top )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'cftop', cftop )

         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'ocfix_bottom', ocfix_bottom )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'cfbtm', cfbtm )
      endif

      if ( .not. xcycl ) then
         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'ocfix_left', ocfix_left )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'cfleft', cfleft )

         status = nf_get_att_int1 &
              & ( ncid, NF_GLOBAL, 'ocfix_right', ocfix_right )
         status = nf_get_att_double &
              & ( ncid, NF_GLOBAL, 'cfright', cfright )
      endif
    end subroutine diffuse_boundary_C_input_nc

   !--------------- ѥ᥿ ---------------
    subroutine diffuse_boundary_init
      call diffuse_boundary_init_T
      call diffuse_boundary_init_C
      call diffuse_boundary_init_D
    end subroutine diffuse_boundary_init

    subroutine diffuse_boundary_output_nc( ncid )
      integer :: ncid    ! netcdf file ֹ

      call diffuse_boundary_T_output_nc( ncid )
      call diffuse_boundary_C_output_nc( ncid )
      call diffuse_boundary_D_output_nc( ncid )
    end subroutine diffuse_boundary_output_nc

    subroutine diffuse_boundary_input_nc( ncid )
      integer :: ncid    ! netcdf file ֹ

      call diffuse_boundary_T_input_nc( ncid )
      call diffuse_boundary_C_input_nc( ncid )
      call diffuse_boundary_D_input_nc( ncid )
    end subroutine diffuse_boundary_input_nc

 !======================= Ǯ =======================
    subroutine diffuse_boundary_T( T )
      double precision, dimension(nx,nz)      :: T

     !----- Ǯ(ٸ) ----
      if ( .not. xcycl ) then
         if ( otfix_left ) then                       ! x 
            T(1,:) = tfleft                           !   ٸ
         ! else                                               
         !    T(1,:) = T(2,:) - tfleft * dx           !   ٷٸ
         endif

         if ( otfix_right ) then                      ! x 
            T(nx,:) = tfright                         !   ٸ
         ! else                                               
         !   T(nx,:) = T(nx-1,:) + tfright * dx       !   ٷٸ
         endif
      !else
      !   T(nx,:) = T(1,:)
      endif

      if ( .not. zcycl ) then
         if ( otfix_top ) then                        ! z 
            T(:,nz) = tftop                           !   ٸ
         ! else
         !    T(:,nz) = T(:,nz-1) + tftop * dz        !   ٷٸ
         endif

         if ( otfix_bottom ) then                     ! z 
            T(:,1) = tfbtm                            !   ٸ
         ! else
         !   T(:,1) = T(:,2) - tfbtm * dz             !   ٷٸ
         endif
      !else
      !   T(:,nz) = T(:,1)
      endif
    end subroutine diffuse_boundary_T

 !=======================  =======================
    subroutine diffuse_boundary_C( C )
      double precision, dimension(nx,nz)      :: C

      if ( .not. xcycl ) then
         if ( ocfix_left ) then                       ! x 
            C(1,:) = cfleft                           !   
         ! else                                               
         !    C(1,:) = C(2,:) - cfleft * dx           !   ٸ
         endif

         if ( ocfix_right ) then                      ! x 
            C(nx,:) = cfright                         !   
         ! else                                               
         !   C(nx,:) = C(nx-1,:) + cfright * dx       !   ٸ
         endif
      !else
      !   C(nx,:) = C(1,:)
      endif

      if ( .not. zcycl ) then
         if ( ocfix_top ) then                        ! z 
            C(:,nz) = cftop                           !   
         ! else
         !    C(:,nz) = C(:,nz-1) + cftop * dz        !   ٸ
         endif

         if ( ocfix_bottom ) then                     ! z 
            C(:,1) = cfbtm                            !   
         ! else
         !   C(:,1) = C(:,2) - cfbtm * dz             !   ٸ
         endif
      !else
      !   C(:,nz) = C(:,1)
      endif
    end subroutine diffuse_boundary_C

 !========================= ٶ׻ =========================
    subroutine diffuse_boundary_zeta( zeta, psi )
      double precision, dimension(nx,nz)    :: zeta
      double precision, dimension(nx,nz)    :: psi

      double precision, dimension(:,:), allocatable    :: psi_w
      double precision, dimension(:,:), allocatable    :: zeta_w

      allocate( psi_w(0:nx+1,0:nz+1), zeta_w(0:nx+1,0:nz+1) )

      psi_w = 0.0
      psi_w(1:nx,1:nz) = psi

      if ( oslip )then                         !  free-slip 
         if ( .not. xcycl ) then                          ! 
            psi_w(0,:)    = 2*psi_w(1,:)  - psi_w(2,:) 
            psi_w(nx+1,:) = 2*psi_w(nx,:) - psi_w(nx-1,:)
         else
            psi_w(0,:)    = psi_w(nx-1,:)
            psi_w(nx+1,:) = psi_w(2,:)
         endif

         if ( .not. zcycl ) then                          ! 岼
            psi_w(:,0)    = 2*psi_w(:,1)  - psi_w(:,2)
            psi_w(:,nz+1) = 2*psi_w(:,nz) - psi_w(:,nz-1)
         else
            psi_w(:,0)    = psi_w(:,nz-1)
            psi_w(:,nz+1) = psi_w(:,2)
         endif

         if ( (.not. xcycl) .and. (.not. zcycl) ) then    ! Ͷ
            psi_w(0,0)       = 2*psi_w(1,1)   - psi_w(2,2) 
            psi_w(nx+1,0)    = 2*psi_w(nx,1)  - psi_w(nx-1,2) 
            psi_w(0,nz+1)    = 2*psi_w(1,nz)  - psi_w(2,nz-1) 
            psi_w(nx+1,nz+1) = 2*psi_w(nx,nz) - psi_w(nx-1,nz-1) 
         endif
      else                                     !  rigid
         if ( .not. xcycl ) then                          ! 
            psi_w(0,:)    = psi_w(1,:)
            psi_w(nx+1,:) = psi_w(nx,:)
         else
            psi_w(0,:)    = psi_w(nx-1,:)
            psi_w(nx+1,:) = psi_w(2,:)
         endif
         if ( .not. zcycl ) then                          ! 岼
            psi_w(:,0)    = psi_w(:,1)
            psi_w(:,nz+1) = psi_w(:,nz)
         else
            psi_w(:,0)    = psi_w(:,nz-1)
            psi_w(:,nz+1) = psi_w(:,2)
         endif

         if ( (.not. xcycl) .and. (.not. zcycl) ) then    ! Ͷ
            psi_w(0,0)       = psi_w(1,1) 
            psi_w(nx+1,0)    = psi_w(nx,1) 
            psi_w(0,nz+1)    = psi_w(1,nz) 
            psi_w(nx+1,nz+1) = psi_w(nx,nz) 
         endif
      endif

      zeta_w = laplace(psi_w)
      
      zeta(1,:)  = zeta_w(1,:)
      zeta(nx,:) = zeta_w(nx,:)
      zeta(:,1)  = zeta_w(:,1)
      zeta(:,nz) = zeta_w(:,nz)

      deallocate( psi_w, zeta_w )

    end subroutine diffuse_boundary_zeta

  end module diffuse_boundary
