! package coordinates
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/09/26  S. Takehiro   cyclic condition
!
!=============================== ɸѿ ===============================
module coordinates
  use dimension
  use namelist

  implicit none

  double precision, dimension(:), allocatable     ::  x       ! x ɸ
  double precision, dimension(:), allocatable     ::  z       ! z ɸ
  double precision, dimension(:,:), allocatable   ::  xx, zz  ! x ɸ, z ɸ

  double precision       :: dx, dz                          ! åɴֳ
  double precision       :: xlength=1.0, zlength=1.0        ! ׻ΰ

  logical    :: xcycl, zcycl      ! geometry (x,z å)

  private
  public     :: x, z, xx, zz, dx, dz, coordinates_init, xcycl, zcycl

  contains
   !----------------------------  ----------------------------
    subroutine coordinates_init

      integer                  ::  i, j              ! 롼ѿ

      namelist /NMCORD/ nx, xlength, nz, zlength, xcycl, zcycl

      if( .not. rewnml() ) write( nm_write_num, NML=NMCORD )
      read( nm_read_num, NML=NMCORD, end=999 )
 999  write( nm_write_num, NML=NMCORD )

      allocate( x(nx), z(nz), xx(nx,nz), zz(nx,nz) )

      dx = xlength/(nx-1); dz = zlength/(nz-1)

      do i=1,nx ;  x(i)=dx*(i-1) ; xx(i,:) = x(i) ; enddo
      do j=1,nz ;  z(j)=dz*(j-1) ; zz(:,j) = z(j) ; enddo

    end subroutine coordinates_init

end module coordinates
