! package dynamics
!     for 2-D thermal convection in a square box. 
!
! 99/09/26  S. Takehiro   cyclic b.c. in x direction
!
!=======================================================================
module advect_arakawa

  use coordinates, only : dx, dz, xcycl, zcycl
  implicit none
  private

  public :: jacobian_arakawa

  contains

 !---------------------- ܥ롼 Arakawa Jacobian ---------------------
  function j_arakawa(a,b)
    double precision, dimension(:,:)                 :: a,b
    double precision, dimension(size(a,1),size(a,2)) :: j_arakawa

    integer                              :: nx, nz

    nx = size(a,1) ; nz = size(a,2)

    j_arakawa = 0.0

    j_arakawa( 2:nx-1,2:nz-1 ) &
     &   =(       ( a(3:nx,2:nz-1)-a(1:nx-2,2:nz-1) )/(2*dx)   &
     &          * ( b(2:nx-1,3:nz)-b(2:nx-1,1:nz-2) )/(2*dz)   &
     &        -   ( a(2:nx-1,3:nz)-a(2:nx-1,1:nz-2) )/(2*dz)   &
     &          * ( b(3:nx,2:nz-1)-b(1:nx-2,2:nz-1) )/(2*dx)   &
     &     +      ( b(2:nx-1,3:nz)*( a(3:nx,3:nz)-a(1:nx-2,3:nz) )  &
     &              - b(2:nx-1,1:nz-2)*( a(3:nx,1:nz-2)-a(1:nx-2,1:nz-2) )) &
     &               / (4*dx*dz) &
     &      -     ( b(3:nx,2:nz-1)*( a(3:nx,3:nz)-a(3:nx,1:nz-2) )  &
     &              - b(1:nx-2,2:nz-1)*( a(1:nx-2,3:nz)-a(1:nx-2,1:nz-2) )) &
     &               / (4*dx*dz) &
     &     +      ( a(3:nx,2:nz-1)*( b(3:nx,3:nz)-b(3:nx,1:nz-2) )  &
     &              - a(1:nx-2,2:nz-1)*( b(1:nx-2,3:nz)-b(1:nx-2,1:nz-2) )) &
     &               / (4*dx*dz) &
     &        -   ( a(2:nx-1,3:nz)*( b(3:nx,3:nz)-b(1:nx-2,3:nz) )  &
     &              - a(2:nx-1,1:nz-2)*( b(3:nx,1:nz-2)-b(1:nx-2,1:nz-2) )) &
     &               / (4*dx*dz) &
     &         )/3.0

  end function j_arakawa

!======================== ׻ΰ趭 ==========================

 !----------------------- ξ cyclic -------------------------
  function jacobian_arakawa_xzcycl(psi,f)
    double precision, dimension(:,:)             :: psi, f
    double precision, &
         dimension(size(psi,1),size(psi,2))      :: jacobian_arakawa_xzcycl

    double precision, dimension(:,:),allocatable :: psi_w, f_w, jacob_w
    integer                                      :: nx, nz

    logical  :: ofirst=.true.

    if ( ofirst ) then 
       ofirst = .false.
       write(6,*)'<<< ADVECT. SCHEME BY ARAKAWA JACOBIAN (XZCYCL) 99/09/27 >>>'
    endif

    nx = size(psi,1) ; nz = size(psi,2)

    allocate( psi_w(0:nx+1,0:nz+1), f_w(0:nx+1,0:nz+1) )
    allocate( jacob_w(0:nx+1,0:nz+1) )

    ! ͤν
      psi_w = 0.0d0 ; psi_w(1:nx,1:nz) = psi
        psi_w(0,1:nz) = psi(nx-1,:) ;  psi_w(nx+1,1:nz) = psi(2,:)  ! 
        psi_w(:,0)    = psi_w(:,nz-1) ;  psi_w(:,nz+1) = psi_w(:,2) ! 

    ! f ζ. df/dn = 0 Ѥ
      f_w = 0.0 ; f_w(1:nx,1:nz) = f
        f_w(0,1:nz)    = f(nx-1,:) ;  f_w(nx+1,1:nz) = f(2,:)    ! 
        f_w(:,0)    = f_w(:,nz-1) ;  f_w(:,nz+1) = f_w(:,2)      ! 

    jacob_w = j_arakawa(psi_w,f_w)
    jacobian_arakawa_xzcycl = jacob_w(1:nx,1:nz)

      ! νϤʤ

    deallocate( psi_w, f_w, jacob_w )
  end function jacobian_arakawa_xzcycl

 !----------------------- x  cyclic ----------------------- 
  function jacobian_arakawa_xcycl(psi,f)
    double precision, dimension(:,:)             :: psi, f
    double precision, &
         & dimension(size(psi,1),size(psi,2))    :: jacobian_arakawa_xcycl

    double precision, dimension(:,:),allocatable :: psi_w, f_w, jacob_w
    integer                                      :: nx, nz

    logical  :: ofirst=.true.

    if ( ofirst ) then 
       ofirst = .false.
       write(6,*)'<<< ADVECT. SCHEME BY ARAKAWA JACOBIAN (XCYCL) 99/09/27 >>>'
    endif

    nx = size(psi,1) ; nz = size(psi,2)

    allocate( psi_w(0:nx+1,0:nz+1), f_w(0:nx+1,0:nz+1) )
    allocate( jacob_w(0:nx+1,0:nz+1) )

    ! ͤν :  ¦϶Ʊ
      psi_w = 0.0d0 ; psi_w(1:nx,1:nz) = psi
        psi_w(1:nx,0) = psi(:,1)  ;  psi_w(1:nx,nz+1) = psi(:,nz) 
        psi_w(0,:)    = psi_w(nx-1,:) ;  psi_w(nx+1,:) = psi_w(2,:) ! 

    ! f ζ. df/dn = 0 Ѥ
      f_w = 0.0 ; f_w(1:nx,1:nz) = f
           f_w(1:nx,0)  = f(:,2)     ;  f_w(1:nx,nz+1) = f(:,nz-1)
           f_w(0,:)    = f_w(nx-1,:) ;  f_w(nx+1,:) = f_w(2,:)    ! 

    jacob_w = j_arakawa(psi_w,f_w)
    jacobian_arakawa_xcycl = jacob_w(1:nx,1:nz)

      ! ν. ȾʬʤΤ 2 ܤ
        jacobian_arakawa_xcycl(:,1) = jacobian_arakawa_xcycl(:,1)*2 
        jacobian_arakawa_xcycl(:,nz) = jacobian_arakawa_xcycl(:,nz)*2 

    deallocate( psi_w, f_w, jacob_w )
  end function jacobian_arakawa_xcycl

 !----------------------- z  cyclic ----------------------- 
  function jacobian_arakawa_zcycl(psi,f)
    double precision, dimension(:,:)             :: psi, f
    double precision, &
         & dimension(size(psi,1),size(psi,2))    :: jacobian_arakawa_zcycl

    double precision, dimension(:,:),allocatable :: psi_w, f_w, jacob_w
    integer                                      :: nx, nz

    logical  :: ofirst=.true.

    if ( ofirst ) then 
       ofirst = .false.
       write(6,*)'<<< ADVECT. SCHEME BY ARAKAWA JACOBIAN (ZCYCL) 99/09/27 >>>'
    endif

    nx = size(psi,1) ; nz = size(psi,2)

    allocate( psi_w(0:nx+1,0:nz+1), f_w(0:nx+1,0:nz+1) )
    allocate( jacob_w(0:nx+1,0:nz+1) )

    ! ͤν
      psi_w = 0.0d0 ; psi_w(1:nx,1:nz) = psi
        psi_w(0,1:nz) = psi(1,:) ;  psi_w(nx+1,1:nz) = psi(nx,:)
        psi_w(:,0)    = psi_w(:,nz-1) ;  psi_w(:,nz+1) = psi_w(:,2) ! 

    ! f ζ. df/dn = 0 Ѥ
      f_w = 0.0 ; f_w(1:nx,1:nz) = f
           f_w(0,1:nz)    = f(2,:) ;  f_w(nx+1,1:nz) = f(nx-1,:)
           f_w(:,0)    = f_w(:,nz-1) ;  f_w(:,nz+1) = f_w(:,2)      ! 

    jacob_w = j_arakawa(psi_w,f_w)
    jacobian_arakawa_zcycl = jacob_w(1:nx,1:nz)

      ! ν. ȾʬʤΤ 2 ܤ
        jacobian_arakawa_zcycl(1,:) = jacobian_arakawa_zcycl(1,:)*2 
        jacobian_arakawa_zcycl(nx,:) = jacobian_arakawa_zcycl(nx,:)*2 

    deallocate( psi_w, f_w, jacob_w )
  end function jacobian_arakawa_zcycl

 !----------------------- 2d box Ȣ ----------------------- 
  function jacobian_arakawa_box(psi,f)
    double precision, dimension(:,:)             :: psi, f
    double precision, &
         & dimension(size(psi,1),size(psi,2))    :: jacobian_arakawa_box

    double precision, dimension(:,:),allocatable :: psi_w, f_w, jacob_w
    integer                                      :: nx, nz

    logical  :: ofirst=.true.

    if ( ofirst ) then 
       ofirst = .false.
       write(6,*)'<<< ADVECT. SCHEME BY ARAKAWA JACOBIAN (BOX) 99/08/24 >>>'
    endif

    nx = size(psi,1) ; nz = size(psi,2)

    allocate( psi_w(0:nx+1,0:nz+1), f_w(0:nx+1,0:nz+1) )
    allocate( jacob_w(0:nx+1,0:nz+1) )

    ! ή
      psi_w = 0.0d0 ; psi_w(1:nx,1:nz) = psi
           psi_w(0,1:nz)    = psi(1,:) ;  psi_w(nx+1,1:nz) = psi(nx,:)
           psi_w(1:nx,0)    = psi(:,1) ;  psi_w(1:nx,nz+1) = psi(:,nz)
           psi_w(0,0)       = psi(1,1) 
           psi_w(nx+1,0)    = psi(nx,1) 
           psi_w(0,nz+1)    = psi(1,nz) 
           psi_w(nx+1,nz+1) = psi(nx,nz) 

      ! f ζ. df/dn = 0 Ѥ
      f_w = 0.0 ; f_w(1:nx,1:nz) = f
           f_w(0,1:nz)    = f(2,:) ;  f_w(nx+1,1:nz) = f(nx-1,:)
           f_w(1:nx,0)    = f(:,2) ;  f_w(1:nx,nz+1) = f(:,nz-1)
           f_w(0,0)       = f(2,2) 
           f_w(nx+1,0)    = f(nx-1,2) 
           f_w(0,nz+1)    = f(2,nz-1) 
           f_w(nx+1,nz+1) = f(nx-1,nz-1) 

    jacob_w = j_arakawa(psi_w,f_w)
    jacobian_arakawa_box = jacob_w(1:nx,1:nz)

      ! ν. ȾʬʤΤ 2 ܤ
        jacobian_arakawa_box(1,2:nz-1) = jacobian_arakawa_box(1,2:nz-1)*2 
        jacobian_arakawa_box(nx,2:nz-1) = jacobian_arakawa_box(nx,2:nz-1)*2 
        jacobian_arakawa_box(2:nx-1,1) = jacobian_arakawa_box(2:nx-1,1)*2 
        jacobian_arakawa_box(2:nx-1,nz) = jacobian_arakawa_box(2:nx-1,nz)*2 

      ! ν. Ѥ 4 ܤ
        jacobian_arakawa_box(1,1) = jacobian_arakawa_box(1,1)*4
        jacobian_arakawa_box(nx,1) = jacobian_arakawa_box(nx,1)*4
        jacobian_arakawa_box(1,nz) = jacobian_arakawa_box(1,nz)*4
        jacobian_arakawa_box(nx,nz) = jacobian_arakawa_box(nx,nz)*4 

    deallocate( psi_w, f_w, jacob_w )
  end function jacobian_arakawa_box

!========================[祤󥿡ե]==========================

  function jacobian_arakawa(psi,f)
    double precision, dimension(:,:)                     :: psi, f
    double precision, dimension(size(psi,1),size(psi,2)) :: jacobian_arakawa

    if ( xcycl .and. zcycl ) then
       jacobian_arakawa = jacobian_arakawa_xzcycl(psi,f)
    else if ( (.not. xcycl) .and. zcycl ) then
       jacobian_arakawa = jacobian_arakawa_zcycl(psi,f)
    else if ( xcycl .and. (.not. zcycl) ) then
       jacobian_arakawa = jacobian_arakawa_xcycl(psi,f)
    else
       jacobian_arakawa = jacobian_arakawa_box(psi,f)
    endif
  end function jacobian_arakawa

end module advect_arakawa

