/*
 * Decompiled with CFR 0.152.
 */
package visad.sounder;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.StandardQuantityDB;
import visad.data.netcdf.units.DefaultUnitsDB;
import visad.data.netcdf.units.UnitsDB;
import visad.java3d.DirectManipulationRendererJ3D;

public class Sounding
extends FlatField {
    private static UnitsDB udb;
    private static StandardQuantityDB qdb;
    private static RealType Pressure;
    private static RealType Temperature;
    private static RealType DewPoint;
    private static FunctionType soundingType;
    private Vector soundingDisplay_s = new Vector();
    private DataReferenceImpl sounding_ref;

    public Sounding(float[] pressures, float[] temperatures, float[] dewpoints) throws VisADException, RemoteException {
        super(soundingType, Sounding.makePressureSet(pressures));
        int i;
        if (temperatures == null && dewpoints == null) {
            throw new VisADException("temperatures and dewpoints cannot both be null");
        }
        int length = this.getLength();
        if (temperatures != null && temperatures.length != length || dewpoints != null && dewpoints.length != length) {
            throw new VisADException("temperatures and dewpoints cannot have different lengths");
        }
        if (temperatures == null) {
            temperatures = new float[length];
            for (i = 0; i < length; ++i) {
                temperatures[i] = Float.NaN;
            }
        }
        if (dewpoints == null) {
            dewpoints = new float[length];
            for (i = 0; i < length; ++i) {
                dewpoints[i] = Float.NaN;
            }
        }
        this.setSamples(new float[][]{temperatures, dewpoints});
        this.sounding_ref = new DataReferenceImpl("sounding reference");
        this.sounding_ref.setData(this);
    }

    private static Gridded1DSet makePressureSet(float[] pressures) throws VisADException {
        if (pressures == null) {
            throw new SetException("pressures cannot be null");
        }
        return new Gridded1DSet((MathType)Pressure, (float[][])new float[][]{pressures}, pressures.length, null, new Unit[]{udb.get("hPa")}, null);
    }

    public void addToDisplay(DisplayImpl display) throws VisADException, RemoteException {
        this.addToDisplay(display, null);
    }

    public void addToDisplayWithDirectManipulation(DisplayImpl display) throws VisADException, RemoteException {
        this.addToDisplay(display, new DirectManipulationRendererJ3D());
    }

    private void addToDisplay(DisplayImpl display, DataRenderer renderer) throws VisADException, RemoteException {
        if (this.soundingDisplay_s.contains(display)) {
            return;
        }
        this.soundingDisplay_s.add(display);
        Vector mapVector = display.getMapVector();
        boolean presToYAxis = false;
        boolean tempToXAxis = false;
        boolean dewpToXAxis = false;
        for (int kk = 0; kk < mapVector.size(); ++kk) {
            ScalarMap smap = (ScalarMap)mapVector.elementAt(kk);
            ScalarType s_type = smap.getScalar();
            DisplayRealType d_type = smap.getDisplayScalar();
            if (Pressure.equals(smap) && d_type.equals(Display.YAxis)) {
                presToYAxis = true;
            }
            if (Temperature.equals(smap) && d_type.equals(Display.XAxis)) {
                tempToXAxis = true;
            }
            if (!DewPoint.equals(smap) || !d_type.equals(Display.XAxis)) continue;
            dewpToXAxis = true;
        }
        if (presToYAxis && tempToXAxis && dewpToXAxis) {
            display.removeAllReferences();
            display.addReferences(renderer, this.sounding_ref);
        } else {
            display.removeAllReferences();
            display.clearMaps();
            display.addMap(new ScalarMap(Pressure, Display.YAxis));
            display.addMap(new ScalarMap(Temperature, Display.XAxis));
            display.addMap(new ScalarMap(DewPoint, Display.XAxis));
            display.addReferences(renderer, this.sounding_ref);
        }
    }

    public void remove() throws VisADException, RemoteException {
        for (int kk = 0; kk < this.soundingDisplay_s.size(); ++kk) {
            DisplayImpl display = (DisplayImpl)this.soundingDisplay_s.elementAt(kk);
            display.removeReference(this.sounding_ref);
        }
        this.soundingDisplay_s.removeAllElements();
    }

    public boolean restore() {
        return false;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        float[] p = new float[]{1000.0f, 500.0f, 100.0f};
        float[] t = new float[]{283.0f, 200.0f, 150.0f};
        float[] td = new float[]{273.0f, 180.0f, 100.0f};
        Sounding sounding = new Sounding(p, t, td);
        System.out.println("sounding = " + sounding);
    }

    static {
        try {
            udb = DefaultUnitsDB.instance();
            qdb = StandardQuantityDB.instance();
            Pressure = qdb.get("Pressure");
            Temperature = qdb.get("Temperature");
            DewPoint = new RealType("DewPoint", udb.get("K"), null);
            RealTupleType ttd = new RealTupleType(Temperature, DewPoint);
            soundingType = new FunctionType(Pressure, ttd);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
    }
}

