/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaEigenvalueDecomposition
extends Tuple {
    private static final RealType eigenV_row = RealType.getRealType("eigenV_row");
    private static final RealType eigenV_column = RealType.getRealType("eigenV_column");
    private static final RealType eigenV_value = RealType.getRealType("eigenV_value");
    private static final FunctionType eigenVType = JamaEigenvalueDecomposition.constructEVFunction();
    private static final RealType eigen_domain = RealType.getRealType("eigen_domain");
    private static final RealType eigen_real = RealType.getRealType("eigen_real");
    private static final RealType eigen_imaginary = RealType.getRealType("eigen_imaginary");
    private static final FunctionType eigenRType = JamaEigenvalueDecomposition.constructERFunction();
    private static final FunctionType eigenIType = JamaEigenvalueDecomposition.constructEIFunction();
    private static final Class[] classes = JamaEigenvalueDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private Object ed = ((JamaMatrix)this.getComponent(0)).getStash();
    private static final Method[] methods = JamaEigenvalueDecomposition.constructMethods();
    private static final Method getD = methods[0];
    private static final Method getV = methods[1];
    private static final Method getImagEigenvalues = methods[2];
    private static final Method getRealEigenvalues = methods[3];
    private static final Constructor matrixEigenvalueDecomposition = JamaEigenvalueDecomposition.constructConstructor();

    private static FunctionType constructEVFunction() {
        try {
            RealTupleType tuple = new RealTupleType(eigenV_row, eigenV_column);
            FunctionType function = new FunctionType(tuple, eigenV_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructERFunction() {
        try {
            FunctionType function = new FunctionType(eigen_domain, eigen_real);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructEIFunction() {
        try {
            FunctionType function = new FunctionType(eigen_domain, eigen_imaginary);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] cs = new Class[6];
        try {
            cs[0] = Class.forName("Jama.Matrix");
            cs[1] = Class.forName("Jama.CholeskyDecomposition");
            cs[2] = Class.forName("Jama.EigenvalueDecomposition");
            cs[3] = Class.forName("Jama.LUDecomposition");
            cs[4] = Class.forName("Jama.QRDecomposition");
            cs[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return cs;
    }

    private static Method[] constructMethods() {
        Method[] ms = new Method[4];
        try {
            Class[] param = new Class[]{};
            ms[0] = classEigenvalueDecomposition.getMethod("getD", param);
            ms[1] = classEigenvalueDecomposition.getMethod("getV", param);
            ms[2] = classEigenvalueDecomposition.getMethod("getImagEigenvalues", param);
            ms[3] = classEigenvalueDecomposition.getMethod("getRealEigenvalues", param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return ms;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] param = new Class[]{classMatrix};
            return classEigenvalueDecomposition.getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JamaEigenvalueDecomposition(JamaMatrix matrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixEigenvalueDecomposition.newInstance(matrix.getMatrix()), false);
    }

    JamaEigenvalueDecomposition(Object e, boolean copy) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaEigenvalueDecomposition.makeDatums(e), copy);
    }

    private static Data[] makeDatums(Object e) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object m3 = getV.invoke(e, new Object[0]);
        JamaMatrix jm = new JamaMatrix(m3, eigenVType, null, null, null, null, null);
        jm.setStash(e);
        double[] rs = (double[])getRealEigenvalues.invoke(e, new Object[0]);
        FlatField rf = new FlatField(eigenRType, new Integer1DSet(rs.length));
        rf.setSamples(new double[][]{rs});
        double[] ims = (double[])getImagEigenvalues.invoke(e, new Object[0]);
        FlatField imf = new FlatField(eigenIType, new Integer1DSet(ims.length));
        imf.setSamples(new double[][]{ims});
        return new Data[]{jm, rf, imf};
    }

    public Object getEigenvalueDecomposition() {
        return this.ed;
    }

    public JamaMatrix getV() throws VisADException, RemoteException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getD() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m3 = getD.invoke(this.ed, new Object[0]);
        return new JamaMatrix(m3);
    }

    public double[] getRealEigenvalues() throws VisADException, RemoteException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField rf = (FlatField)this.getComponent(1);
        double[][] v = rf.getValues(false);
        return v[0];
    }

    public double[] getImagEigenvalues() throws VisADException, RemoteException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField imf = (FlatField)this.getComponent(2);
        double[][] v = imf.getValues(false);
        return v[0];
    }
}

