/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.ColorControl;
import visad.ContourControl;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.ValueControl;
import visad.jmet.NetcdfGrids;

public class NCEPPanel
extends JPanel
implements ActionListener,
ChangeListener {
    static int instance = 0;
    private int myInstance;
    private JSlider levelSlider;
    private JSlider speedSlider;
    private JTextField intervalText;
    private JLabel levelSliderLabel;
    private JLabel intervalUnits;
    private int levelValue;
    private double intervalValue;
    private JComboBox paramBox;
    private DataReference ref;
    private ContourControl ci;
    private RealType Values;
    private Tuple[] tup;
    private NetcdfGrids ncg = null;
    private JLabel statLabel;
    private JTabbedPane tabby;
    private JButton butColor;
    private float[][] colorTable;
    private String paramName;
    private JCheckBox showHide;
    private DisplayImpl di;
    private ValueControl control;
    private ColorControl ccon;
    private Color nc;
    private ScalarMap map;
    private RealType enable;
    private FieldImpl field;
    private String valueName;
    private String enableName;
    private String dataName;
    private ScalarMap valueMap;
    private ScalarMap valueColorMap;
    private boolean isAloft;
    private int ndx;
    private Vector paramInfo;
    private double[] pressureLevels;
    private double[][] range;
    private double cbeg;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JLabel sl = new JLabel("The status label");
        NCEPPanel ss = new NCEPPanel(true, null, sl, null, "Title");
        Container cf = f.getContentPane();
        cf.add(ss);
        sl.setAlignmentX(0.5f);
        cf.add(sl);
        f.setSize(600, 600);
        f.setVisible(true);
    }

    public NCEPPanel(boolean isAloft, DisplayImpl di, JLabel statLabel, JTabbedPane tabby, String title) {
        this.di = di;
        this.statLabel = statLabel;
        this.isAloft = isAloft;
        this.tabby = tabby;
        this.myInstance = NCEPPanel.getNextInstance();
        this.valueName = "Value" + (this.myInstance + 1);
        this.enableName = "enable" + (this.myInstance + 1);
        this.dataName = "data" + (this.myInstance + 1);
        this.range = new double[1][2];
        this.range[0][0] = -20000.0;
        this.cbeg = 0.0;
        this.range[0][1] = 20000.0;
        this.colorTable = new float[3][256];
        if (di != null) {
            try {
                int i;
                this.Values = RealType.getRealType(this.valueName);
                this.nc = Color.white;
                if (isAloft) {
                    this.valueMap = new ScalarMap(this.Values, Display.IsoContour);
                    this.valueColorMap = new ScalarMap(this.Values, Display.RGB);
                    di.addMap(this.valueMap);
                    di.addMap(this.valueColorMap);
                    this.ci = (ContourControl)this.valueMap.getControl();
                    this.ci.setContourInterval(30.0f, 0.0f, 20000.0f, 60.0f);
                    this.ci.enableLabels(true);
                    for (i = 0; i < 256; ++i) {
                        this.colorTable[0][i] = 1.0f;
                        this.colorTable[1][i] = 1.0f;
                        this.colorTable[2][i] = 1.0f;
                    }
                    this.ccon = (ColorControl)this.valueColorMap.getControl();
                    this.ccon.setTable(this.colorTable);
                } else {
                    this.valueMap = new ScalarMap(this.Values, Display.RGB);
                    di.addMap(this.valueMap);
                    for (i = 0; i < 256; ++i) {
                        this.colorTable[0][i] = (float)i / 255.0f;
                        this.colorTable[1][i] = (float)i / 255.0f;
                        this.colorTable[2][i] = (float)i / 255.0f;
                    }
                    this.ccon = (ColorControl)this.valueMap.getControl();
                    this.ccon.setTable(this.colorTable);
                }
                this.enable = RealType.getRealType(this.enableName);
                this.map = new ScalarMap(this.enable, Display.SelectValue);
                di.addMap(this.map);
            }
            catch (Exception ec) {
                ec.printStackTrace();
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        TitledBorder border = new TitledBorder(new LineBorder(Color.black), title, 2, 3);
        border.setTitleColor(Color.black);
        this.setBorder(border);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.levelValue = 0;
        if (isAloft) {
            this.levelSliderLabel = new JLabel("Pressure level = 1000", 0);
            this.levelSliderLabel.setAlignmentX(0.5f);
            this.levelSlider = new JSlider(0, 0, 100, 0);
            this.levelSlider.setMaximumSize(new Dimension(200, 50));
            this.levelSlider.setAlignmentX(0.5f);
            this.levelSlider.addChangeListener(this);
            this.add(this.levelSliderLabel);
            this.add(this.levelSlider);
            this.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        String[] s2 = new String[]{"Choose a data file first"};
        this.paramBox = new JComboBox<String>(s2);
        this.paramBox.setMaximumSize(new Dimension(250, 50));
        this.paramBox.setAlignmentX(0.5f);
        this.paramBox.addActionListener(this);
        this.paramBox.setActionCommand("paramBox");
        JLabel paramBoxLabel = new JLabel("Selected parameter:");
        paramBoxLabel.setAlignmentX(1.0f);
        this.add(paramBoxLabel);
        this.add(this.paramBox);
        this.intervalValue = 60.0;
        if (isAloft) {
            this.add(Box.createRigidArea(new Dimension(10, 10)));
            JLabel intervalTextLabel = new JLabel("Contour interval:");
            intervalTextLabel.setAlignmentX(1.0f);
            this.add(intervalTextLabel);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.setAlignmentX(0.5f);
            this.intervalText = new JTextField("Enter value", 8);
            this.intervalText.setMaximumSize(this.intervalText.getPreferredSize());
            this.intervalText.setActionCommand("intervaltext");
            this.intervalText.addActionListener(this);
            this.intervalUnits = new JLabel("<units>");
            p.add(this.intervalText);
            p.add(this.intervalUnits);
            this.add(p);
        }
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel pb = new JPanel();
        pb.setLayout(new BoxLayout(pb, 0));
        pb.setAlignmentX(0.5f);
        this.butColor = new JButton("Color");
        this.butColor.addActionListener(this);
        this.butColor.setActionCommand("butColor");
        this.butColor.setBackground(this.nc);
        pb.add(this.butColor);
        this.showHide = new JCheckBox("Make visible");
        this.showHide.addActionListener(this);
        this.showHide.setActionCommand("showbutton");
        this.showHide.setSelected(true);
        pb.add(Box.createRigidArea(new Dimension(20, 10)));
        pb.add(this.showHide);
        this.add(pb);
    }

    private static synchronized int getNextInstance() {
        return instance++;
    }

    public void setNetcdfGrid(NetcdfGrids n) {
        try {
            if (this.ref != null && this.di != null) {
                this.di.removeReference(this.ref);
            }
        }
        catch (Exception rmrf) {
            rmrf.printStackTrace();
        }
        this.ncg = n;
        if (this.isAloft) {
            this.pressureLevels = this.ncg.getPressureLevels();
            int num_levels = this.ncg.getNumberOfLevels();
            this.range = new double[num_levels][2];
            this.levelSlider.setMinimum(0);
            this.levelSlider.setMaximum(num_levels - 1);
            this.levelSlider.setValue(0);
            this.levelValue = 0;
            this.intervalValue = 60.0;
            this.intervalText.setText("Enter value");
        }
        if (this.tabby != null) {
            this.tabby.setTitleAt(this.myInstance, "Data");
            this.tabby.setBackgroundAt(this.myInstance, this.nc);
        }
    }

    public void setParams(Vector v) {
        this.paramInfo = v;
        this.paramBox.removeAllItems();
        this.paramBox.addItem("-- none --");
        for (int m3 = 0; m3 < this.paramInfo.size(); m3 += 3) {
            String miName = (String)this.paramInfo.elementAt(m3 + 1);
            this.paramBox.addItem(miName);
        }
        this.revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        block21: {
            String cmd = e.getActionCommand();
            if (cmd.equals("paramBox")) {
                this.paramName = (String)this.paramBox.getSelectedItem();
                this.ndx = this.paramBox.getSelectedIndex();
                if (this.paramName != null && this.ndx > 0) {
                    this.paramName = (String)this.paramInfo.elementAt((this.ndx - 1) * 3);
                    Thread t = new Thread(){

                        public void run() {
                            try {
                                NCEPPanel.this.statLabel.setText("Reading data...please wait!");
                                NCEPPanel.access$102(NCEPPanel.this, NCEPPanel.this.ncg.getGrids(NCEPPanel.this.paramName, NCEPPanel.this.Values, NCEPPanel.this.range));
                                NCEPPanel.this.statLabel.setText("Done reading data...");
                                NCEPPanel.this.di.disableAction();
                                FunctionType type = new FunctionType(NCEPPanel.this.enable, NCEPPanel.this.tup[NCEPPanel.this.levelValue].getType());
                                Integer1DSet set = new Integer1DSet((MathType)NCEPPanel.this.enable, 2);
                                NCEPPanel.this.field = new FieldImpl(type, set);
                                NCEPPanel.this.field.setSample(0, (Data)NCEPPanel.this.tup[NCEPPanel.this.levelValue]);
                                if (NCEPPanel.this.ref != null) {
                                    NCEPPanel.this.di.removeReference(NCEPPanel.this.ref);
                                }
                                NCEPPanel.this.control = (ValueControl)((Object)NCEPPanel.this.map.getControl());
                                NCEPPanel.this.ref = new DataReferenceImpl(NCEPPanel.this.dataName);
                                NCEPPanel.this.valueMap.setRange(NCEPPanel.this.range[NCEPPanel.this.levelValue][0], NCEPPanel.this.range[NCEPPanel.this.levelValue][1]);
                                if (NCEPPanel.this.isAloft) {
                                    NCEPPanel.this.intervalUnits.setText((String)NCEPPanel.this.paramInfo.elementAt((NCEPPanel.this.ndx - 1) * 3 + 2));
                                    NCEPPanel.this.setContInterval(NCEPPanel.this.range[NCEPPanel.this.levelValue]);
                                }
                                NCEPPanel.this.ref.setData(NCEPPanel.this.field);
                                NCEPPanel.this.di.addReference(NCEPPanel.this.ref);
                                NCEPPanel.this.di.enableAction();
                                NCEPPanel.this.statLabel.setText("Rendering display...please wait!");
                                if (NCEPPanel.this.tabby != null) {
                                    NCEPPanel.this.tabby.setTitleAt(NCEPPanel.this.myInstance, NCEPPanel.this.paramName);
                                    NCEPPanel.this.tabby.setBackgroundAt(NCEPPanel.this.myInstance, NCEPPanel.this.nc);
                                }
                            }
                            catch (Exception ep) {
                                ep.printStackTrace();
                            }
                        }
                    };
                    t.start();
                }
            } else if (cmd.equals("showbutton")) {
                try {
                    if (this.showHide.isSelected()) {
                        this.control.setValue(0.0);
                        break block21;
                    }
                    this.control.setValue(1.0);
                }
                catch (Exception selb) {
                    selb.printStackTrace();
                }
            } else if (cmd.equals("intervaltext")) {
                try {
                    String v = this.intervalText.getText();
                    this.intervalValue = Double.valueOf(v);
                    if (this.ci != null & this.ref != null) {
                        this.ci.setContourInterval((float)this.intervalValue, (float)this.range[this.levelValue][0], (float)this.range[this.levelValue][1], (float)this.cbeg);
                    }
                    this.statLabel.setText("Rendering display...please wait!");
                }
                catch (NumberFormatException nivt) {
                    this.statLabel.setText("Invalid number...try again!");
                    this.getToolkit().beep();
                }
                catch (Exception ivt) {
                    ivt.printStackTrace();
                }
            } else if (cmd.equals("butColor")) {
                JColorChooser cc = new JColorChooser();
                this.nc = JColorChooser.showDialog(this, "Choose contour color", Color.white);
                if (this.nc != null) {
                    this.butColor.setBackground(this.nc);
                    if (this.tabby != null) {
                        this.tabby.setBackgroundAt(this.myInstance, this.nc);
                    }
                    try {
                        for (int i = 0; i < 256; ++i) {
                            if (this.isAloft) {
                                this.colorTable[0][i] = (float)this.nc.getRed() / 255.0f;
                                this.colorTable[1][i] = (float)this.nc.getGreen() / 255.0f;
                                this.colorTable[2][i] = (float)this.nc.getBlue() / 255.0f;
                                continue;
                            }
                            this.colorTable[0][i] = (float)this.nc.getRed() / 255.0f * (float)i / 255.0f;
                            this.colorTable[1][i] = (float)this.nc.getGreen() / 255.0f * (float)i / 255.0f;
                            this.colorTable[2][i] = (float)this.nc.getBlue() / 255.0f * (float)i / 255.0f;
                        }
                        this.ccon.setTable(this.colorTable);
                    }
                    catch (Exception ce) {
                        ce.printStackTrace();
                    }
                }
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.levelSlider) && this.ncg != null) {
            int val = this.levelSlider.getValue();
            if (val != this.levelValue) {
                this.levelSliderLabel.setText("Pressure level = " + this.pressureLevels[val]);
            }
            if (val != this.levelValue & !this.levelSlider.getValueIsAdjusting()) {
                this.levelValue = val;
                if (this.ref != null) {
                    try {
                        this.di.disableAction();
                        this.valueMap.setRange(this.range[this.levelValue][0], this.range[this.levelValue][1]);
                        this.setContInterval(this.range[this.levelValue]);
                        this.field.setSample(0, (Data)this.tup[this.levelValue]);
                        this.di.enableAction();
                        this.statLabel.setText("Rendering display...please wait!");
                    }
                    catch (Exception sl) {
                        sl.printStackTrace();
                    }
                }
            }
        }
    }

    void setContInterval(double[] range) {
        double cint = (range[1] - range[0]) * 0.11;
        long lscal = (long)(Math.log(cint) / Math.log(10.0));
        if (cint < 1.0) {
            --lscal;
        }
        double cscal = Math.pow(10.0, lscal);
        cint = Math.floor(cint / cscal) * cscal;
        this.cbeg = Math.floor(range[0] / cint) * cint;
        try {
            this.ci.setContourInterval((float)cint, (float)range[0], (float)range[1], (float)this.cbeg);
            this.intervalText.setText(cint + " ");
        }
        catch (Exception sci) {
            sci.printStackTrace();
        }
    }

    static /* synthetic */ Tuple[] access$102(NCEPPanel x0, Tuple[] x1) {
        x0.tup = x1;
        return x1;
    }
}

