/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import visad.ContourControl;
import visad.ContourLabelGeometry;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.MathType;
import visad.ProjectionControl;
import visad.Set;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.TextControl;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADTriangleArray;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.GraphicsModeControlJ3D;
import visad.java3d.LabelTransform;
import visad.java3d.ProjectionControlListener;

public abstract class ShadowTypeJ3D
extends ShadowType {
    private static Hashtable appearanceCache = new Hashtable();
    private static Hashtable coloringAttributesCache = new Hashtable();
    private static Hashtable transparencyAttributesCache = new Hashtable();
    private boolean cacheAppearances = false;
    private boolean mergeShapes = false;
    public static int appearanceCnt = 0;
    public static int shape3DCnt = 0;
    MathType Type;
    transient DataDisplayLink Link;
    transient DisplayImplJ3D display;
    private transient Data data;
    private ShadowTypeJ3D Parent;
    String inheritedText = null;
    TextControl inheritedTextControl = null;
    ShadowType adaptedShadowType;
    ProjectionControlListener projListener = null;
    private Object MUTEX = new Object();

    public ShadowTypeJ3D(MathType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(type, link, ShadowTypeJ3D.getAdaptedParent(parent));
        this.Type = type;
        this.Link = link;
        this.display = (DisplayImplJ3D)link.getDisplay();
        this.Parent = (ShadowTypeJ3D)parent;
        this.data = link.getData();
    }

    public static ShadowType getAdaptedParent(ShadowType parent) {
        if (parent == null) {
            return null;
        }
        return parent.getAdaptedShadowType();
    }

    public ShadowType getAdaptedShadowType() {
        return this.adaptedShadowType;
    }

    public ShadowRealType[] getComponents(ShadowType type, boolean doRef) throws VisADException {
        return this.adaptedShadowType.getComponents(type, doRef);
    }

    public String getParentText() {
        if (this.Parent != null && this.Parent.inheritedText != null && this.Parent.inheritedTextControl != null) {
            return this.Parent.inheritedText;
        }
        return null;
    }

    public TextControl getParentTextControl() {
        if (this.Parent != null && this.Parent.inheritedText != null && this.Parent.inheritedTextControl != null) {
            return this.Parent.inheritedTextControl;
        }
        return null;
    }

    public void setText(String text, TextControl control) {
        this.inheritedText = text;
        this.inheritedTextControl = control;
    }

    public Data getData() {
        return this.data;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public MathType getType() {
        return this.Type;
    }

    public int getLevelOfDifficulty() {
        return this.adaptedShadowType.getLevelOfDifficulty();
    }

    public boolean getMultipleDisplayScalar() {
        return this.adaptedShadowType.getMultipleDisplayScalar();
    }

    public boolean getMappedDisplayScalar() {
        return this.adaptedShadowType.getMappedDisplayScalar();
    }

    public int[] getDisplayIndices() {
        return this.adaptedShadowType.getDisplayIndices();
    }

    public int[] getValueIndices() {
        return this.adaptedShadowType.getValueIndices();
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        return this.adaptedShadowType.checkIndices(indices, display_indices, value_indices, isTransform, levelOfDifficulty);
    }

    public void preProcess() throws VisADException {
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return false;
    }

    public void postProcess(Object group) throws VisADException {
    }

    public static void mapValues(float[][] display_values, double[][] values, ShadowRealType[] reals) throws VisADException {
        ShadowType.mapValues(display_values, values, reals);
    }

    public static void mapValues(float[][] display_values, float[][] values, ShadowRealType[] reals) throws VisADException {
        ShadowTypeJ3D.mapValues(display_values, values, reals, true);
    }

    public static void mapValues(float[][] display_values, float[][] values, ShadowRealType[] reals, boolean copy) throws VisADException {
        ShadowType.mapValues(display_values, values, reals, copy);
    }

    public static VisADGeometryArray makePointGeometry(float[][] spatial_values, byte[][] color_values) throws VisADException {
        return ShadowType.makePointGeometry(spatial_values, color_values);
    }

    public Appearance makeAppearance(GraphicsModeControl mode, TransparencyAttributes constant_alpha, ColoringAttributes constant_color, GeometryArray geometry, boolean no_material) {
        return ShadowTypeJ3D.staticMakeCachedAppearance(mode, constant_alpha, constant_color, geometry, no_material, false);
    }

    private Appearance makeCachedAppearance(GraphicsModeControl mode, TransparencyAttributes constant_alpha, ColoringAttributes constant_color, GeometryArray geometry, boolean no_material, boolean okToCache) {
        return ShadowTypeJ3D.staticMakeCachedAppearance(mode, constant_alpha, constant_color, geometry, no_material, okToCache);
    }

    private void addToShape(Group group, GeometryArray geometry, Appearance appearance) {
        Shape3D shape = null;
        if (this.mergeShapes) {
            int cnt = group.numChildren();
            for (int i = 0; i < cnt; ++i) {
                Shape3D s2;
                int subcnt;
                Node node = group.getChild(i);
                if (!(node instanceof Shape3D) || (subcnt = (s2 = (Shape3D)node).numGeometries()) > 0 && !s2.getGeometry(0).getClass().equals(geometry.getClass()) || !s2.getAppearance().equals(appearance)) continue;
                shape = s2;
                break;
            }
        }
        if (shape == null) {
            shape = new Shape3D((Geometry)geometry, appearance);
            shape.setCapability(12);
            shape.setCapability(14);
            group.addChild((Node)shape);
            ++shape3DCnt;
        } else {
            shape.addGeometry((Geometry)geometry);
        }
    }

    private ColoringAttributes getColoringAttributes(float red, float green, float blue) {
        ColoringAttributes ca = null;
        String key = null;
        if (this.cacheAppearances) {
            key = red + "," + green + "," + blue;
            ca = (ColoringAttributes)coloringAttributesCache.get(key);
        }
        if (ca == null) {
            ca = new ColoringAttributes(red, green, blue, 3);
            ca.setCapability(0);
            ca.setCapability(2);
            if (this.cacheAppearances) {
                coloringAttributesCache.put(key, ca);
            }
        }
        return ca;
    }

    private TransparencyAttributes getTransparencyAttributes(int mode, float value) {
        String key = null;
        TransparencyAttributes ta = null;
        if (this.cacheAppearances) {
            key = mode + "_" + value;
            ta = (TransparencyAttributes)transparencyAttributesCache.get(key);
        }
        if (ta == null) {
            ta = new TransparencyAttributes(mode, value);
            ta.setCapability(0);
            ta.setCapability(2);
            if (this.cacheAppearances) {
                transparencyAttributesCache.put(key, ta);
            }
        }
        return ta;
    }

    public static Appearance staticMakeAppearance(GraphicsModeControl mode, TransparencyAttributes constant_alpha, ColoringAttributes constant_color, GeometryArray geometry, boolean no_material) {
        return ShadowTypeJ3D.staticMakeCachedAppearance(mode, constant_alpha, constant_color, geometry, no_material, false);
    }

    private static Appearance staticMakeCachedAppearance(GraphicsModeControl mode, TransparencyAttributes constant_alpha, ColoringAttributes constant_color, GeometryArray geometry, boolean no_material, boolean okToCache) {
        boolean doMaterial = false;
        if (!(geometry instanceof LineArray || geometry instanceof PointArray || geometry instanceof IndexedLineArray || geometry instanceof IndexedPointArray || geometry instanceof IndexedLineStripArray || geometry instanceof LineStripArray || no_material)) {
            doMaterial = true;
        }
        String cacheKey = null;
        Appearance appearance = null;
        if (mode.getCacheAppearances() && okToCache && (appearance = (Appearance)appearanceCache.get(cacheKey = mode.getSaveString() + "_" + (constant_alpha == null ? "null" : constant_alpha.getTransparency() + "_" + constant_alpha.getTransparencyMode()) + "_" + constant_color + "_" + new Boolean(doMaterial))) != null) {
            return appearance;
        }
        ++appearanceCnt;
        appearance = new Appearance();
        appearance.setCapability(8);
        appearance.setCapability(16);
        appearance.setCapability(0);
        appearance.setCapability(18);
        appearance.setCapability(14);
        appearance.setCapability(12);
        appearance.setCapability(4);
        appearance.setCapability(6);
        appearance.setCapability(2);
        appearance.setCapability(10);
        LineAttributes line = new LineAttributes();
        line.setCapability(4);
        line.setCapability(2);
        line.setCapability(0);
        line.setLineWidth(mode.getLineWidth());
        int pattern = GraphicsModeControlJ3D.LINE_PATTERN[mode.getLineStyle()];
        line.setLinePattern(pattern);
        appearance.setLineAttributes(line);
        PointAttributes point = new PointAttributes();
        point.setCapability(2);
        point.setCapability(0);
        point.setPointSize(mode.getPointSize());
        appearance.setPointAttributes(point);
        PolygonAttributes polygon = new PolygonAttributes();
        polygon.setCapability(0);
        polygon.setCapability(2);
        polygon.setCapability(6);
        polygon.setCapability(4);
        polygon.setCullFace(0);
        polygon.setPolygonMode(mode.getPolygonMode());
        try {
            float polygonOffset = mode.getPolygonOffset();
            if (polygonOffset == polygonOffset) {
                polygon.setPolygonOffset(polygonOffset);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Method method = polygon.getClass().getMethod("setPolygonOffsetFactor", Float.TYPE);
            float polygonOffsetFactor = mode.getPolygonOffsetFactor();
            if (polygonOffsetFactor == polygonOffsetFactor) {
                method.invoke((Object)polygon, new Float(polygonOffsetFactor));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        appearance.setPolygonAttributes(polygon);
        RenderingAttributes rendering = new RenderingAttributes();
        rendering.setCapability(2);
        rendering.setCapability(0);
        rendering.setCapability(4);
        rendering.setDepthBufferEnable(true);
        appearance.setRenderingAttributes(rendering);
        if (constant_color != null) {
            appearance.setColoringAttributes(constant_color);
        }
        if (doMaterial) {
            Material material = new Material();
            material.setCapability(0);
            material.setSpecularColor(0.0f, 0.0f, 0.0f);
            if (!mode.getMode2D()) {
                material.setLightingEnable(true);
            }
            appearance.setMaterial(material);
        }
        if (constant_alpha != null) {
            appearance.setTransparencyAttributes(constant_alpha);
        }
        if (cacheKey != null) {
            appearanceCache.put(cacheKey, appearance);
        }
        return appearance;
    }

    public VisADGeometryArray[] assembleShape(float[][] display_values, int valueArrayLength, int[] valueToMap, Vector MapVector, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, int index, ShadowType shadow_api) throws VisADException, RemoteException {
        return this.adaptedShadowType.assembleShape(display_values, valueArrayLength, valueToMap, MapVector, valueToScalar, display, default_values, inherited_values, spatial_values, color_values, range_select, index, shadow_api);
    }

    public Set assembleSpatial(float[][] spatial_values, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, Set domain_set, boolean allSpatial, boolean set_for_shape, int[] spatialDimensions, boolean[][] range_select, float[][] flow1_values, float[][] flow2_values, float[] flowScale, boolean[] swap, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        return this.adaptedShadowType.assembleSpatial(spatial_values, display_values, valueArrayLength, valueToScalar, display, default_values, inherited_values, domain_set, allSpatial, set_for_shape, spatialDimensions, range_select, flow1_values, flow2_values, flowScale, swap, renderer, shadow_api);
    }

    public void assembleFlow(float[][] flow1_values, float[][] flow2_values, float[] flowScale, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        this.adaptedShadowType.assembleFlow(flow1_values, flow2_values, flowScale, display_values, valueArrayLength, valueToScalar, display, default_values, range_select, renderer, shadow_api);
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        return this.adaptedShadowType.makeFlow(which, flow_values, flowScale, spatial_values, color_values, range_select);
    }

    public VisADGeometryArray[] makeStreamline(int which, float[][] flow_values, float flowScale, float[][] spatial_values, Set spatial_set, int spatialManifoldDimension, byte[][] color_values, boolean[][] range_select, int valueArrayLength, int[] valueToMap, Vector MapVector) throws VisADException {
        return this.adaptedShadowType.makeStreamline(which, flow_values, flowScale, spatial_values, spatial_set, spatialManifoldDimension, color_values, range_select, valueArrayLength, valueToMap, MapVector);
    }

    public boolean makeContour(int valueArrayLength, int[] valueToScalar, float[][] display_values, int[] inherited_values, Vector MapVector, int[] valueToMap, int domain_length, boolean[][] range_select, int spatialManifoldDimension, Set spatial_set, byte[][] color_values, boolean indexed, Object group, GraphicsModeControl mode, boolean[] swap, float constant_alpha, float[] constant_color, ShadowType shadow_api, ShadowRealTupleType Domain2, ShadowRealType[] DomainReferenceComponents, Set domain_set, Unit[] domain_units, CoordinateSystem dataCoordinateSystem) throws VisADException {
        return this.adaptedShadowType.makeContour(valueArrayLength, valueToScalar, display_values, inherited_values, MapVector, valueToMap, domain_length, range_select, spatialManifoldDimension, spatial_set, color_values, indexed, group, mode, swap, constant_alpha, constant_color, shadow_api, Domain2, DomainReferenceComponents, domain_set, domain_units, dataCoordinateSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelsToGroup(Object group, VisADGeometryArray[] arrays, GraphicsModeControl mode, ContourControl control, ProjectionControl p_cntrl, int[] cnt_a, float constant_alpha, float[] constant_color) throws VisADException {
        Object object = this.MUTEX;
        synchronized (object) {
            ContourLabelGeometry array;
            int cnt = cnt_a[0];
            if (cnt == 0) {
                this.projListener = new ProjectionControlListener(p_cntrl, control);
            }
            int n_labels = arrays.length;
            if (!control.contourFilled() && arrays != null) {
                this.projListener.LT_array[cnt] = new LabelTransform[3][n_labels];
                GraphicsModeControl styledMode = (GraphicsModeControl)mode.clone();
                styledMode.setLineStyle(control.getDashedStyle(), false);
                for (int ii = 0; ii < n_labels; ++ii) {
                    array = (ContourLabelGeometry)arrays[ii];
                    TransformGroup segL_trans_group = new TransformGroup();
                    TransformGroup segR_trans_group = new TransformGroup();
                    segL_trans_group.setCapability(17);
                    segL_trans_group.setCapability(18);
                    segL_trans_group.setCapability(12);
                    segR_trans_group.setCapability(17);
                    segR_trans_group.setCapability(18);
                    segR_trans_group.setCapability(12);
                    if (control.getAutoSizeLabels()) {
                        LabelTransform lbl_trans;
                        this.projListener.LT_array[cnt][1][ii] = lbl_trans = new LabelTransform(segL_trans_group, p_cntrl, new VisADGeometryArray[]{array.expSegLeft, array.segLeftAnchor}, array.segLeftScaleInfo, 1);
                        this.projListener.LT_array[cnt][2][ii] = lbl_trans = new LabelTransform(segR_trans_group, p_cntrl, new VisADGeometryArray[]{array.expSegRight, array.segRightAnchor}, array.segRightScaleInfo, 1);
                    }
                    ((Group)group).addChild((Node)segL_trans_group);
                    ((Group)group).addChild((Node)segR_trans_group);
                    if (array.isStyled) {
                        this.addToGroup(segL_trans_group, array.expSegLeft, styledMode, constant_alpha, constant_color);
                        this.addToGroup(segR_trans_group, array.expSegRight, styledMode, constant_alpha, constant_color);
                        continue;
                    }
                    this.addToGroup(segL_trans_group, array.expSegLeft, mode, constant_alpha, constant_color);
                    this.addToGroup(segR_trans_group, array.expSegRight, mode, constant_alpha, constant_color);
                }
            } else {
                this.projListener.LT_array[cnt] = new LabelTransform[1][n_labels];
            }
            cnt = cnt_a[0];
            for (int ii = 0; ii < n_labels; ++ii) {
                TransformGroup lbl_trans_group = new TransformGroup();
                lbl_trans_group.setCapability(17);
                lbl_trans_group.setCapability(18);
                lbl_trans_group.setCapability(12);
                array = (ContourLabelGeometry)arrays[ii];
                if (control.getAutoSizeLabels()) {
                    LabelTransform lbl_trans;
                    this.projListener.LT_array[cnt][0][ii] = lbl_trans = new LabelTransform(lbl_trans_group, p_cntrl, new VisADGeometryArray[]{array.label, array.labelAnchor}, null, 0);
                }
                ((Group)group).addChild((Node)lbl_trans_group);
                this.addToGroup(lbl_trans_group, array.label, mode, constant_alpha, constant_color);
            }
            this.projListener.cnt = ++cnt;
            cnt_a[0] = cnt;
        }
    }

    public VisADGeometryArray makeText(String[] text_values, TextControl text_control, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        return this.adaptedShadowType.makeText(text_values, text_control, spatial_values, color_values, range_select);
    }

    public byte[][] assembleColor(float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, boolean[] single_missing, ShadowType shadow_api) throws VisADException, RemoteException {
        return this.adaptedShadowType.assembleColor(display_values, valueArrayLength, valueToScalar, display, default_values, range_select, single_missing, shadow_api);
    }

    public boolean[][] assembleSelect(float[][] display_values, int domain_length, int valueArrayLength, int[] valueToScalar, DisplayImpl display, ShadowType shadow_api) throws VisADException {
        return this.adaptedShadowType.assembleSelect(display_values, domain_length, valueArrayLength, valueToScalar, display, shadow_api);
    }

    public boolean terminalTupleOrScalar(Object group, float[][] display_values, String text_value, TextControl text_control, int valueArrayLength, int[] valueToScalar, float[] default_values, int[] inherited_values, DataRenderer renderer) throws VisADException, RemoteException {
        boolean post = this.adaptedShadowType.terminalTupleOrScalar(group, display_values, text_value, text_control, valueArrayLength, valueToScalar, default_values, inherited_values, renderer, this);
        this.ensureNotEmpty(group);
        return post;
    }

    public void ensureNotEmpty(Object obj) {
        ShadowTypeJ3D.ensureNotEmpty(obj, this.display);
    }

    public static void ensureNotEmpty(Object obj, DisplayImpl display) {
        if (!(obj instanceof Group)) {
            return;
        }
        Group group = (Group)obj;
        if (group.numChildren() > 0) {
            return;
        }
        PointArray geometry = new PointArray(1, 5);
        geometry.setCapability(2);
        geometry.setCapability(0);
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(4);
        float[] coordinates = new float[]{1000000.0f, 1000000.0f, 1000000.0f};
        geometry.setCoordinates(0, coordinates);
        float[] colors = new float[]{0.0f, 0.0f, 0.0f};
        geometry.setColors(0, colors);
        Appearance appearance = ShadowTypeJ3D.staticMakeCachedAppearance(display.getGraphicsModeControl(), null, null, (GeometryArray)geometry, false, true);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        shape.setCapability(12);
        shape.setCapability(14);
        group.addChild((Node)shape);
    }

    public boolean addToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        this.cacheAppearances = mode.getCacheAppearances();
        this.mergeShapes = mode.getMergeGeometries();
        if (array != null && array.vertexCount > 0) {
            float af = 0.0f;
            TransparencyAttributes c_alpha = null;
            if (constant_alpha == 1.0f) {
                c_alpha = this.getTransparencyAttributes(4, 0.0f);
            } else if (constant_alpha == constant_alpha) {
                c_alpha = this.getTransparencyAttributes(mode.getTransparencyMode(), constant_alpha);
                af = constant_alpha;
            } else {
                c_alpha = this.getTransparencyAttributes(mode.getTransparencyMode(), 0.0f);
            }
            ColoringAttributes c_color = null;
            if (constant_color != null && constant_color.length == 3) {
                c_color = this.getColoringAttributes(constant_color[0], constant_color[1], constant_color[2]);
                if (!(array instanceof VisADLineArray || array instanceof VisADPointArray || array instanceof VisADLineStripArray || array.colors != null)) {
                    int color_len = 3;
                    if (af != 0.0f) {
                        color_len = 4;
                    }
                    byte r = ShadowType.floatToByte(constant_color[0]);
                    byte g2 = ShadowType.floatToByte(constant_color[1]);
                    byte b = ShadowType.floatToByte(constant_color[2]);
                    int len = array.vertexCount * color_len;
                    byte[] colors = new byte[len];
                    boolean k = false;
                    if (color_len == 3) {
                        for (int i = 0; i < len; i += 3) {
                            colors[i] = r;
                            colors[i + 1] = g2;
                            colors[i + 2] = b;
                        }
                    } else {
                        byte a = ShadowType.floatToByte(af);
                        for (int i = 0; i < len; i += 4) {
                            colors[i] = r;
                            colors[i + 1] = g2;
                            colors[i + 2] = b;
                            colors[i + 3] = a;
                        }
                    }
                    array.colors = colors;
                }
            }
            GeometryArray geometry = this.display.makeGeometry(array);
            Appearance appearance = this.makeCachedAppearance(mode, c_alpha, c_color, geometry, false, true);
            this.addToShape((Group)group, geometry, appearance);
            return true;
        }
        return false;
    }

    public boolean addTextToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        if (array != null && array.vertexCount > 0) {
            float af = 0.0f;
            TransparencyAttributes c_alpha = null;
            if (constant_alpha == 1.0f) {
                c_alpha = this.getTransparencyAttributes(4, 0.0f);
            } else if (constant_alpha == constant_alpha) {
                c_alpha = this.getTransparencyAttributes(mode.getTransparencyMode(), constant_alpha);
                af = constant_alpha;
            } else {
                c_alpha = this.getTransparencyAttributes(mode.getTransparencyMode(), 0.0f);
            }
            ColoringAttributes c_color = null;
            if (constant_color != null && constant_color.length == 3) {
                c_color = this.getColoringAttributes(constant_color[0], constant_color[1], constant_color[2]);
                if (!(array instanceof VisADLineArray || array instanceof VisADPointArray || array instanceof VisADLineStripArray || array.colors != null)) {
                    int color_len = 3;
                    if (af != 0.0f) {
                        color_len = 4;
                    }
                    byte r = ShadowType.floatToByte(constant_color[0]);
                    byte g2 = ShadowType.floatToByte(constant_color[1]);
                    byte b = ShadowType.floatToByte(constant_color[2]);
                    int len = array.vertexCount * color_len;
                    byte[] colors = new byte[len];
                    boolean k = false;
                    if (color_len == 3) {
                        for (int i = 0; i < len; i += 3) {
                            colors[i] = r;
                            colors[i + 1] = g2;
                            colors[i + 2] = b;
                        }
                    } else {
                        byte a = ShadowType.floatToByte(af);
                        for (int i = 0; i < len; i += 4) {
                            colors[i] = r;
                            colors[i + 1] = g2;
                            colors[i + 2] = b;
                            colors[i + 3] = a;
                        }
                    }
                    array.colors = colors;
                }
            }
            GeometryArray geometry = this.display.makeGeometry(array);
            Appearance appearance = this.makeCachedAppearance(mode, c_alpha, c_color, geometry, false, true);
            Shape3D shape = new Shape3D((Geometry)geometry, appearance);
            shape.setCapability(12);
            shape.setCapability(14);
            ((Group)group).addChild((Node)shape);
            if (array instanceof VisADTriangleArray) {
                GeometryArray geometry2 = this.display.makeGeometry(array);
                Appearance appearance2 = this.makeCachedAppearance(mode, c_alpha, c_color, geometry2, false, false);
                PolygonAttributes pa = appearance2.getPolygonAttributes();
                pa.setPolygonMode(1);
                Shape3D shape2 = new Shape3D((Geometry)geometry2, appearance2);
                shape2.setCapability(12);
                shape2.setCapability(14);
                ((Group)group).addChild((Node)shape2);
            }
            return true;
        }
        return false;
    }

    public boolean allowConstantColorSurfaces() {
        return false;
    }

    public String toString() {
        return this.adaptedShadowType.toString();
    }
}

