/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.Data;
import visad.Field;
import visad.FieldImpl;
import visad.Function;
import visad.Real;
import visad.RealType;
import visad.TupleIface;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaVar;
import visad.formula.VMethod;
import visad.formula.VRealType;

public class FormulaUtil {
    private static int linkNum = 0;

    public static FormulaManager createStandardManager() {
        FormulaManager f;
        String[] binOps = new String[]{".", "^", "*", "/", "%", "+", "-"};
        int[] binPrec = new int[]{200, 400, 600, 600, 600, 800, 800};
        String[] binMethods = new String[]{"visad.formula.FormulaUtil.dot(visad.TupleIface, visad.Real)", "visad.Data.pow(visad.Data)", "visad.Data.multiply(visad.Data)", "visad.Data.divide(visad.Data)", "visad.Data.remainder(visad.Data)", "visad.Data.add(visad.Data)", "visad.Data.subtract(visad.Data)"};
        String[] unaryOps = new String[]{"-"};
        int[] unaryPrec = new int[]{500};
        String[] unaryMethods = new String[]{"visad.Data.negate()"};
        String[] functions = new String[]{"abs", "acos", "acosDegrees", "asin", "asinDegrees", "atan", "atan2", "atanDegrees", "atan2Degrees", "ceil", "combine", "cos", "cosDegrees", "derive", "domainMultiply", "domainFactor", "exp", "extract", "floor", "getSample", "linkx", "log", "max", "min", "negate", "rint", "round", "sin", "sinDegrees", "sqrt", "tan", "tanDegrees"};
        String[] funcMethods = new String[]{"visad.Data.abs()", "visad.Data.acos()", "visad.Data.acosDegrees()", "visad.Data.asin()", "visad.Data.asinDegrees()", "visad.Data.atan()", "visad.Data.atan2(visad.Data)", "visad.Data.atanDegrees()", "visad.Data.atan2Degrees(visad.Data)", "visad.Data.ceil()", "visad.FieldImpl.combine(visad.Field[])", "visad.Data.cos()", "visad.Data.cosDegrees()", "visad.formula.FormulaUtil.derive(visad.Function, visad.formula.VRealType)", "visad.FieldImpl.domainMultiply()", "visad.formula.FormulaUtil.factor(visad.FieldImpl, visad.formula.VRealType)", "visad.Data.exp()", "visad.formula.FormulaUtil.extract(visad.Field, visad.Real)", "visad.Data.floor()", "visad.formula.FormulaUtil.brackets(visad.Field, visad.Real)", "visad.formula.FormulaUtil.link(visad.formula.VMethod, java.lang.Object[])", "visad.Data.log()", "visad.Data.max(visad.Data)", "visad.Data.min(visad.Data)", "visad.Data.negate()", "visad.Data.rint()", "visad.Data.round()", "visad.Data.sin()", "visad.Data.sinDegrees()", "visad.Data.sqrt()", "visad.Data.tan()", "visad.Data.tanDegrees()"};
        int implicitPrec = 200;
        String[] implicitMethods = new String[]{"visad.formula.FormulaUtil.implicit(visad.Function, visad.Real)", "visad.Function.evaluate(visad.RealTuple)"};
        String preParseMethod = "visad.formula.FormulaUtil.preParse(java.lang.String, visad.formula.FormulaManager)";
        try {
            f = new FormulaManager(binOps, binPrec, binMethods, unaryOps, unaryPrec, unaryMethods, functions, funcMethods, implicitPrec, implicitMethods, preParseMethod);
        }
        catch (FormulaException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            return null;
        }
        return f;
    }

    public static Data dot(TupleIface t, Real r) {
        Data d;
        block4: {
            d = null;
            try {
                d = t.getComponent((int)r.getValue());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return d;
    }

    public static Data derive(Function f, VRealType rt) {
        Function val;
        block4: {
            val = null;
            try {
                val = f.derivative(rt.getRealType(), 202);
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return val;
    }

    public static Field factor(FieldImpl f, VRealType rt) {
        Field val;
        block4: {
            val = null;
            try {
                val = f.domainFactor(rt.getRealType());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return val;
    }

    public static Data extract(Field f, Real r) {
        Field d;
        block4: {
            d = null;
            try {
                d = f.extract((int)r.getValue());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return d;
    }

    public static Data link(VMethod m3, Object[] o) throws VisADException {
        Data ans = null;
        if (o != null) {
            for (int i = 0; i < o.length; ++i) {
                if (!(o[i] instanceof VRealType)) continue;
                o[i] = ((VRealType)o[i]).getRealType();
            }
        }
        try {
            ans = (Data)FormulaUtil.invokeMethod(m3.getMethod(), o);
        }
        catch (ClassCastException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            throw new VisADException("Link error: invalid linked method");
        }
        catch (IllegalAccessException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            throw new VisADException("Link error: cannot access linked method");
        }
        catch (IllegalArgumentException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            throw new VisADException("Link error: bad method argument");
        }
        catch (InvocationTargetException exc) {
            if (FormulaVar.DEBUG) {
                exc.getTargetException().printStackTrace();
            }
            throw new VisADException("Link error: linked method threw an exception");
        }
        if (ans == null) {
            throw new VisADException("Link error: linked method returned null data");
        }
        return ans;
    }

    public static Data implicit(Function f, Real r) {
        Data value;
        block4: {
            value = null;
            try {
                value = f.evaluate(r);
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return value;
    }

    public static Data brackets(Field f, Real r) {
        Data value;
        block4: {
            value = null;
            try {
                RealType rt = (RealType)r.getType();
                value = f.getSample((int)r.getValue());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return value;
    }

    public static String preParse(String f, FormulaManager fm) {
        String os;
        StringTokenizer t = new StringTokenizer(f, " ", false);
        String s2 = "";
        while (t.hasMoreTokens()) {
            s2 = s2 + t.nextToken();
        }
        if (s2.equals("")) {
            return s2;
        }
        while (!(s2 = FormulaUtil.preParseOnce(os = s2, fm)).equals(os)) {
        }
        return s2;
    }

    private static String preParseOnce(String s2, FormulaManager fm) {
        String l = s2.toLowerCase();
        int len = l.length();
        boolean letter = false;
        String ns = "";
        for (int i = 0; i < len; ++i) {
            int e2;
            char c;
            int paren;
            int s22;
            int e1;
            int s1;
            if (!letter && i < len - 1 && l.substring(i, i + 2).equals("d(")) {
                s1 = i += 2;
                int paren2 = 1;
                while (paren2 > 0) {
                    if (i >= len) {
                        return s2;
                    }
                    char c2 = l.charAt(i);
                    if (c2 == '(') {
                        ++paren2;
                    }
                    if (c2 == ')') {
                        --paren2;
                    }
                    ++i;
                }
                e1 = i - 1;
                if (i > len - 3 || !l.substring(i, i + 3).equals("/d(")) {
                    return s2;
                }
                s22 = i += 3;
                paren = 1;
                while (paren > 0) {
                    if (i >= len) {
                        return s2;
                    }
                    c = l.charAt(i);
                    if (c == '(') {
                        ++paren;
                    }
                    if (c == ')') {
                        --paren;
                    }
                    ++i;
                }
                e2 = i - 1;
                ns = ns + "derive(" + s2.substring(s1, e1) + "," + s2.substring(s22, e2) + ")";
                --i;
            } else if (!letter && i < len - 4 && l.substring(i, i + 5).equals("link(")) {
                String prestr;
                s1 = i += 5;
                try {
                    while (l.charAt(i) != '(') {
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    return s2;
                }
                e1 = ++i - 1;
                s22 = i;
                paren = 2;
                while (paren > 1) {
                    if (i >= len) {
                        return s2;
                    }
                    c = l.charAt(i);
                    if (c == '(') {
                        ++paren;
                    }
                    if (c == ')') {
                        --paren;
                    }
                    ++i;
                }
                e2 = i - 1;
                if (i >= len || l.charAt(i) != ')') {
                    return s2;
                }
                String str = prestr = s2.substring(s1, e1) + "(";
                String sub = s2.substring(s22, e2);
                StringTokenizer st = new StringTokenizer(sub, ",", false);
                boolean first = true;
                Vector<String> v = new Vector<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (first) {
                        first = false;
                    } else {
                        str = str + ",";
                    }
                    RealType rt = RealType.getRealTypeByName(token);
                    String sv = rt == null ? "visad.Data" : "visad.RealType";
                    v.add(sv);
                    str = str + sv;
                }
                Method[] meths = FormulaUtil.stringsToMethods(new String[]{str = str + ")"});
                if (meths[0] == null) {
                    int vlen = v.size();
                    Vector<String> vstrs = new Vector<String>();
                    for (int iv = 0; iv < vlen; ++iv) {
                        String sl;
                        String si = (String)v.elementAt(iv);
                        int lv = iv;
                        while (lv < vlen && (sl = (String)v.elementAt(lv++)).equals(si)) {
                            str = prestr;
                            first = true;
                            for (int j = 0; j < vlen; ++j) {
                                if (first) {
                                    first = false;
                                } else {
                                    str = str + ",";
                                }
                                String sj = (String)v.elementAt(j);
                                str = str + sj;
                                if (iv != j) continue;
                                str = str + "[]";
                                j = lv - 1;
                            }
                            str = str + ")";
                            vstrs.add(str);
                        }
                    }
                    String[] strlist = new String[vstrs.size()];
                    vstrs.toArray(strlist);
                    meths = FormulaUtil.stringsToMethods(strlist);
                    int found = -1;
                    for (int j = 0; j < meths.length && found < 0; ++j) {
                        if (meths[j] == null) continue;
                        found = j;
                    }
                    if (found >= 0) {
                        meths[0] = meths[found];
                    } else {
                        return s2;
                    }
                }
                String link = "link" + ++linkNum;
                try {
                    fm.setThing(link, new VMethod(meths[0]));
                }
                catch (FormulaException exc) {
                    return s2;
                }
                catch (VisADException exc) {
                    return s2;
                }
                catch (RemoteException exc) {
                    return s2;
                }
                ns = ns + "linkx(" + link + "," + s2.substring(s22, e2) + ")";
            } else if (!letter) {
                int j = i;
                char c3 = l.charAt(j++);
                while (j < len && (c3 >= 'a' && c3 <= 'z' || c3 >= '0' && c3 <= '9')) {
                    c3 = l.charAt(j++);
                }
                if (j == len) {
                    return ns + s2.substring(i, len);
                }
                if (c3 == '[') {
                    int k = j;
                    paren = 1;
                    while (paren > 0) {
                        if (k >= len) {
                            return s2;
                        }
                        c3 = l.charAt(k);
                        if (c3 == '[') {
                            ++paren;
                        }
                        if (c3 == ']') {
                            --paren;
                        }
                        ++k;
                    }
                    ns = ns + "getSample(" + s2.substring(i, j - 1) + "," + s2.substring(j, k - 1) + ")";
                    i = k - 1;
                } else {
                    ns = ns + s2.charAt(i);
                }
            } else {
                ns = ns + s2.charAt(i);
            }
            char c4 = i < len ? l.charAt(i) : (char)'\u0000';
            letter = c4 >= 'a' && c4 <= 'z';
        }
        return ns;
    }

    public static Method[] stringsToMethods(String[] strings) {
        int len = strings.length;
        Method[] methods = new Method[len];
        for (int j = 0; j < len; ++j) {
            StringTokenizer t = new StringTokenizer(strings[j], " ", false);
            String s2 = "";
            while (t.hasMoreTokens()) {
                s2 = s2 + t.nextToken();
            }
            t = new StringTokenizer(s2, "(", false);
            String pre = t.nextToken();
            String post = t.nextToken();
            t = new StringTokenizer(pre, ".", false);
            String c = t.nextToken();
            int count = t.countTokens();
            for (int i = 0; i < count - 1; ++i) {
                c = c + "." + t.nextToken();
            }
            String m3 = t.nextToken();
            t = new StringTokenizer(post, ",)", false);
            count = t.countTokens();
            String[] a = count == 0 ? null : new String[count];
            int x = 0;
            while (t.hasMoreTokens()) {
                a[x++] = t.nextToken();
            }
            Class<?> clas = null;
            try {
                clas = Class.forName(c);
            }
            catch (ClassNotFoundException exc) {
                if (FormulaVar.DEBUG) {
                    System.out.println("ERROR: Class " + c + " does not exist!");
                }
                methods[j] = null;
                continue;
            }
            Class[] param = a == null ? null : new Class[a.length];
            for (int i = 0; i < count; ++i) {
                if (a[i].endsWith("[]")) {
                    a[i] = "[L" + a[i].substring(0, a[i].length() - 2);
                    while (a[i].endsWith("[]")) {
                        a[i] = "[" + a[i].substring(0, a[i].length() - 2);
                    }
                    a[i] = a[i] + ";";
                }
                try {
                    param[i] = Class.forName(a[i]);
                    continue;
                }
                catch (ClassNotFoundException exc) {
                    if (FormulaVar.DEBUG) {
                        System.out.println("ERROR: Class " + a[i] + " (" + i + ") does not exist!");
                    }
                    methods[j] = null;
                }
            }
            Method method = null;
            try {
                method = clas.getMethod(m3, param);
            }
            catch (NoSuchMethodException exc) {
                if (FormulaVar.DEBUG) {
                    System.out.println("ERROR: Method " + m3 + " does not exist!");
                }
                methods[j] = null;
                continue;
            }
            methods[j] = method;
        }
        return methods;
    }

    public static Object invokeMethod(Method m3, Object[] o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] args;
        Object obj;
        Class<?>[] c = m3.getParameterTypes();
        int num = o == null ? 0 : o.length;
        int len = -1;
        int a = -1;
        if (c != null) {
            len = c.length;
            for (int i = 0; i < len; ++i) {
                if (!c[i].isArray()) continue;
                a = i;
            }
        }
        if (Modifier.isStatic(m3.getModifiers())) {
            obj = null;
            if (num > 0) {
                if (a < 0) {
                    args = new Object[num];
                    System.arraycopy(o, 0, args, 0, num);
                } else {
                    args = new Object[len];
                    if (a > 0) {
                        System.arraycopy(o, 0, args, 0, a);
                    }
                    Object array = Array.newInstance(c[a].getComponentType(), num - len + 1);
                    System.arraycopy(o, a, array, 0, num - len + 1);
                    args[a] = array;
                    if (a < len - 1) {
                        System.arraycopy(o, num - len + a + 1, args, a + 1, len - a - 1);
                    }
                }
            } else {
                args = null;
            }
        } else {
            if (num <= 0) {
                return null;
            }
            obj = o[0];
            if (num > 1) {
                if (a < 0) {
                    args = new Object[num - 1];
                    System.arraycopy(o, 1, args, 0, num - 1);
                } else {
                    args = new Object[len];
                    if (a > 0) {
                        System.arraycopy(o, 1, args, 0, a);
                    }
                    Object array = Array.newInstance(c[a].getComponentType(), num - len);
                    System.arraycopy(o, a + 1, array, 0, num - len);
                    args[a + 1] = array;
                    if (a < len - 1) {
                        System.arraycopy(o, num - len + a + 1, args, a + 1, len - a - 1);
                    }
                }
            } else {
                args = null;
            }
        }
        return m3.invoke(obj, args);
    }
}

