/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Thing;
import visad.ThingReference;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaUtil;
import visad.formula.FormulaVar;

public class FormulaManager {
    String[] bOps;
    int[] bPrec;
    Method[] bMethods;
    String[] uOps;
    int[] uPrec;
    Method[] uMethods;
    String[] funcs;
    Method[] fMethods;
    int iPrec;
    Method[] iMethods;
    Method ppMethod;
    private Vector Vars = new Vector();

    public FormulaManager(String[] binOps, int[] binPrec, String[] binMethods, String[] unaryOps, int[] unaryPrec, String[] unaryMethods, String[] functions, String[] funcMethods, int implicitPrec, String[] implicitMethods, String preParseMethod) throws FormulaException {
        int j;
        char c;
        int i;
        this.bOps = binOps;
        this.bPrec = binPrec;
        this.bMethods = FormulaUtil.stringsToMethods(binMethods);
        this.uOps = unaryOps;
        this.uPrec = unaryPrec;
        this.uMethods = FormulaUtil.stringsToMethods(unaryMethods);
        this.funcs = functions;
        this.fMethods = FormulaUtil.stringsToMethods(funcMethods);
        this.iPrec = implicitPrec;
        this.iMethods = FormulaUtil.stringsToMethods(implicitMethods);
        String[] s2 = new String[1];
        if (preParseMethod == null) {
            this.ppMethod = null;
        } else {
            String[] pps = new String[]{preParseMethod};
            Method[] ppm = FormulaUtil.stringsToMethods(pps);
            this.ppMethod = ppm[0];
        }
        int l1 = this.bOps.length;
        int l2 = this.bPrec.length;
        int l3 = this.bMethods.length;
        if (l1 != l2 || l1 != l3) {
            throw new FormulaException("Binary arrays must have equal lengths");
        }
        l1 = this.uOps.length;
        l2 = this.uPrec.length;
        l3 = this.uMethods.length;
        if (l1 != l2 || l1 != l3) {
            throw new FormulaException("Unary arrays must have equal lengths");
        }
        l1 = this.funcs.length;
        l2 = this.fMethods.length;
        if (l1 != l2) {
            throw new FormulaException("Function arrays must have equal lengths");
        }
        for (i = 0; i < this.bOps.length; ++i) {
            if (this.bOps[i].length() > 1) {
                throw new FormulaException("All operators must be one character in length");
            }
            c = this.bOps[i].charAt(0);
            if (c == '(' || c == ')' || c == ',' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                throw new FormulaException("The character \"" + c + "\" cannot be " + "used as an operator");
            }
            for (j = i + 1; j < this.bOps.length; ++j) {
                if (this.bOps[i].charAt(0) != this.bOps[j].charAt(0) || this.bPrec[i] == this.bPrec[j]) continue;
                throw new FormulaException("Duplicate operators must have equal operator precedences");
            }
        }
        for (i = 0; i < this.uOps.length; ++i) {
            if (this.uOps[i].length() > 1) {
                throw new FormulaException("All operators must be one character in length");
            }
            c = this.uOps[i].charAt(0);
            if (c == '(' || c == ')' || c == ',' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                throw new FormulaException("The character \"" + c + "\" cannot be " + "used as an operator");
            }
            for (j = i + 1; j < this.uOps.length; ++j) {
                if (this.uOps[i].charAt(0) != this.uOps[j].charAt(0) || this.uPrec[i] == this.uPrec[j]) continue;
                throw new FormulaException("Duplicate operators must have equal operator precedences");
            }
        }
        for (i = 0; i < functions.length; ++i) {
            c = functions[i].charAt(0);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            throw new FormulaException("All functions must begin with a letter");
        }
        for (i = 0; i < this.bMethods.length; ++i) {
            if (this.bMethods[i] != null) continue;
            throw new FormulaException("The method \"" + binMethods[i] + "\" is not valid");
        }
        for (i = 0; i < this.uMethods.length; ++i) {
            if (this.uMethods[i] != null) continue;
            throw new FormulaException("The method \"" + unaryMethods[i] + "\" is not valid");
        }
        for (i = 0; i < this.fMethods.length; ++i) {
            if (this.fMethods[i] != null) continue;
            throw new FormulaException("The method \"" + funcMethods[i] + "\" is not valid");
        }
        for (i = 0; i < this.iMethods.length; ++i) {
            if (this.iMethods[i] != null) continue;
            throw new FormulaException("The method \"" + implicitMethods[i] + "\" is not valid");
        }
    }

    public void createVar(String name, ThingReference tr) throws VisADException {
        FormulaVar v;
        try {
            v = this.getVarByName(name);
        }
        catch (FormulaException exc) {
            v = null;
        }
        if (v != null) {
            throw new FormulaException("The variable " + name + " already exists.");
        }
        this.Vars.add(new FormulaVar(name, this, tr));
    }

    public void assignFormula(String name, String formula) throws VisADException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setFormula(formula);
    }

    public void waitForFormula(String name) throws VisADException {
        FormulaVar v = this.getVarByName(name);
        v.waitForFormula();
    }

    public void setTextRef(String name, ThingReference textRef) throws VisADException, RemoteException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setTextRef(textRef);
    }

    public String[] getErrors(String name) {
        try {
            FormulaVar v = this.getVarByNameOrCreate(name);
            String[] s2 = v.getErrors();
            v.clearErrors();
            return s2;
        }
        catch (FormulaException exc) {
            return null;
        }
        catch (VisADException exc) {
            return null;
        }
    }

    public boolean canBeRemoved(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return !v.othersDepend();
    }

    public boolean exists(String name) {
        boolean exists = false;
        try {
            FormulaVar v = this.getVarByName(name);
            exists = true;
        }
        catch (FormulaException formulaException) {
            // empty catch block
        }
        return exists;
    }

    public void remove(String name) throws FormulaException {
        if (!this.canBeRemoved(name)) {
            throw new FormulaException("Cannot remove variable " + name + " " + "because other variables depend on it!");
        }
        this.Vars.remove(this.getVarByName(name));
    }

    public void setThing(String name, Thing t) throws VisADException, RemoteException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setThing(t);
    }

    public void setReference(String name, ThingReference tr) throws VisADException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setReference(tr);
    }

    public Thing getThing(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return v.getThing();
    }

    public ThingReference getReference(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return v.getReference();
    }

    public String getFormula(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return v.getFormula();
    }

    FormulaVar getVarByName(String name) throws FormulaException {
        for (int i = 0; i < this.Vars.size(); ++i) {
            FormulaVar v = (FormulaVar)this.Vars.elementAt(i);
            if (!v.name.equalsIgnoreCase(name)) continue;
            return v;
        }
        throw new FormulaException("The variable " + name + " does not exist.");
    }

    FormulaVar getVarByNameOrCreate(String name) throws VisADException {
        FormulaVar v;
        try {
            v = this.getVarByName(name);
        }
        catch (FormulaException exc) {
            v = new FormulaVar(name, this);
            this.Vars.add(v);
        }
        return v;
    }

    boolean isUnaryOp(String op) {
        for (int i = 0; i < this.uOps.length; ++i) {
            if (!this.uOps[i].equals(op)) continue;
            return true;
        }
        return false;
    }

    boolean isBinaryOp(String op) {
        for (int i = 0; i < this.bOps.length; ++i) {
            if (!this.bOps[i].equals(op)) continue;
            return true;
        }
        return false;
    }

    boolean isFunction(String token) {
        for (int i = 0; i < this.funcs.length; ++i) {
            if (!this.funcs[i].equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    int getUnaryPrec(String op) {
        for (int i = 0; i < this.uOps.length; ++i) {
            if (!this.uOps[i].equals(op)) continue;
            return this.uPrec[i];
        }
        return -1;
    }

    int getBinaryPrec(String op) {
        if (op.equals("(")) {
            return Integer.MAX_VALUE;
        }
        if (op.equals(",")) {
            return 0x7FFFFFFE;
        }
        for (int i = 0; i < this.bOps.length; ++i) {
            if (!this.bOps[i].equals(op)) continue;
            return this.bPrec[i];
        }
        return -1;
    }
}

