/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.Serializable;

public class DataRange
implements Serializable {
    public double min;
    public double max;

    public DataRange() {
        this.min = 0.0;
        this.max = 1.0;
    }

    public DataRange(double min2, double max) {
        this.min = min2;
        this.max = max;
    }

    public DataRange(double[] a) {
        this(a[0], a[1]);
    }

    public DataRange(DataRange r) {
        if (r != null) {
            this.min = r.min;
            this.max = r.max;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DataRange)) {
            return false;
        }
        DataRange other = (DataRange)o;
        return this.min == other.min && this.max == other.max;
    }

    public void set(double min2, double max) {
        this.min = min2;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double v) {
        this.min = v;
    }

    public void setMax(double v) {
        this.max = v;
    }

    public void setMin(int v) {
        this.min = v;
    }

    public void setMax(int v) {
        this.max = v;
    }

    public double[] asArray() {
        return new double[]{this.min, this.max};
    }

    public float[] asFloatArray() {
        return new float[]{(float)this.min, (float)this.max};
    }

    public double span() {
        return this.max - this.min;
    }

    public double getSpan() {
        return this.span();
    }

    public double getAbsSpan() {
        return Math.abs(this.span());
    }

    public double getMid() {
        return this.min + this.span() / 2.0;
    }

    public double getValueOfPercent(double percent) {
        return this.getMin() + this.getSpan() * percent;
    }

    public double getPercent(double v) {
        return (v - this.min) / this.span();
    }
}

