/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.ScalarMap;
import visad.VisADException;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientPartitionedFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.data.gif.GIFForm;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;

public class TestClusterOneJVM {
    public static void main(String[] args) throws RemoteException, VisADException {
        int i;
        int node_divide = 2;
        int number_of_nodes = node_divide * node_divide;
        if (args == null || args.length < 1) {
            System.out.println("usage: 'java visad.cluster.TestClusterOneJVM file.gif'");
            return;
        }
        GIFForm gif_form = new GIFForm();
        FlatField image = (FlatField)gif_form.open(args[0]);
        if (image == null) {
            System.out.println("cannot open " + args[0]);
            return;
        }
        FunctionType image_type = (FunctionType)image.getType();
        RealTupleType domain_type = image_type.getDomain();
        Linear2DSet domain_set = (Linear2DSet)image.getDomainSet();
        Linear1DSet x_set = domain_set.getX();
        Linear1DSet y_set = domain_set.getY();
        int x_len = x_set.getLength();
        int y_len = y_set.getLength();
        int len = domain_set.getLength();
        Linear2DSet ps = new Linear2DSet(domain_type, x_set.getFirst(), x_set.getLast(), node_divide, y_set.getFirst(), y_set.getLast(), node_divide, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
        RemoteClientPartitionedFieldImpl client_image = new RemoteClientPartitionedFieldImpl(image_type, domain_set);
        Linear2DSet[] subsets = new Linear2DSet[number_of_nodes];
        RemoteNodePartitionedFieldImpl[] node_images = new RemoteNodePartitionedFieldImpl[number_of_nodes];
        if (number_of_nodes == 1) {
            subsets[0] = domain_set;
            node_images[0] = new RemoteNodePartitionedFieldImpl(image);
        } else {
            int[] indices = new int[len];
            for (int i2 = 0; i2 < len; ++i2) {
                indices[i2] = i2;
            }
            float[][] values = domain_set.indexToValue(indices);
            int[] ps_indices = ps.valueToIndex(values);
            float[][] firsts = new float[2][number_of_nodes];
            float[][] lasts = new float[2][number_of_nodes];
            int[][] lows = new int[2][number_of_nodes];
            int[][] his = new int[2][number_of_nodes];
            for (int j = 0; j < 2; ++j) {
                for (int i3 = 0; i3 < number_of_nodes; ++i3) {
                    firsts[j][i3] = Float.MAX_VALUE;
                    lasts[j][i3] = -3.4028235E38f;
                    lows[j][i3] = len + 1;
                    his[j][i3] = -1;
                }
            }
            for (int i4 = 0; i4 < len; ++i4) {
                int k = ps_indices[i4];
                if (k < 0) continue;
                int[] index = new int[]{indices[i4] % x_len, indices[i4] / x_len};
                for (int j = 0; j < 2; ++j) {
                    if (values[j][i4] < firsts[j][k]) {
                        firsts[j][k] = values[j][i4];
                    }
                    if (values[j][i4] > lasts[j][k]) {
                        lasts[j][k] = values[j][i4];
                    }
                    if (index[j] < lows[j][k]) {
                        lows[j][k] = index[j];
                    }
                    if (index[j] <= his[j][k]) continue;
                    his[j][k] = index[j];
                }
            }
            for (int k = 0; k < number_of_nodes; ++k) {
                if (his[0][k] < 0 || his[1][k] < 0) {
                    throw new ClusterException("Set partition error");
                }
                subsets[k] = new Linear2DSet(domain_type, firsts[0][k], lasts[0][k], his[0][k] - lows[0][k] + 1, firsts[1][k], lasts[1][k], his[1][k] - lows[1][k] + 1, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
                FieldImpl subimage = (FieldImpl)image.resample(subsets[k]);
                node_images[k] = new RemoteNodePartitionedFieldImpl(subimage);
            }
        }
        RemoteClusterData[] table = new RemoteClusterData[number_of_nodes + 1];
        for (i = 0; i < number_of_nodes; ++i) {
            table[i] = node_images[i];
        }
        table[number_of_nodes] = client_image;
        for (i = 0; i < table.length; ++i) {
            table[i].setupClusterData(ps, table);
        }
        DisplayImplJ3D display = new DisplayImplJ3D("main_display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D(100000L));
        RealType line = (RealType)domain_type.getComponent(0);
        RealType element = (RealType)domain_type.getComponent(1);
        RealTupleType range_type = (RealTupleType)image_type.getRange();
        RealType red = (RealType)range_type.getComponent(0);
        display.addMap(new ScalarMap(line, Display.YAxis));
        display.addMap(new ScalarMap(element, Display.XAxis));
        display.addMap(new ScalarMap(red, Display.IsoContour));
        DataReferenceImpl ref = new DataReferenceImpl("image");
        RemoteDataReferenceImpl remote_ref = new RemoteDataReferenceImpl(ref);
        remote_ref.setData(client_image);
        RemoteDisplayImpl remote_display = new RemoteDisplayImpl(display);
        remote_display.addReference(remote_ref);
        JFrame frame = new JFrame("test ClientRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

