/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Arrays;
import java.util.List;
import visad.ContourStrip;
import visad.ContourStripSet;
import visad.Gridded3DSet;
import visad.QuickSort;
import visad.SetException;
import visad.TriangleStripBuilder;
import visad.VisADException;
import visad.util.Trace;

public class Contour2D {
    protected Contour2D con;
    protected int whichlabels = 0;
    protected boolean showgrid;
    protected int rows;
    protected int cols;
    protected int scale;
    protected int[] num1;
    protected int[] num2;
    protected int[] num3;
    protected int[] num4;
    protected float[][] vx1;
    protected float[][] vy1;
    public static final int DIFFICULTY_THRESHOLD = 600000;
    public static final float DIMENSION_THRESHOLD = 500000.0f;
    public static final byte SIDE_LEFT = 3;
    public static final byte SIDE_RIGHT = 1;
    public static final byte SIDE_TOP = 2;
    public static final byte SIDE_BOTTOM = 0;
    public static final byte SIDE_NONE = -1;
    public static final byte CLOCKWISE = -1;
    public static final byte CNTRCLOCKWISE = 1;
    public static int vertexCnt = 0;
    public static boolean TRUEVALUE = true;

    public static void contour(float[] g2, int nr, int nc, float interval, float lowlimit, float highlimit, float base, float[][] vx1, float[][] vy1, int[] numv1, byte[][] auxValues, boolean[] swap, boolean fill, float[][][] grd_normals, byte[][] interval_colors, float[][][][] lbl_vv, byte[][][][] lbl_cc, float[][][] lbl_loc, double[] scale, double scale_ratio, int label_freq, double label_size, boolean labelAlign, byte[] labelColor, Object labelFont, boolean sphericalDisplayCS, Gridded3DSet spatial_set) throws VisADException {
        boolean[] dashes = new boolean[]{false};
        float[] intervals = Contour2D.intervalToLevels(interval, lowlimit, highlimit, base, dashes);
        boolean dash = dashes[0];
        Contour2D.contour(g2, nr, nc, intervals, lowlimit, highlimit, base, dash, auxValues, swap, fill, grd_normals, interval_colors, scale, scale_ratio, label_freq, label_size, labelAlign, labelColor, labelFont, sphericalDisplayCS, spatial_set);
    }

    public static float[] intervalToLevels(float interval, float low, float high, float ba, boolean[] dash) throws VisADException {
        float[] levs = null;
        if ((double)interval == 0.0) {
            throw new VisADException("Contour interval cannot be zero");
        }
        dash[0] = false;
        if (interval < 0.0f) {
            dash[0] = true;
            interval = -interval;
        }
        long nlo = Math.round(Math.ceil((low - ba) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - ba) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return levs;
        }
        if (numc > 4000) {
            throw new VisADException("Contour interval " + interval + " too small for range " + low + "," + high);
        }
        try {
            levs = new float[numc];
        }
        catch (OutOfMemoryError e) {
            throw new VisADException("Contour interval too small");
        }
        for (int i = 0; i < numc; ++i) {
            levs[i] = ba + (float)(nlo + (long)i) * interval;
        }
        return levs;
    }

    public static ContourOutput contour(float[] g2, int nr, int nc, float[] values, float lowlimit, float highlimit, float base, boolean dash, byte[][] auxValues, boolean[] swap, boolean fill, float[][][] grd_normals, byte[][] interval_colors, double[] scale, double scale_ratio, int label_freq, double label_size, boolean labelAlign, byte[] labelColor, Object labelFont, boolean sphericalDisplayCS, Gridded3DSet spatial_set) throws VisADException {
        int ir;
        int ic;
        int lc;
        int lr;
        dash = fill ? false : dash;
        double dest = Math.sqrt(spatial_set.getLength());
        int est = (int)(dest * Math.sqrt(dest));
        if (est < 1000) {
            est = 1000;
        }
        int maxsize = 4 * est + est;
        int interval_length = interval_colors.length > 0 ? interval_colors[0].length : 0;
        float[] vx = new float[maxsize];
        float[] vy = new float[maxsize];
        float maxValue = Float.NEGATIVE_INFINITY;
        float minValue = Float.POSITIVE_INFINITY;
        for (int i = 0; i < g2.length; ++i) {
            if (g2[i] > maxValue) {
                maxValue = g2[i];
            }
            if (!(g2[i] < minValue)) continue;
            minValue = g2[i];
        }
        float[] myvals = null;
        boolean debug = false;
        if (values != null && minValue < maxValue) {
            int i;
            myvals = (float[])values.clone();
            int[] indices = QuickSort.sort(myvals);
            byte[][] tmpColors = new byte[interval_colors.length][interval_length];
            for (int colorIdx = 0; colorIdx < interval_length; ++colorIdx) {
                for (int rgbIdx = 0; rgbIdx < interval_colors.length; ++rgbIdx) {
                    tmpColors[rgbIdx][indices[colorIdx]] = interval_colors[rgbIdx][colorIdx];
                }
            }
            interval_colors = tmpColors;
            int minIdx = 0;
            int maxIdx = myvals.length - 1;
            int i2 = 0;
            while (i2 < myvals.length && !(minValue <= myvals[i2])) {
                minIdx = i2++;
            }
            i2 = myvals.length - 1;
            while (i2 >= 0 && !(maxValue >= myvals[i2])) {
                maxIdx = i2--;
            }
            int newSize = maxIdx - minIdx + 1;
            int newIdx = 0;
            if (debug) {
                System.err.println("min: " + minValue + " max:" + maxValue + " idx:" + minIdx + "-" + maxIdx + " new size:" + newSize);
                System.err.print("original values: ");
                for (int i3 = 0; i3 < myvals.length; ++i3) {
                    System.err.print(myvals[i3] + ",");
                }
                System.err.println("");
            }
            float[] tmpValues = new float[newSize];
            tmpColors = new byte[interval_colors.length][newSize];
            for (i = minIdx; i <= maxIdx; ++i) {
                for (int rgbIdx = 0; rgbIdx < interval_colors.length; ++rgbIdx) {
                    tmpColors[rgbIdx][newIdx] = interval_colors[rgbIdx][i];
                }
                tmpValues[newIdx] = myvals[i];
                ++newIdx;
            }
            if (debug) {
                System.err.print("new values: ");
                for (i = 0; i < tmpValues.length; ++i) {
                    System.err.print(tmpValues[i] + ",");
                }
                System.err.println("");
            }
            myvals = tmpValues;
            interval_colors = tmpColors;
        }
        byte[][] auxLevels = null;
        int naux = auxValues != null ? auxValues.length : 0;
        byte[] auxa = null;
        byte[] auxb = null;
        byte[] auxc = null;
        byte[] auxd = null;
        if (naux > 0) {
            for (int i = 0; i < naux; ++i) {
                if (auxValues[i].length == g2.length) continue;
                throw new SetException("Contour2D.contour: auxValues lengths don't match");
            }
            auxa = new byte[naux];
            auxb = new byte[naux];
            auxc = new byte[naux];
            auxd = new byte[naux];
            auxLevels = new byte[naux][maxsize];
        }
        if (values == null) {
            return null;
        }
        if (myvals == null || myvals.length == 0) {
            return null;
        }
        boolean[] dashFlags = new boolean[myvals.length];
        int numLevels = myvals.length;
        float minLevelValue = myvals[0];
        float maxLevelValue = myvals[numLevels - 1];
        int nrm = nr - 1;
        int ncm = nc - 1;
        float xdd = ((float)(nr - 1) - 0.0f) / ((float)nr - 1.0f);
        float ydd = ((float)(nc - 1) - 0.0f) / ((float)nc - 1.0f);
        float xd = xdd - 2.0E-5f;
        float yd = ydd - 2.0E-5f;
        if (swap[0]) {
            lr = 1 + (nr - 2) / 10;
            lc = 1 + (nc - 2) / 50;
        } else {
            lr = 1 + (nr - 2) / 50;
            lc = 1 + (nc - 2) / 10;
        }
        int lc2 = lc / 2;
        int lr2 = lr / 2;
        int lrr = 1 + (nr - 2) / 8;
        int lcc = 1 + (nc - 2) / 8;
        char[] mark = new char[nr * nc];
        float max_g = -3.4028235E38f;
        float min_g = Float.MAX_VALUE;
        for (ic = 0; ic < nc; ++ic) {
            for (ir = 0; ir < lr; ++ir) {
                mark[ic * nr + ir] = '\u0001';
                mark[ic * nr + (nr - ir - 2)] = '\u0001';
                float val = g2[ic * nr + ir];
                if (val > max_g) {
                    max_g = val;
                }
                if (!(val < min_g)) continue;
                min_g = val;
            }
        }
        for (ir = 0; ir < nr; ++ir) {
            for (ic = 0; ic < lc; ++ic) {
                mark[ic * nr + ir] = '\u0001';
                mark[(nc - ic - 2) * nr + ir] = '\u0001';
            }
        }
        int numv = 0;
        byte[][] color_bin = null;
        byte[][][] o_flags = null;
        short[][] n_lines = null;
        short[][] ctrLow = null;
        if (fill) {
            color_bin = interval_colors;
            o_flags = new byte[nrm][ncm][];
            n_lines = new short[nrm][ncm];
            ctrLow = new short[nrm][ncm];
        }
        ContourStripSet ctrSet = new ContourStripSet(myvals, swap, scale_ratio, label_freq, label_size, nr, nc, spatial_set);
        Trace.call1("Contour2d.loop", " nrm=" + nrm + " ncm=" + ncm + " naux=" + naux + " myvals.length=" + myvals.length);
        for (ic = 0; ic < ncm; ++ic) {
            int ic_plus1 = ic + 1;
            float yy = ydd * (float)ic + 0.0f;
            block24: for (ir = 0; ir < nrm; ++ir) {
                int numc;
                float gd;
                float gc;
                float gb;
                float ga;
                int i;
                byte[][] ta;
                float[] ty;
                int ir_plus1 = ir + 1;
                float xx = xdd * (float)ir + 0.0f;
                int ic_times_nr = ic * nr;
                int ic_plus1_times_nr = ic_plus1 * nr;
                if (numv + 8 >= maxsize) {
                    maxsize = 2 * maxsize;
                    float[] tx = vx;
                    ty = vy;
                    vx = new float[maxsize];
                    vy = new float[maxsize];
                    System.arraycopy(tx, 0, vx, 0, numv);
                    System.arraycopy(ty, 0, vy, 0, numv);
                    tx = null;
                    ty = null;
                    if (naux > 0) {
                        ta = auxLevels;
                        auxLevels = new byte[naux][maxsize];
                        for (i = 0; i < naux; ++i) {
                            System.arraycopy(ta[i], 0, auxLevels[i], 0, numv);
                        }
                        ta = null;
                    }
                }
                if (Float.isNaN(ga = g2[ic_times_nr + ir]) || Float.isNaN(gb = g2[ic_times_nr + ir_plus1]) || Float.isNaN(gc = g2[ic_plus1_times_nr + ir]) || Float.isNaN(gd = g2[ic_plus1_times_nr + ir_plus1])) continue;
                if (naux > 0) {
                    for (int i4 = 0; i4 < naux; ++i4) {
                        byte[] auxValues_i = auxValues[i4];
                        auxa[i4] = auxValues_i[ic_times_nr + ir];
                        auxb[i4] = auxValues_i[ic_times_nr + ir_plus1];
                        auxc[i4] = auxValues_i[ic_plus1_times_nr + ir];
                        auxd[i4] = auxValues_i[ic_plus1_times_nr + ir_plus1];
                    }
                }
                float gAvg = (ga + gb + gc + gd) / 4.0f;
                float tmp1 = ga < gb ? ga : gb;
                float tmp2 = gc < gd ? gc : gd;
                float gMin = tmp1 < tmp2 ? tmp1 : tmp2;
                tmp1 = ga > gb ? ga : gb;
                tmp2 = gc > gd ? gc : gd;
                float gMax = tmp1 > tmp2 ? tmp1 : tmp2;
                int low = 0;
                int hi = numLevels - 1;
                if (gMax < minLevelValue || gMin > maxLevelValue) {
                    numc = 1;
                } else {
                    hi = Arrays.binarySearch(myvals, gMax);
                    if (hi < 0) {
                        hi = -hi - 1;
                    }
                    if (hi >= myvals.length) {
                        hi = myvals.length - 1;
                    }
                    if ((low = Arrays.binarySearch(myvals, gMin)) < 0) {
                        low = -low - 1;
                    }
                    numc = hi - low + 1;
                }
                if (fill) {
                    o_flags[ir][ic] = new byte[2 * numc];
                    n_lines[ir][ic] = 0;
                    ctrLow[ir][ic] = (short)hi;
                }
                for (int il = 0; il < numc; ++il) {
                    if (low + il >= myvals.length) {
                        System.err.println("bad range: myvals.length=" + myvals + " il=" + il + " low=" + low + " high=" + hi);
                    }
                    float gg = myvals[low + il];
                    if (numv + 8 >= maxsize) {
                        maxsize = 2 * maxsize;
                        float[] tx = vx;
                        ty = vy;
                        vx = new float[maxsize];
                        vy = new float[maxsize];
                        System.arraycopy(tx, 0, vx, 0, numv);
                        System.arraycopy(ty, 0, vy, 0, numv);
                        tx = null;
                        ty = null;
                        if (naux > 0) {
                            ta = auxLevels;
                            auxLevels = new byte[naux][maxsize];
                            for (i = 0; i < naux; ++i) {
                                System.arraycopy(ta[i], 0, auxLevels[i], 0, numv);
                            }
                            ta = null;
                        }
                    }
                    if (gg < gMin) continue;
                    if (gg > gMax) continue block24;
                    if (gg < lowlimit) continue;
                    if (gg > highlimit) continue block24;
                    int ii = 0;
                    if (gg > ga) {
                        ii = 1;
                    }
                    if (gg > gb) {
                        ii += 2;
                    }
                    if (gg > gc) {
                        ii += 4;
                    }
                    if (gg > gd) {
                        ii += 8;
                    }
                    if (ii > 7) {
                        ii = 15 - ii;
                    }
                    if (ii <= 0) continue;
                    if (fill && low + il < ctrLow[ir][ic]) {
                        ctrLow[ir][ic] = (short)(low + il);
                    }
                    if (mark[ic * nr + ir] == '\u0000') {
                        int jr;
                        int jc;
                        int kc = ic - lc2 - lcc;
                        int kr = ir - lr2 - lrr;
                        int mc = kc + 2 * lcc + lc - 1;
                        int mr = kr + 2 * lrr + lr - 1;
                        for (jc = kc; jc <= mc; ++jc) {
                            if (jc < 0 || jc >= nc) continue;
                            for (jr = kr; jr <= mr; ++jr) {
                                if (jr < 0 || jr >= nr || mark[jc * nr + jr] == '\u0002') continue;
                                mark[jc * nr + jr] = '\u0001';
                            }
                        }
                        kc = ic - lc2;
                        kr = ir - lr2;
                        mc = kc + lc - 1;
                        mr = kr + lr - 1;
                        for (jc = kc; jc <= mc; ++jc) {
                            if (jc < 0 || jc >= nc) continue;
                            for (jr = kr; jr <= mr; ++jr) {
                                if (jr < 0 || jr >= nr) continue;
                                mark[jc * nr + jr] = 2;
                            }
                        }
                    }
                    switch (ii) {
                        case 1: {
                            int t;
                            float gba = gb - ga;
                            float gca = gc - ga;
                            if (naux > 0) {
                                float ratioba = (gg - ga) / gba;
                                float ratioca = (gg - ga) / gca;
                                for (int i5 = 0; i5 < naux; ++i5) {
                                    t = (int)((1.0f - ratioba) * (auxa[i5] < 0 ? (float)auxa[i5] + 256.0f : (float)auxa[i5]) + ratioba * (auxb[i5] < 0 ? (float)auxb[i5] + 256.0f : (float)auxb[i5]));
                                    auxLevels[i5][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    t = (int)((1.0f - ratioca) * (auxa[i5] < 0 ? (float)auxa[i5] + 256.0f : (float)auxa[i5]) + ratioca * (auxc[i5] < 0 ? (float)auxc[i5] + 256.0f : (float)auxc[i5]));
                                    auxLevels[i5][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                            vy[numv] = yy;
                            vy[++numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                            vx[numv] = xx;
                            ++numv;
                            if (fill) {
                                o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                short[] sArray = n_lines[ir];
                                int n = ic;
                                sArray[n] = (short)(sArray[n] + 1);
                            }
                            if (vx[numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                            int n = numv - 2;
                            vx[n] = vx[n] + 1.0E-5f;
                            int n2 = numv - 1;
                            vy[n2] = vy[n2] + 1.0E-5f;
                            break;
                        }
                        case 2: {
                            int t;
                            float gba = gb - ga;
                            float gdb = gd - gb;
                            if (naux > 0) {
                                float ratioba = (gg - ga) / gba;
                                float ratiodb = (gg - gb) / gdb;
                                for (int i6 = 0; i6 < naux; ++i6) {
                                    t = (int)((1.0f - ratioba) * (auxa[i6] < 0 ? (float)auxa[i6] + 256.0f : (float)auxa[i6]) + ratioba * (auxb[i6] < 0 ? (float)auxb[i6] + 256.0f : (float)auxb[i6]));
                                    auxLevels[i6][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    t = (int)((1.0f - ratiodb) * (auxb[i6] < 0 ? (float)auxb[i6] + 256.0f : (float)auxb[i6]) + ratiodb * (auxd[i6] < 0 ? (float)auxd[i6] + 256.0f : (float)auxd[i6]));
                                    auxLevels[i6][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                            vy[numv] = yy;
                            vy[++numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                            vx[numv] = xx + xd;
                            ++numv;
                            if (fill) {
                                o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                short[] sArray = n_lines[ir];
                                int n = ic;
                                sArray[n] = (short)(sArray[n] + 1);
                            }
                            if (vx[numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                            int n = numv - 2;
                            vx[n] = vx[n] - 1.0E-5f;
                            int n3 = numv - 1;
                            vy[n3] = vy[n3] + 1.0E-5f;
                            break;
                        }
                        case 3: {
                            int t;
                            float gca = gc - ga;
                            float gdb = gd - gb;
                            if (naux > 0) {
                                float ratioca = (gg - ga) / gca;
                                float ratiodb = (gg - gb) / gdb;
                                for (int i7 = 0; i7 < naux; ++i7) {
                                    t = (int)((1.0f - ratioca) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioca * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]));
                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    t = (int)((1.0f - ratiodb) * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]) + ratiodb * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                            vx[numv] = xx;
                            vy[++numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                            vx[numv] = xx + xd;
                            ++numv;
                            if (!fill) break;
                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                            short[] sArray = n_lines[ir];
                            int n = ic;
                            sArray[n] = (short)(sArray[n] + 1);
                            break;
                        }
                        case 4: {
                            int t;
                            float gca = gc - ga;
                            float gdc = gd - gc;
                            if (naux > 0) {
                                float ratioca = (gg - ga) / gca;
                                float ratiodc = (gg - gc) / gdc;
                                for (int i8 = 0; i8 < naux; ++i8) {
                                    t = (int)((1.0f - ratioca) * (auxa[i8] < 0 ? (float)auxa[i8] + 256.0f : (float)auxa[i8]) + ratioca * (auxc[i8] < 0 ? (float)auxc[i8] + 256.0f : (float)auxc[i8]));
                                    auxLevels[i8][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    t = (int)((1.0f - ratiodc) * (auxc[i8] < 0 ? (float)auxc[i8] + 256.0f : (float)auxc[i8]) + ratiodc * (auxd[i8] < 0 ? (float)auxd[i8] + 256.0f : (float)auxd[i8]));
                                    auxLevels[i8][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                            vx[numv] = xx;
                            vx[++numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                            vy[numv] = yy + yd;
                            ++numv;
                            if (fill) {
                                o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                short[] sArray = n_lines[ir];
                                int n = ic;
                                sArray[n] = (short)(sArray[n] + 1);
                            }
                            if (vx[numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                            int n = numv - 1;
                            vx[n] = vx[n] + 1.0E-5f;
                            int n4 = numv - 2;
                            vy[n4] = vy[n4] - 1.0E-5f;
                            break;
                        }
                        case 5: {
                            int t;
                            float gba = gb - ga;
                            float gdc = gd - gc;
                            if (naux > 0) {
                                float ratioba = (gg - ga) / gba;
                                float ratiodc = (gg - gc) / gdc;
                                for (int i9 = 0; i9 < naux; ++i9) {
                                    t = (int)((1.0f - ratioba) * (auxa[i9] < 0 ? (float)auxa[i9] + 256.0f : (float)auxa[i9]) + ratioba * (auxb[i9] < 0 ? (float)auxb[i9] + 256.0f : (float)auxb[i9]));
                                    auxLevels[i9][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    t = (int)((1.0f - ratiodc) * (auxc[i9] < 0 ? (float)auxc[i9] + 256.0f : (float)auxc[i9]) + ratiodc * (auxd[i9] < 0 ? (float)auxd[i9] + 256.0f : (float)auxd[i9]));
                                    auxLevels[i9][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                            vy[numv] = yy;
                            vx[++numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                            vy[numv] = yy + yd;
                            ++numv;
                            if (!fill) break;
                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                            short[] sArray = n_lines[ir];
                            int n = ic;
                            sArray[n] = (short)(sArray[n] + 1);
                            break;
                        }
                        case 6: {
                            int t;
                            float gba = gb - ga;
                            float gdc = gd - gc;
                            float gca = gc - ga;
                            float gdb = gd - gb;
                            if (naux > 0) {
                                float ratioba = (gg - ga) / gba;
                                float ratiodc = (gg - gc) / gdc;
                                float ratioca = (gg - ga) / gca;
                                float ratiodb = (gg - gb) / gdb;
                                for (int i10 = 0; i10 < naux; ++i10) {
                                    t = (int)((1.0f - ratioba) * (auxa[i10] < 0 ? (float)auxa[i10] + 256.0f : (float)auxa[i10]) + ratioba * (auxb[i10] < 0 ? (float)auxb[i10] + 256.0f : (float)auxb[i10]));
                                    auxLevels[i10][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    if (gg > gAvg ^ ga < gb) {
                                        t = (int)((1.0f - ratioca) * (auxa[i10] < 0 ? (float)auxa[i10] + 256.0f : (float)auxa[i10]) + ratioca * (auxc[i10] < 0 ? (float)auxc[i10] + 256.0f : (float)auxc[i10]));
                                        auxLevels[i10][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                        t = (int)((1.0f - ratiodb) * (auxb[i10] < 0 ? (float)auxb[i10] + 256.0f : (float)auxb[i10]) + ratiodb * (auxd[i10] < 0 ? (float)auxd[i10] + 256.0f : (float)auxd[i10]));
                                        auxLevels[i10][numv + 2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    } else {
                                        t = (int)((1.0f - ratiodb) * (auxb[i10] < 0 ? (float)auxb[i10] + 256.0f : (float)auxb[i10]) + ratiodb * (auxd[i10] < 0 ? (float)auxd[i10] + 256.0f : (float)auxd[i10]));
                                        auxLevels[i10][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                        t = (int)((1.0f - ratioca) * (auxa[i10] < 0 ? (float)auxa[i10] + 256.0f : (float)auxa[i10]) + ratioca * (auxc[i10] < 0 ? (float)auxc[i10] + 256.0f : (float)auxc[i10]));
                                        auxLevels[i10][numv + 2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    t = (int)((1.0f - ratiodc) * (auxc[i10] < 0 ? (float)auxc[i10] + 256.0f : (float)auxc[i10]) + ratiodc * (auxd[i10] < 0 ? (float)auxd[i10] + 256.0f : (float)auxd[i10]));
                                    auxLevels[i10][numv + 3] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                            vy[numv] = yy;
                            ++numv;
                            if (gg > gAvg ^ ga < gb) {
                                vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                vx[numv] = xx;
                                ++numv;
                                if (fill) {
                                    o_flags[ir][ic][n_lines[ir][ic]] = 33;
                                    short[] sArray = n_lines[ir];
                                    int n = ic;
                                    sArray[n] = (short)(sArray[n] + 1);
                                }
                                vy[numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                vx[numv] = xx + xd;
                                if (fill) {
                                    o_flags[ir][ic][n_lines[ir][ic]] = 39;
                                    short[] sArray = n_lines[ir];
                                    int n = ic;
                                    sArray[n] = (short)(sArray[n] + 1);
                                }
                                ++numv;
                            } else {
                                vy[numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                vx[numv] = xx + xd;
                                ++numv;
                                if (fill) {
                                    o_flags[ir][ic][n_lines[ir][ic]] = 34;
                                    short[] sArray = n_lines[ir];
                                    int n = ic;
                                    sArray[n] = (short)(sArray[n] + 1);
                                }
                                vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                vx[numv] = xx;
                                ++numv;
                                if (fill) {
                                    o_flags[ir][ic][n_lines[ir][ic]] = 36;
                                    short[] sArray = n_lines[ir];
                                    int n = ic;
                                    sArray[n] = (short)(sArray[n] + 1);
                                }
                            }
                            vx[numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                            vy[numv] = yy + yd;
                            ++numv;
                            break;
                        }
                        case 7: {
                            int t;
                            float gdb = gd - gb;
                            float gdc = gd - gc;
                            if (naux > 0) {
                                float ratiodb = (gg - gb) / gdb;
                                float ratiodc = (gg - gc) / gdc;
                                for (int i11 = 0; i11 < naux; ++i11) {
                                    t = (int)((1.0f - ratiodb) * (auxb[i11] < 0 ? (float)auxb[i11] + 256.0f : (float)auxb[i11]) + ratiodb * (auxd[i11] < 0 ? (float)auxd[i11] + 256.0f : (float)auxd[i11]));
                                    auxLevels[i11][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    t = (int)((1.0f - ratiodc) * (auxc[i11] < 0 ? (float)auxc[i11] + 256.0f : (float)auxc[i11]) + ratiodc * (auxd[i11] < 0 ? (float)auxd[i11] + 256.0f : (float)auxd[i11]));
                                    auxLevels[i11][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                            }
                            vy[numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                            vx[numv] = xx + xd;
                            vx[++numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                            vy[numv] = yy + yd;
                            ++numv;
                            if (fill) {
                                o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                short[] sArray = n_lines[ir];
                                int n = ic;
                                sArray[n] = (short)(sArray[n] + 1);
                            }
                            if (vx[numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                            int n = numv - 1;
                            vx[n] = vx[n] - 1.0E-5f;
                            int n5 = numv - 2;
                            vy[n5] = vy[n5] - 1.0E-5f;
                        }
                    }
                    if (gg < base && dash) {
                        dashFlags[low + il] = true;
                    }
                    if (ii == 6) {
                        ctrSet.add(vx, vy, numv - 4, numv - 3, low + il);
                        ctrSet.add(vx, vy, numv - 2, numv - 1, low + il);
                        continue;
                    }
                    ctrSet.add(vx, vy, numv - 2, numv - 1, low + il);
                }
            }
        }
        Trace.call2("Contour2d.loop");
        TriangleStripBuilder triStripBldr = null;
        if (fill) {
            triStripBldr = new TriangleStripBuilder(ncm, nrm, color_bin.length);
            Contour2D.fillGridBox(g2, n_lines, vx, vy, xd, xdd, yd, ydd, nr, nrm, nc, ncm, ctrLow, o_flags, myvals, color_bin, grd_normals, triStripBldr);
        }
        Trace.call1("Contour2d.getLineColorArrays");
        ctrSet.getLineColorArrays(vx, vy, auxLevels, labelColor, labelFont, labelAlign, sphericalDisplayCS, dashFlags);
        Trace.call2("Contour2d.getLineColorArrays");
        return new ContourOutput(ctrSet, triStripBldr);
    }

    private static void fillGridBox(float[] g2, short[][] n_lines, float[] vx, float[] vy, float xd, float xdd, float yd, float ydd, int nr, int nrm, int nc, int ncm, short[][] ctrLow, byte[][][] o_flags, float[] values, byte[][] color_bin, float[][][] grd_normals, TriangleStripBuilder triStripBldr) {
        int[] numv = new int[]{0};
        for (int ic = 0; ic < ncm; ++ic) {
            float yy = ydd * (float)ic + 0.0f;
            for (int ir = 0; ir < nrm; ++ir) {
                float gd;
                float gc;
                float gb;
                triStripBldr.setGridBox(ic, ir);
                float xx = xdd * (float)ir + 0.0f;
                float ga = g2[ic * nr + ir];
                if (Float.isNaN(ga) || Float.isNaN(gb = g2[ic * nr + (ir + 1)]) || Float.isNaN(gc = g2[(ic + 1) * nr + ir]) || Float.isNaN(gd = g2[(ic + 1) * nr + (ir + 1)])) continue;
                numv[0] = numv[0] + n_lines[ir][ic] * 2;
                Contour2D.fillGridBox(new float[]{ga, gb, gc, gd}, n_lines[ir][ic], vx, vy, xx, yy, xd, yd, ic, ir, ctrLow[ir][ic], numv[0], o_flags[ir][ic], values, color_bin, grd_normals, triStripBldr);
            }
        }
    }

    private static void fillGridBox(float[] corners, int numc, float[] vx, float[] vy, float xx, float yy, float xd, float yd, int nc, int nr, short ctrLow, int numv, byte[] o_flags, float[] values, byte[][] color_bin, float[][][] grd_normals, TriangleStripBuilder triStripBldr) {
        int flag;
        int il = 0;
        int color_length = color_bin.length;
        float[] vv1 = new float[2];
        float[] vv2 = new float[2];
        float[] vv1_last = new float[2];
        float[] vv2_last = new float[2];
        float[][] vv = new float[2][2];
        float[][] vv_last = new float[2][2];
        int dir = 1;
        int start = numv - 2;
        int o_start = numc - 1;
        int o_idx = 0;
        byte o_flag = o_flags[o_idx];
        int[] closed = new int[]{0};
        int v_idx = start + dir * il * 2;
        int cc_start = dir > 0 ? ctrLow - 1 : ctrLow + (numc - 1);
        byte[][] crnr_color = new byte[4][color_length];
        int[] crnrLevelIdx = new int[4];
        boolean[] crnr_out = new boolean[]{true, true, true, true};
        boolean all_out = true;
        for (int tt = 0; tt < corners.length; ++tt) {
            int cc = 0;
            int kk = 0;
            for (kk = 0; kk < values.length - 1; ++kk) {
                if (!(corners[tt] >= values[kk]) || !(corners[tt] < values[kk + 1])) continue;
                cc = kk;
                all_out = false;
                crnr_out[tt] = false;
            }
            for (int ii = 0; ii < color_length; ++ii) {
                crnr_color[tt][ii] = color_bin[ii][cc];
            }
            crnrLevelIdx[tt] = cc;
        }
        dir = 1;
        start = numv - numc * 2;
        o_start = 0;
        v_idx = start + dir * il * 2;
        boolean up = false;
        boolean right = false;
        float[] x_avg = new float[2];
        float[] y_avg = new float[2];
        if (numc > 1) {
            int idx = v_idx;
            x_avg[0] = (vx[idx] + vx[idx + 1]) / 2.0f;
            y_avg[0] = (vy[idx] + vy[idx + 1]) / 2.0f;
            idx = v_idx + 2;
            x_avg[1] = (vx[idx] + vx[idx + 1]) / 2.0f;
            y_avg[1] = (vy[idx] + vy[idx + 1]) / 2.0f;
            if (x_avg[1] - x_avg[0] > 0.0f) {
                up = true;
            }
            if (y_avg[1] - y_avg[0] > 0.0f) {
                right = true;
            }
        } else if (numc == 1) {
            x_avg[0] = 0.0f;
            y_avg[0] = 0.0f;
            x_avg[1] = 1.0f;
            y_avg[1] = 1.0f;
        } else if (numc == 0) {
            if (all_out) {
                return;
            }
            float[][] tri = new float[2][4];
            float[][] normals = new float[3][4];
            byte[] color = new byte[color_length];
            for (int ii = 0; ii < color_length; ++ii) {
                color[ii] = crnr_color[0][ii];
            }
            normals[0][0] = grd_normals[nc][nr][0];
            normals[1][0] = grd_normals[nc][nr][1];
            normals[2][0] = grd_normals[nc][nr][2];
            tri[0][0] = xx;
            tri[1][0] = yy;
            normals[0][1] = grd_normals[nc + 1][nr][0];
            normals[1][1] = grd_normals[nc + 1][nr][1];
            normals[2][1] = grd_normals[nc + 1][nr][2];
            tri[0][1] = xx;
            tri[1][1] = yy + yd;
            normals[0][2] = grd_normals[nc][nr + 1][0];
            normals[1][2] = grd_normals[nc][nr + 1][1];
            normals[2][2] = grd_normals[nc][nr + 1][2];
            tri[0][2] = xx + xd;
            tri[1][2] = yy;
            normals[0][3] = grd_normals[nc + 1][nr + 1][0];
            normals[1][3] = grd_normals[nc + 1][nr + 1][1];
            normals[2][3] = grd_normals[nc + 1][nr + 1][2];
            tri[0][3] = xx + xd;
            tri[1][3] = yy + yd;
            byte first_tri_orient = -1;
            byte last_tri_orient = 1;
            byte first_strp_side = 3;
            byte last_strp_side = 1;
            triStripBldr.addVerticies(crnrLevelIdx[0], tri, normals, color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
            return;
        }
        for (int iii = 0; iii < o_flags.length; ++iii) {
            if (o_flags[iii] <= 32) continue;
            Contour2D.fillCaseSix(xx, yy, xd, yd, v_idx, dir, o_flags, ctrLow, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, color_bin, color_length, grd_normals, closed, triStripBldr);
            return;
        }
        if (o_flag == 1 || o_flag == 4 || o_flag == 2 || o_flag == 7) {
            boolean opp = false;
            float dy = 0.0f;
            float dx = 0.0f;
            float dist_0 = 0.0f;
            float dist_1 = 0.0f;
            if (o_flag == 1) {
                dy = y_avg[1] - yy;
                dx = x_avg[1] - xx;
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - yy;
                dx = x_avg[0] - xx;
                dist_0 = dy * dy + dx * dx;
            }
            if (o_flag == 2) {
                dy = y_avg[1] - yy;
                dx = x_avg[1] - (xx + xd);
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - yy;
                dx = x_avg[0] - (xx + xd);
                dist_0 = dy * dy + dx * dx;
            }
            if (o_flag == 4) {
                dy = y_avg[1] - (yy + yd);
                dx = x_avg[1] - xx;
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - (yy + yd);
                dx = x_avg[0] - xx;
                dist_0 = dy * dy + dx * dx;
            }
            if (o_flag == 7) {
                dy = y_avg[1] - (yy + yd);
                dx = x_avg[1] - (xx + xd);
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - (yy + yd);
                dx = x_avg[0] - (xx + xd);
                dist_0 = dy * dy + dx * dx;
            }
            if (dist_1 < dist_0) {
                opp = true;
            }
            if (opp) {
                Contour2D.fillToOppCorner(xx, yy, xd, yd, v_idx, o_flag, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
            } else {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, v_idx, o_flag, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
            }
        } else if (o_flags[o_idx] == 3) {
            flag = 1;
            if (right) {
                flag = -1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, o_flag, flag, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
        } else if (o_flags[o_idx] == 5) {
            flag = 1;
            if (!up) {
                flag = -1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, o_flag, flag, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
        }
        byte last_o = o_flags[o_idx];
        ++il;
        for (il = 1; il < numc; ++il) {
            v_idx = start + dir * il * 2;
            o_idx = o_start + dir * il;
            int v_idx_last = v_idx - 2 * dir;
            int cc = cc_start + dir * il;
            if (o_flags[o_idx] != last_o) {
                boolean flip;
                byte[] side_s = new byte[2];
                byte[] last_side_s = new byte[2];
                Contour2D.getBoxSide(vx, vy, xx, xd, yy, yd, v_idx, dir, o_flags[o_idx], side_s);
                Contour2D.getBoxSide(vx, vy, xx, xd, yy, yd, v_idx_last, dir, last_o, last_side_s);
                int same_side_idx = -1;
                if (side_s[0] == last_side_s[0]) {
                    flip = false;
                    same_side_idx = 0;
                } else if (side_s[0] == last_side_s[1]) {
                    flip = true;
                    same_side_idx = 1;
                } else if (side_s[1] == last_side_s[0]) {
                    flip = true;
                    same_side_idx = 0;
                } else if (side_s[1] == last_side_s[1]) {
                    flip = false;
                    same_side_idx = 1;
                } else {
                    flip = (side_s[0] + last_side_s[0] & 1) != 1;
                }
                if (!flip) {
                    vv1[0] = vx[v_idx];
                    vv1[1] = vy[v_idx];
                    vv2[0] = vx[v_idx + dir];
                    vv2[1] = vy[v_idx + dir];
                    vv[0][0] = vx[v_idx];
                    vv[1][0] = vy[v_idx];
                    vv[0][1] = vx[v_idx + dir];
                    vv[1][1] = vy[v_idx + dir];
                } else {
                    vv1[0] = vx[v_idx + dir];
                    vv1[1] = vy[v_idx + dir];
                    vv2[0] = vx[v_idx];
                    vv2[1] = vy[v_idx];
                    vv[0][0] = vx[v_idx + dir];
                    vv[1][0] = vy[v_idx + dir];
                    vv[0][1] = vx[v_idx];
                    vv[1][1] = vy[v_idx];
                    byte tmp = side_s[0];
                    side_s[0] = side_s[1];
                    side_s[1] = tmp;
                }
                vv1_last[0] = vx[v_idx_last];
                vv1_last[1] = vy[v_idx_last];
                vv2_last[0] = vx[v_idx_last + dir];
                vv2_last[1] = vy[v_idx_last + dir];
                vv_last[0][0] = vx[v_idx_last];
                vv_last[1][0] = vy[v_idx_last];
                vv_last[0][1] = vx[v_idx_last + dir];
                vv_last[1][1] = vy[v_idx_last + dir];
                Contour2D.fillCaseChange(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, color_bin, cc, color_length, grd_normals, closed, same_side_idx, side_s, last_side_s, triStripBldr);
            } else {
                vv1[0] = vx[v_idx];
                vv1[1] = vy[v_idx];
                vv2[0] = vx[v_idx + dir];
                vv2[1] = vy[v_idx + dir];
                vv1_last[0] = vx[v_idx_last];
                vv1_last[1] = vy[v_idx_last];
                vv2_last[0] = vx[v_idx_last + dir];
                vv2_last[1] = vy[v_idx_last + dir];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, o_flags[o_idx], color_bin, cc, color_length, grd_normals, -1, triStripBldr);
            }
            last_o = o_flags[o_idx];
        }
        int flag_set = 0;
        if (last_o == 1 || last_o == 2 || last_o == 4 || last_o == 7) {
            if (last_o == 1) {
                flag_set = closed[0] & 1;
            }
            if (last_o == 2) {
                flag_set = closed[0] & 2;
            }
            if (last_o == 4) {
                flag_set = closed[0] & 4;
            }
            if (last_o == 7) {
                flag_set = closed[0] & 8;
            }
            if (flag_set > 0) {
                Contour2D.fillToOppCorner(xx, yy, xd, yd, v_idx, last_o, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
            } else {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, v_idx, last_o, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
            }
        } else if (last_o == 3) {
            int flag2 = -1;
            if (closed[0] == 3) {
                flag2 = 1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, last_o, flag2, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
        } else if (last_o == 5) {
            int flag3 = 1;
            if (closed[0] == 5) {
                flag3 = -1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, last_o, flag3, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
        }
    }

    private static void getBoxSide(float[] vx, float[] vy, float xx, float xd, float yy, float yd, int v_idx, int dir, byte o_flag, byte[] side) {
        block14: for (int kk = 0; kk < 2; ++kk) {
            int ii = v_idx + kk * dir;
            switch (o_flag) {
                case 1: {
                    side[kk] = 3;
                    if (vy[ii] != yy) continue block14;
                    side[kk] = 0;
                    continue block14;
                }
                case 2: {
                    side[kk] = 1;
                    if (vy[ii] != yy) continue block14;
                    side[kk] = 0;
                    continue block14;
                }
                case 4: {
                    side[kk] = 3;
                    if (vy[ii] != yy + yd) continue block14;
                    side[kk] = 2;
                    continue block14;
                }
                case 7: {
                    side[kk] = 1;
                    if (vy[ii] != yy + yd) continue block14;
                    side[kk] = 2;
                    continue block14;
                }
                case 3: {
                    side[kk] = 1;
                    if (vx[ii] != xx) continue block14;
                    side[kk] = 3;
                    continue block14;
                }
                case 5: {
                    side[kk] = 0;
                    if (vy[ii] != yy + yd) continue block14;
                    side[kk] = 2;
                }
            }
        }
        switch (o_flag) {
            case 1: {
                if (side[0] != side[1]) break;
                side[0] = 0;
                side[1] = 3;
                break;
            }
            case 2: {
                if (side[0] != side[1]) break;
                side[0] = 0;
                side[1] = 1;
                break;
            }
            case 4: {
                if (side[0] != side[1]) break;
                side[0] = 3;
                side[1] = 2;
                break;
            }
            case 7: {
                if (side[0] != side[1]) break;
                side[0] = 1;
                side[1] = 2;
            }
        }
    }

    private static void interpNormals(float[] vx, float[] vy, float xx, float yy, int nc, int nr, float xd, float yd, float[][][] grd_normals, float[][] tri_normals) {
        int n_verts = vx.length;
        float[][] tmp = new float[3][1];
        for (int k = 0; k < n_verts; ++k) {
            Contour2D.interpNormals(vx[k], vy[k], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
            tri_normals[0][k] = tmp[0][0];
            tri_normals[1][k] = tmp[1][0];
            tri_normals[2][k] = tmp[2][0];
        }
    }

    private static void interpNormals(float vx, float vy, float xx, float yy, int nc, int nr, float xd, float yd, float[][][] grd_normals, float[][] tri_normals) {
        int[] n_idx = new int[]{0};
        float[] temp = new float[3];
        Contour2D.interpNormals(vx, vy, xx, yy, nc, nr, xd, yd, grd_normals, n_idx, temp);
        tri_normals[0][0] = temp[0];
        tri_normals[1][0] = temp[1];
        tri_normals[2][0] = temp[2];
    }

    private static void interpNormals(float vx, float vy, float xx, float yy, int nc, int nr, float xd, float yd, float[][][] grd_normals, int[] n_idx, float[] tri_normals) {
        int side = -1;
        float[] nn = new float[3];
        if (vy == yy) {
            side = 0;
        }
        if (vy == yy + yd) {
            side = 2;
        }
        if (vx == xx) {
            side = 3;
        }
        if (vx == xx + xd) {
            side = 1;
        }
        float dx = vx - xx;
        float dy = vy - yy;
        switch (side) {
            case 0: {
                nn[0] = (grd_normals[nc][nr + 1][0] - grd_normals[nc][nr][0]) / xd * dx + grd_normals[nc][nr][0];
                nn[1] = (grd_normals[nc][nr + 1][1] - grd_normals[nc][nr][1]) / xd * dx + grd_normals[nc][nr][1];
                nn[2] = (grd_normals[nc][nr + 1][2] - grd_normals[nc][nr][2]) / xd * dx + grd_normals[nc][nr][2];
                break;
            }
            case 3: {
                nn[0] = (grd_normals[nc + 1][nr][0] - grd_normals[nc][nr][0]) / yd * dy + grd_normals[nc][nr][0];
                nn[1] = (grd_normals[nc + 1][nr][1] - grd_normals[nc][nr][1]) / yd * dy + grd_normals[nc][nr][1];
                nn[2] = (grd_normals[nc + 1][nr][2] - grd_normals[nc][nr][2]) / yd * dy + grd_normals[nc][nr][2];
                break;
            }
            case 1: {
                nn[0] = (grd_normals[nc + 1][nr + 1][0] - grd_normals[nc][nr + 1][0]) / yd * dy + grd_normals[nc][nr + 1][0];
                nn[1] = (grd_normals[nc + 1][nr + 1][1] - grd_normals[nc][nr + 1][1]) / yd * dy + grd_normals[nc][nr + 1][1];
                nn[2] = (grd_normals[nc + 1][nr + 1][2] - grd_normals[nc][nr + 1][2]) / yd * dy + grd_normals[nc][nr + 1][2];
                break;
            }
            case 2: {
                nn[0] = (grd_normals[nc + 1][nr + 1][0] - grd_normals[nc + 1][nr][0]) / xd * dx + grd_normals[nc + 1][nr][0];
                nn[1] = (grd_normals[nc + 1][nr + 1][1] - grd_normals[nc + 1][nr][1]) / xd * dx + grd_normals[nc + 1][nr][1];
                nn[2] = (grd_normals[nc + 1][nr + 1][2] - grd_normals[nc + 1][nr][2]) / xd * dx + grd_normals[nc + 1][nr][2];
                break;
            }
            default: {
                System.out.println("interpNormals, bad side: " + side);
            }
        }
        float mag = (float)Math.sqrt(nn[0] * nn[0] + nn[1] * nn[1] + nn[2] * nn[2]);
        nn[0] = nn[0] / mag;
        nn[1] = nn[1] / mag;
        nn[2] = nn[2] / mag;
        int n = n_idx[0];
        n_idx[0] = n + 1;
        tri_normals[n] = nn[0];
        int n2 = n_idx[0];
        n_idx[0] = n2 + 1;
        tri_normals[n2] = nn[1];
        int n3 = n_idx[0];
        n_idx[0] = n3 + 1;
        tri_normals[n3] = nn[2];
    }

    private static void fillToLast(float xx, float yy, float xd, float yd, int nc, int nr, float[] vv1, float[] vv2, float[] vv1_last, float[] vv2_last, byte kase, byte[][] color_bin, int cc, int color_length, float[][][] grd_normals, int same_side_idx, TriangleStripBuilder triStripBldr) {
        float[][] tri = new float[2][4];
        float[][] normals = new float[3][4];
        byte[] side_s = new byte[2];
        byte[] last_side_s = new byte[2];
        byte[] strp_sides = new byte[4];
        int startIdx = 0;
        float[] vx = new float[2];
        float[] vy = new float[2];
        vx[0] = vv1[0];
        vx[1] = vv2[0];
        vy[0] = vv1[1];
        vy[1] = vv2[1];
        Contour2D.getBoxSide(vx, vy, xx, xd, yy, yd, 0, 1, kase, side_s);
        vx[0] = vv1_last[0];
        vx[1] = vv2_last[0];
        vy[0] = vv1_last[1];
        vy[1] = vv2_last[1];
        Contour2D.getBoxSide(vx, vy, xx, xd, yy, yd, 0, 1, kase, last_side_s);
        Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, color_bin, cc, color_length, grd_normals, same_side_idx, side_s, last_side_s, strp_sides, tri, normals, startIdx, triStripBldr);
    }

    private static void fillToLast(float xx, float yy, float xd, float yd, int nc, int nr, float[] vv1, float[] vv2, float[] vv1_last, float[] vv2_last, byte[][] color_bin, int cc, int color_length, float[][][] grd_normals, int same_side_idx, byte[] side_s, byte[] last_side_s, byte[] strp_sides, float[][] tri, float[][] normals, int startIdx, TriangleStripBuilder triStripBldr) {
        float y3;
        float x3;
        float y2;
        float x2;
        float y1;
        float x1;
        float y0;
        float x0;
        float[][] tmp = new float[3][1];
        byte[] color = new byte[color_length];
        for (int ii = 0; ii < color_length; ++ii) {
            color[ii] = color_bin[ii][cc];
        }
        if (same_side_idx <= 0) {
            x0 = vv1[0];
            y0 = vv1[1];
            x1 = vv1_last[0];
            y1 = vv1_last[1];
            x2 = vv2[0];
            y2 = vv2[1];
            x3 = vv2_last[0];
            y3 = vv2_last[1];
            strp_sides[0] = side_s[0];
            strp_sides[1] = last_side_s[0];
            strp_sides[2] = side_s[1];
            strp_sides[3] = last_side_s[1];
        } else {
            x0 = vv2[0];
            y0 = vv2[1];
            x1 = vv2_last[0];
            y1 = vv2_last[1];
            x2 = vv1[0];
            y2 = vv1[1];
            x3 = vv1_last[0];
            y3 = vv1_last[1];
            strp_sides[0] = side_s[1];
            strp_sides[1] = last_side_s[1];
            strp_sides[2] = side_s[0];
            strp_sides[3] = last_side_s[0];
        }
        int idx = startIdx + 0;
        tri[0][idx] = x0;
        tri[1][idx] = y0;
        Contour2D.interpNormals(tri[0][idx], tri[1][idx], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][idx] = tmp[0][0];
        normals[1][idx] = tmp[1][0];
        normals[2][idx] = tmp[2][0];
        idx = startIdx + 1;
        tri[0][idx] = x1;
        tri[1][idx] = y1;
        Contour2D.interpNormals(tri[0][idx], tri[1][idx], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][idx] = tmp[0][0];
        normals[1][idx] = tmp[1][0];
        normals[2][idx] = tmp[2][0];
        idx = startIdx + 2;
        tri[0][idx] = x2;
        tri[1][idx] = y2;
        Contour2D.interpNormals(tri[0][idx], tri[1][idx], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][idx] = tmp[0][0];
        normals[1][idx] = tmp[1][0];
        normals[2][idx] = tmp[2][0];
        idx = startIdx + 3;
        tri[0][idx] = x3;
        tri[1][idx] = y3;
        Contour2D.interpNormals(tri[0][idx], tri[1][idx], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][idx] = tmp[0][0];
        normals[1][idx] = tmp[1][0];
        normals[2][idx] = tmp[2][0];
        if (triStripBldr != null) {
            int first_tri_orient = 0;
            int last_tri_orient = 0;
            byte kase = strp_sides[0];
            byte first_strp_side = strp_sides[0];
            byte last_strp_side = strp_sides[3];
            switch (kase) {
                case 1: {
                    if (tri[0][1] - tri[0][0] >= 0.0f) {
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        break;
                    }
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                    break;
                }
                case 2: {
                    if (tri[0][1] - tri[0][0] >= 0.0f) {
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        break;
                    }
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                    break;
                }
                case 4: {
                    if (tri[1][1] - tri[1][0] >= 0.0f) {
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        break;
                    }
                    first_tri_orient = 1;
                    last_tri_orient = -1;
                    break;
                }
                case 7: {
                    if (tri[1][1] - tri[1][0] >= 0.0f) {
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        break;
                    }
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                    break;
                }
                case 3: {
                    if (tri[1][1] - tri[1][0] >= 0.0f) {
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        break;
                    }
                    first_tri_orient = 1;
                    last_tri_orient = -1;
                    break;
                }
                case 5: {
                    if (tri[0][1] - tri[0][0] >= 0.0f) {
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        break;
                    }
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                }
            }
            triStripBldr.addVerticies(cc, tri, normals, color, first_strp_side, (byte)first_tri_orient, last_strp_side, (byte)last_tri_orient);
        }
    }

    private static void fillCaseChange(float xx, float yy, float xd, float yd, int nc, int nr, float[] vv1, float[] vv2, float[] vv1_last, float[] vv2_last, byte[][] color_bin, int cc, int color_length, float[][][] grd_normals, int[] closed, int same_side_idx, byte[] side_s, byte[] last_side_s, TriangleStripBuilder triStripBldr) {
        byte side;
        float[][] tri = null;
        float[][] normals = null;
        int first_tri_orient = 0;
        int last_tri_orient = 0;
        int first_strp_side = -1;
        int last_strp_side = -1;
        byte[] strp_sides = new byte[4];
        byte[] color = new byte[color_length];
        for (int k = 0; k < color_length; ++k) {
            color[k] = color_bin[k][cc];
        }
        if (same_side_idx == -1) {
            tri = new float[2][6];
            normals = new float[3][6];
            side = side_s[0];
            byte last_s = last_side_s[0];
            byte[] cornersToAdd = new byte[2];
            Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, color_bin, cc, color_length, grd_normals, same_side_idx, side_s, last_side_s, strp_sides, tri, normals, 1, null);
            if (side == 0 && last_s == 1 || side == 3 && last_s == 2 || side == 2 && last_s == 3 || side == 1 && last_s == 0) {
                if (strp_sides[0] == 0 && strp_sides[1] == 1) {
                    cornersToAdd[0] = 1;
                    cornersToAdd[1] = 2;
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                }
                if (strp_sides[0] == 1 && strp_sides[1] == 0) {
                    cornersToAdd[0] = 1;
                    cornersToAdd[1] = 2;
                    first_tri_orient = 1;
                    last_tri_orient = -1;
                }
                if (strp_sides[0] == 3 && strp_sides[1] == 2) {
                    cornersToAdd[0] = 2;
                    cornersToAdd[1] = 1;
                    first_tri_orient = 1;
                    last_tri_orient = -1;
                }
                if (strp_sides[0] == 2 && strp_sides[1] == 3) {
                    cornersToAdd[0] = 2;
                    cornersToAdd[1] = 1;
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                }
            }
            if (side == 0 && last_s == 3 || side == 1 && last_s == 2 || side == 3 && last_s == 0 || side == 2 && last_s == 1) {
                if (strp_sides[0] == 0 && strp_sides[1] == 3) {
                    cornersToAdd[0] = 0;
                    cornersToAdd[1] = 3;
                    first_tri_orient = 1;
                    last_tri_orient = -1;
                }
                if (strp_sides[0] == 3 && strp_sides[1] == 0) {
                    cornersToAdd[0] = 0;
                    cornersToAdd[1] = 3;
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                }
                if (strp_sides[0] == 1 && strp_sides[1] == 2) {
                    cornersToAdd[0] = 3;
                    cornersToAdd[1] = 0;
                    first_tri_orient = -1;
                    last_tri_orient = 1;
                }
                if (strp_sides[0] == 2 && strp_sides[1] == 1) {
                    cornersToAdd[0] = 3;
                    cornersToAdd[1] = 0;
                    first_tri_orient = 1;
                    last_tri_orient = -1;
                }
            }
            first_strp_side = strp_sides[0];
            last_strp_side = strp_sides[3];
            Contour2D.addCorner(xx, yy, xd, yd, nc, nr, cornersToAdd[0], grd_normals, closed, 0, tri, normals);
            Contour2D.addCorner(xx, yy, xd, yd, nc, nr, cornersToAdd[1], grd_normals, closed, 5, tri, normals);
            triStripBldr.addVerticies(cc, tri, normals, color, (byte)first_strp_side, (byte)first_tri_orient, (byte)last_strp_side, (byte)last_tri_orient);
        } else {
            int indx = same_side_idx == 0 ? 1 : 0;
            side = side_s[indx];
            byte last_s = last_side_s[indx];
            int kase = 0;
            if (side == 0 && last_s == 3 || side == 3 && last_s == 0) {
                kase = 1;
            }
            if (side == 0 && last_s == 1 || side == 1 && last_s == 0) {
                kase = 2;
            }
            if (side == 2 && last_s == 3 || side == 3 && last_s == 2) {
                kase = 4;
            }
            if (side == 2 && last_s == 1 || side == 1 && last_s == 2) {
                kase = 7;
            }
            if (side == 1 && last_s == 3 || side == 3 && last_s == 1) {
                kase = 3;
            }
            if (side == 2 && last_s == 0 || side == 0 && last_s == 2) {
                kase = 5;
            }
            if (kase == 1 || kase == 2 || kase == 4 || kase == 7) {
                byte cornerId = 127;
                tri = new float[2][5];
                normals = new float[3][5];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, color_bin, cc, color_length, grd_normals, same_side_idx, side_s, last_side_s, strp_sides, tri, normals, 0, null);
                if (kase == 1) {
                    cornerId = 0;
                    last_strp_side = strp_sides[3];
                    first_strp_side = strp_sides[0];
                    if (last_strp_side == 3) {
                        last_tri_orient = 1;
                        first_tri_orient = 1;
                    } else if (last_strp_side == 0) {
                        last_tri_orient = -1;
                        first_tri_orient = -1;
                    }
                }
                if (kase == 2) {
                    cornerId = 1;
                    last_strp_side = strp_sides[3];
                    first_strp_side = strp_sides[0];
                    if (last_strp_side == 1) {
                        last_tri_orient = -1;
                        first_tri_orient = -1;
                    } else if (last_strp_side == 0) {
                        last_tri_orient = 1;
                        first_tri_orient = 1;
                    }
                }
                if (kase == 4) {
                    cornerId = 2;
                    last_strp_side = strp_sides[3];
                    first_strp_side = strp_sides[0];
                    if (last_strp_side == 2) {
                        last_tri_orient = 1;
                        first_tri_orient = 1;
                    } else if (last_strp_side == 3) {
                        last_tri_orient = -1;
                        first_tri_orient = -1;
                    }
                }
                if (kase == 7) {
                    cornerId = 3;
                    last_strp_side = strp_sides[3];
                    first_strp_side = strp_sides[0];
                    if (last_strp_side == 2) {
                        last_tri_orient = -1;
                        first_tri_orient = -1;
                    } else if (last_strp_side == 1) {
                        last_tri_orient = 1;
                        first_tri_orient = 1;
                    }
                }
                Contour2D.addCorner(xx, yy, xd, yd, nc, nr, cornerId, grd_normals, closed, 4, tri, normals);
            } else if (kase == 5) {
                byte[] oppCorners = new byte[]{127, 127};
                byte same_side = side_s[same_side_idx];
                tri = new float[2][6];
                normals = new float[3][6];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, color_bin, cc, color_length, grd_normals, same_side_idx, side_s, last_side_s, strp_sides, tri, normals, 0, null);
                if (same_side == 1) {
                    if (strp_sides[3] == 2) {
                        oppCorners = new byte[]{0, 2};
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        first_strp_side = 1;
                        last_strp_side = 3;
                    } else if (strp_sides[3] == 0) {
                        oppCorners = new byte[]{2, 0};
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 1;
                        last_strp_side = 3;
                    }
                }
                if (same_side == 3) {
                    if (strp_sides[3] == 2) {
                        oppCorners = new byte[]{1, 3};
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 3;
                        last_strp_side = 1;
                    } else if (strp_sides[3] == 0) {
                        oppCorners = new byte[]{3, 1};
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        first_strp_side = 3;
                        last_strp_side = 1;
                    }
                }
                Contour2D.addCorner(xx, yy, xd, yd, nc, nr, oppCorners[0], grd_normals, closed, 4, tri, normals);
                Contour2D.addCorner(xx, yy, xd, yd, nc, nr, oppCorners[1], grd_normals, closed, 5, tri, normals);
            } else if (kase == 3) {
                byte[] oppCorners = new byte[]{127, 127};
                byte same_side = side_s[same_side_idx];
                tri = new float[2][6];
                normals = new float[3][6];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, color_bin, cc, color_length, grd_normals, same_side_idx, side_s, last_side_s, strp_sides, tri, normals, 0, null);
                if (same_side == 0) {
                    if (strp_sides[3] == 3) {
                        oppCorners = new byte[]{3, 2};
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 0;
                        last_strp_side = 2;
                    } else if (strp_sides[3] == 1) {
                        oppCorners = new byte[]{2, 3};
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        first_strp_side = 0;
                        last_strp_side = 2;
                    }
                }
                if (same_side == 2) {
                    if (strp_sides[3] == 3) {
                        oppCorners = new byte[]{1, 0};
                        first_tri_orient = 1;
                        last_tri_orient = -1;
                        first_strp_side = 2;
                        last_strp_side = 0;
                    } else if (strp_sides[3] == 1) {
                        oppCorners = new byte[]{0, 1};
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 2;
                        last_strp_side = 0;
                    }
                }
                Contour2D.addCorner(xx, yy, xd, yd, nc, nr, oppCorners[0], grd_normals, closed, 4, tri, normals);
                Contour2D.addCorner(xx, yy, xd, yd, nc, nr, oppCorners[1], grd_normals, closed, 5, tri, normals);
            }
            triStripBldr.addVerticies(cc, tri, normals, color, (byte)first_strp_side, (byte)first_tri_orient, (byte)last_strp_side, (byte)last_tri_orient);
        }
    }

    private static void fillCaseSix(float xx, float yy, float xd, float yd, int v_idx, int dir, byte[] o_flags, short ctrLow, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, int[] crnrLevelIdx, boolean[] crnr_out, byte[][] color_bin, int color_length, float[][][] grd_normals, int[] closed, TriangleStripBuilder triStripBldr) {
        float[][] tri = null;
        int n1 = 0;
        int n2 = 0;
        int n4 = 0;
        int n7 = 0;
        for (int kk = 0; kk < o_flags.length; ++kk) {
            if (o_flags[kk] - 32 == 1 || o_flags[kk] == 1) {
                ++n1;
            }
            if (o_flags[kk] - 32 == 2 || o_flags[kk] == 2) {
                ++n2;
            }
            if (o_flags[kk] - 32 == 4 || o_flags[kk] == 4) {
                ++n4;
            }
            if (o_flags[kk] - 32 != 7 && o_flags[kk] != 7) continue;
            ++n7;
        }
        float[][] vv1 = new float[2][n1 * 2];
        float[][] vv2 = new float[2][n2 * 2];
        float[][] vv4 = new float[2][n4 * 2];
        float[][] vv7 = new float[2][n7 * 2];
        int[] clr_idx1 = new int[n1];
        int[] clr_idx2 = new int[n2];
        int[] clr_idx4 = new int[n4];
        int[] clr_idx7 = new int[n7];
        float[] vvv1 = new float[2];
        float[] vvv2 = new float[2];
        float[] vvv1_last = new float[2];
        float[] vvv2_last = new float[2];
        n1 = 0;
        n2 = 0;
        n4 = 0;
        n7 = 0;
        int ii = v_idx;
        int cc = ctrLow - 1;
        int cnt = 0;
        int[] cases = new int[]{1, 2, 7, 4};
        for (int kk = 0; kk < o_flags.length; ++kk) {
            if (o_flags[kk] > 32) {
                ++cnt;
            }
            if (o_flags[kk] - 32 == 1 || o_flags[kk] == 1) {
                clr_idx1[n1] = cc;
                vv1[0][2 * n1] = vx[ii];
                vv1[1][2 * n1] = vy[ii];
                vv1[0][2 * n1 + 1] = vx[ii + 1];
                vv1[1][2 * n1 + 1] = vy[ii + 1];
                ++n1;
            } else if (o_flags[kk] - 32 == 2 || o_flags[kk] == 2) {
                clr_idx2[n2] = cc;
                vv2[0][2 * n2] = vx[ii];
                vv2[1][2 * n2] = vy[ii];
                vv2[0][2 * n2 + 1] = vx[ii + 1];
                vv2[1][2 * n2 + 1] = vy[ii + 1];
                ++n2;
            } else if (o_flags[kk] - 32 == 4 || o_flags[kk] == 4) {
                clr_idx4[n4] = cc;
                vv4[0][2 * n4] = vx[ii];
                vv4[1][2 * n4] = vy[ii];
                vv4[0][2 * n4 + 1] = vx[ii + 1];
                vv4[1][2 * n4 + 1] = vy[ii + 1];
                ++n4;
            } else if (o_flags[kk] - 32 == 7 || o_flags[kk] == 7) {
                clr_idx7[n7] = cc;
                vv7[0][2 * n7] = vx[ii];
                vv7[1][2 * n7] = vy[ii];
                vv7[0][2 * n7 + 1] = vx[ii + 1];
                vv7[1][2 * n7 + 1] = vy[ii + 1];
                ++n7;
            }
            if (o_flags[kk] < 32) {
                ++cc;
            } else if (cnt == 2) {
                cnt = 0;
                ++cc;
            }
            ii += 2;
        }
        int[] clr_idx = null;
        float[] vvx = null;
        float[] vvy = null;
        float[] x_avg = new float[2];
        float[] y_avg = new float[2];
        float dist_0 = 0.0f;
        float dist_1 = 0.0f;
        float xxx = 0.0f;
        float yyy = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        int nn = 0;
        int pt = 0;
        int n_pt = 0;
        int s_idx = 0;
        int ns_idx = 0;
        byte[] tmp = null;
        byte[] cntr_color = null;
        int cntr_clr = Integer.MIN_VALUE;
        float[][] edge_points = new float[2][8];
        boolean[] edge_point_a_corner = new boolean[]{false, false, false, false, false, false, false, false};
        boolean[] edge_point_out = new boolean[]{false, false, false, false, false, false, false, false};
        boolean this_crnr_out = false;
        int n_crnr_out = 0;
        int[] which_corner = new int[2];
        int num_corners = 0;
        for (int kk = 0; kk < cases.length; ++kk) {
            switch (cases[kk]) {
                case 1: {
                    nn = n1;
                    clr_idx = clr_idx1;
                    vvx = vv1[0];
                    vvy = vv1[1];
                    xxx = xx;
                    yyy = yy;
                    pt = 0;
                    n_pt = 7;
                    s_idx = 0;
                    ns_idx = 1;
                    tmp = crnr_color[0];
                    this_crnr_out = crnr_out[0];
                    break;
                }
                case 2: {
                    nn = n2;
                    clr_idx = clr_idx2;
                    vvx = vv2[0];
                    vvy = vv2[1];
                    xxx = xx + xd;
                    yyy = yy;
                    pt = 1;
                    n_pt = 2;
                    s_idx = 0;
                    ns_idx = 1;
                    tmp = crnr_color[1];
                    this_crnr_out = crnr_out[1];
                    break;
                }
                case 4: {
                    nn = n4;
                    clr_idx = clr_idx4;
                    vvx = vv4[0];
                    vvy = vv4[1];
                    xxx = xx;
                    yyy = yy + yd;
                    pt = 5;
                    n_pt = 6;
                    s_idx = 1;
                    ns_idx = 0;
                    tmp = crnr_color[2];
                    this_crnr_out = crnr_out[2];
                    break;
                }
                case 7: {
                    nn = n7;
                    clr_idx = clr_idx7;
                    vvx = vv7[0];
                    vvy = vv7[1];
                    xxx = xx + xd;
                    yyy = yy + yd;
                    pt = 3;
                    n_pt = 4;
                    s_idx = 0;
                    ns_idx = 1;
                    tmp = crnr_color[3];
                    this_crnr_out = crnr_out[3];
                }
            }
            if (nn == 0) {
                edge_points[0][pt] = xxx;
                edge_points[1][pt] = yyy;
                edge_points[0][n_pt] = xxx;
                edge_points[1][n_pt] = yyy;
                cntr_color = tmp;
                edge_point_a_corner[pt] = true;
                edge_point_a_corner[n_pt] = true;
                edge_point_out[pt] = this_crnr_out;
                edge_point_out[n_pt] = this_crnr_out;
                which_corner[num_corners] = cases[kk];
                ++num_corners;
                if (!this_crnr_out) continue;
                ++n_crnr_out;
                continue;
            }
            if (nn == 1) {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)cases[kk], dir, vvx, vvy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
                edge_points[0][pt] = vvx[s_idx];
                edge_points[1][pt] = vvy[s_idx];
                edge_points[0][n_pt] = vvx[ns_idx];
                edge_points[1][n_pt] = vvy[ns_idx];
                if (clr_idx[0] <= cntr_clr) continue;
                cntr_clr = clr_idx[0];
                continue;
            }
            int il = 0;
            int idx = 0;
            x_avg[0] = (vvx[idx] + vvx[idx + 1]) / 2.0f;
            y_avg[0] = (vvy[idx] + vvy[idx + 1]) / 2.0f;
            x_avg[1] = (vvx[idx += 2] + vvx[idx + 1]) / 2.0f;
            y_avg[1] = (vvy[idx] + vvy[idx + 1]) / 2.0f;
            dy = y_avg[1] - yyy;
            dx = x_avg[1] - xxx;
            dist_1 = dy * dy + dx * dx;
            dy = y_avg[0] - yyy;
            dx = x_avg[0] - xxx;
            dist_0 = dy * dy + dx * dx;
            boolean cornerFirst = false;
            if (dist_1 > dist_0) {
                cornerFirst = true;
            }
            if (cornerFirst) {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)cases[kk], dir, vvx, vvy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
            } else {
                edge_points[0][pt] = vvx[s_idx];
                edge_points[1][pt] = vvy[s_idx];
                edge_points[0][n_pt] = vvx[ns_idx];
                edge_points[1][n_pt] = vvy[ns_idx];
                if (clr_idx[0] > cntr_clr) {
                    cntr_clr = clr_idx[0];
                }
            }
            for (il = 1; il < nn; ++il) {
                idx = dir * il * 2;
                int idx_last = idx - 2 * dir;
                vvv1[0] = vvx[idx];
                vvv1[1] = vvy[idx];
                vvv2[0] = vvx[idx + dir];
                vvv2[1] = vvy[idx + dir];
                vvv1_last[0] = vvx[idx_last];
                vvv1_last[1] = vvy[idx_last];
                vvv2_last[0] = vvx[idx_last + dir];
                vvv2_last[1] = vvy[idx_last + dir];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vvv1, vvv2, vvv1_last, vvv2_last, (byte)cases[kk], color_bin, clr_idx[il], color_length, grd_normals, -1, triStripBldr);
                if (!cornerFirst && il == nn - 1) {
                    Contour2D.fillToNearCorner(xx, yy, xd, yd, idx, (byte)cases[kk], dir, vvx, vvy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, triStripBldr);
                }
                if (!cornerFirst || il != nn - 1) continue;
                edge_points[0][pt] = vvx[idx + s_idx];
                edge_points[1][pt] = vvy[idx + s_idx];
                edge_points[0][n_pt] = vvx[idx + ns_idx];
                edge_points[1][n_pt] = vvy[idx + ns_idx];
                if (clr_idx[il] <= cntr_clr) continue;
                cntr_clr = clr_idx[il];
            }
        }
        if (n_crnr_out == 2) {
            return;
        }
        if (cntr_color == null) {
            cntr_color = new byte[color_length];
            for (int c = 0; c < color_length; ++c) {
                cntr_color[c] = color_bin[c][cntr_clr];
            }
        }
        byte first_tri_orient = 0;
        byte last_tri_orient = 0;
        byte first_strp_side = -1;
        byte last_strp_side = -1;
        float[][] normals = null;
        if (num_corners == 0) {
            tri = new float[2][8];
            normals = new float[3][8];
            tri[0][0] = edge_points[0][7];
            tri[1][0] = edge_points[1][7];
            tri[0][1] = edge_points[0][6];
            tri[1][1] = edge_points[1][6];
            tri[0][2] = edge_points[0][0];
            tri[1][2] = edge_points[1][0];
            tri[0][3] = edge_points[0][5];
            tri[1][3] = edge_points[1][5];
            tri[0][4] = edge_points[0][1];
            tri[1][4] = edge_points[1][1];
            tri[0][5] = edge_points[0][4];
            tri[1][5] = edge_points[1][4];
            tri[0][6] = edge_points[0][2];
            tri[1][6] = edge_points[1][2];
            tri[0][7] = edge_points[0][3];
            tri[1][7] = edge_points[1][3];
            first_strp_side = 3;
            last_strp_side = 1;
            first_tri_orient = -1;
            last_tri_orient = 1;
            Contour2D.interpNormals(tri[0], tri[1], xx, yy, nc, nr, xd, yd, grd_normals, normals);
            triStripBldr.addVerticies(cntr_clr, tri, normals, cntr_color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
        } else if (num_corners == 1) {
            tri = new float[2][7];
            normals = new float[3][7];
            if (which_corner[0] == 1) {
                tri[0][0] = edge_points[0][6];
                tri[1][0] = edge_points[1][6];
                tri[0][1] = edge_points[0][0];
                tri[1][1] = edge_points[1][0];
                tri[0][2] = edge_points[0][5];
                tri[1][2] = edge_points[1][5];
                tri[0][3] = edge_points[0][1];
                tri[1][3] = edge_points[1][1];
                tri[0][4] = edge_points[0][4];
                tri[1][4] = edge_points[1][4];
                tri[0][5] = edge_points[0][2];
                tri[1][5] = edge_points[1][2];
                tri[0][6] = edge_points[0][3];
                tri[1][6] = edge_points[1][3];
                first_strp_side = 3;
                last_strp_side = 1;
                first_tri_orient = 1;
                last_tri_orient = 1;
            } else if (which_corner[0] == 2) {
                tri[0][0] = edge_points[0][6];
                tri[1][0] = edge_points[1][6];
                tri[0][1] = edge_points[0][7];
                tri[1][1] = edge_points[1][7];
                tri[0][2] = edge_points[0][5];
                tri[1][2] = edge_points[1][5];
                tri[0][3] = edge_points[0][0];
                tri[1][3] = edge_points[1][0];
                tri[0][4] = edge_points[0][4];
                tri[1][4] = edge_points[1][4];
                tri[0][5] = edge_points[0][1];
                tri[1][5] = edge_points[1][1];
                tri[0][6] = edge_points[0][3];
                tri[1][6] = edge_points[1][3];
                first_strp_side = 3;
                last_strp_side = 1;
                first_tri_orient = 1;
                last_tri_orient = 1;
            } else if (which_corner[0] == 7) {
                tri[0][0] = edge_points[0][7];
                tri[1][0] = edge_points[1][7];
                tri[0][1] = edge_points[0][6];
                tri[1][1] = edge_points[1][6];
                tri[0][2] = edge_points[0][0];
                tri[1][2] = edge_points[1][0];
                tri[0][3] = edge_points[0][5];
                tri[1][3] = edge_points[1][5];
                tri[0][4] = edge_points[0][1];
                tri[1][4] = edge_points[1][1];
                tri[0][5] = edge_points[0][4];
                tri[1][5] = edge_points[1][4];
                tri[0][6] = edge_points[0][2];
                tri[1][6] = edge_points[1][2];
                first_strp_side = 3;
                last_strp_side = 1;
                first_tri_orient = -1;
                last_tri_orient = -1;
            } else if (which_corner[0] == 4) {
                tri[0][0] = edge_points[0][7];
                tri[1][0] = edge_points[1][7];
                tri[0][1] = edge_points[0][6];
                tri[1][1] = edge_points[1][6];
                tri[0][2] = edge_points[0][0];
                tri[1][2] = edge_points[1][0];
                tri[0][3] = edge_points[0][4];
                tri[1][3] = edge_points[1][4];
                tri[0][4] = edge_points[0][1];
                tri[1][4] = edge_points[1][1];
                tri[0][5] = edge_points[0][3];
                tri[1][5] = edge_points[1][3];
                tri[0][6] = edge_points[0][2];
                tri[1][6] = edge_points[1][2];
                first_strp_side = 3;
                last_strp_side = 1;
                first_tri_orient = -1;
                last_tri_orient = -1;
            }
            Contour2D.interpNormals(tri[0], tri[1], xx, yy, nc, nr, xd, yd, grd_normals, normals);
            triStripBldr.addVerticies(cntr_clr, tri, normals, cntr_color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
        } else if (num_corners == 2) {
            int flag;
            tri = new float[2][6];
            normals = new float[3][6];
            int n = flag = which_corner[0] == 1 && which_corner[1] == 7 || which_corner[0] == 7 && which_corner[1] == 1 ? 1 : 4;
            if (flag == 4) {
                tri[0][0] = edge_points[0][6];
                tri[1][0] = edge_points[1][6];
                tri[0][1] = edge_points[0][7];
                tri[1][1] = edge_points[1][7];
                tri[0][2] = edge_points[0][4];
                tri[1][2] = edge_points[1][4];
                tri[0][3] = edge_points[0][0];
                tri[1][3] = edge_points[1][0];
                tri[0][4] = edge_points[0][3];
                tri[1][4] = edge_points[1][3];
                tri[0][5] = edge_points[0][1];
                tri[1][5] = edge_points[1][1];
                first_strp_side = 3;
                last_strp_side = 1;
                first_tri_orient = 1;
                last_tri_orient = -1;
            } else if (flag == 1) {
                tri[0][0] = edge_points[0][6];
                tri[1][0] = edge_points[1][6];
                tri[0][1] = edge_points[0][7];
                tri[1][1] = edge_points[1][7];
                tri[0][2] = edge_points[0][5];
                tri[1][2] = edge_points[1][5];
                tri[0][3] = edge_points[0][1];
                tri[1][3] = edge_points[1][1];
                tri[0][4] = edge_points[0][3];
                tri[1][4] = edge_points[1][3];
                tri[0][5] = edge_points[0][2];
                tri[1][5] = edge_points[1][2];
                first_strp_side = 3;
                last_strp_side = 1;
                first_tri_orient = 1;
                last_tri_orient = -1;
            }
            Contour2D.interpNormals(tri[0], tri[1], xx, yy, nc, nr, xd, yd, grd_normals, normals);
            triStripBldr.addVerticies(cntr_clr, tri, normals, cntr_color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
        }
    }

    private static void fillToNearCorner(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, int[] crnrLevelIdx, boolean[] crnr_out, float[][][] grd_normals, int[] closed, TriangleStripBuilder triStripBldr) {
        float cx = 0.0f;
        float cy = 0.0f;
        int cc = 0;
        int color_length = crnr_color[0].length;
        int vidx_0 = 0;
        int vidx_1 = 0;
        int crn = 0;
        float[][] normals = new float[3][3];
        float[][] tri = new float[2][3];
        float[][] tmp = new float[3][1];
        byte[] color = new byte[color_length];
        byte first_tri_orient = 0;
        byte last_tri_orient = 0;
        byte first_strp_side = -1;
        byte last_strp_side = -1;
        switch (o_flag) {
            case 1: {
                cc = 0;
                closed[0] = closed[0] | 1;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx;
                cy = yy;
                vidx_0 = 2;
                vidx_1 = 1;
                crn = 0;
                normals[0][crn] = grd_normals[nc][nr][0];
                normals[1][crn] = grd_normals[nc][nr][1];
                normals[2][crn] = grd_normals[nc][nr][2];
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 3;
                last_strp_side = 0;
                break;
            }
            case 4: {
                cc = 2;
                closed[0] = closed[0] | 4;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx;
                cy = yy + yd;
                vidx_0 = 0;
                vidx_1 = 2;
                crn = 1;
                normals[0][crn] = grd_normals[nc + 1][nr][0];
                normals[1][crn] = grd_normals[nc + 1][nr][1];
                normals[2][crn] = grd_normals[nc + 1][nr][2];
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 3;
                last_strp_side = 2;
                break;
            }
            case 2: {
                cc = 1;
                closed[0] = closed[0] | 2;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx + xd;
                cy = yy;
                vidx_0 = 0;
                vidx_1 = 2;
                crn = 1;
                normals[0][crn] = grd_normals[nc][nr + 1][0];
                normals[1][crn] = grd_normals[nc][nr + 1][1];
                normals[2][crn] = grd_normals[nc][nr + 1][2];
                first_tri_orient = 1;
                last_tri_orient = 1;
                first_strp_side = 0;
                last_strp_side = 1;
                break;
            }
            case 7: {
                cc = 3;
                closed[0] = closed[0] | 8;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx + xd;
                cy = yy + yd;
                vidx_0 = 2;
                vidx_1 = 0;
                crn = 1;
                normals[0][crn] = grd_normals[nc + 1][nr + 1][0];
                normals[1][crn] = grd_normals[nc + 1][nr + 1][1];
                normals[2][crn] = grd_normals[nc + 1][nr + 1][2];
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 2;
                last_strp_side = 1;
            }
        }
        for (int ii = 0; ii < color_length; ++ii) {
            color[ii] = crnr_color[cc][ii];
        }
        int levIdx = crnrLevelIdx[cc];
        tri[0][crn] = cx;
        tri[1][crn] = cy;
        tri[0][vidx_0] = vx[v_idx];
        tri[1][vidx_0] = vy[v_idx];
        Contour2D.interpNormals(tri[0][vidx_0], tri[1][vidx_0], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][vidx_0] = tmp[0][0];
        normals[1][vidx_0] = tmp[1][0];
        normals[2][vidx_0] = tmp[2][0];
        tri[0][vidx_1] = vx[v_idx + dir];
        tri[1][vidx_1] = vy[v_idx + dir];
        Contour2D.interpNormals(tri[0][vidx_1], tri[1][vidx_1], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][vidx_1] = tmp[0][0];
        normals[1][vidx_1] = tmp[1][0];
        normals[2][vidx_1] = tmp[2][0];
        triStripBldr.addVerticies(levIdx, tri, normals, color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
    }

    private static void fillToOppCorner(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, int[] crnrLevelIdx, boolean[] crnr_out, float[][][] grd_normals, int[] closed, TriangleStripBuilder triStripBldr) {
        float cx1 = 0.0f;
        float cx2 = 0.0f;
        float cx3 = 0.0f;
        float cy1 = 0.0f;
        float cy2 = 0.0f;
        float cy3 = 0.0f;
        int cc = 0;
        int[][] grd = new int[3][2];
        int color_length = crnr_color[0].length;
        float[][] tri = new float[2][5];
        float[][] normals = new float[3][5];
        float[][] tmp = new float[3][1];
        byte[] color = new byte[color_length];
        int vidx_0 = 0;
        int vidx_1 = 0;
        int crn_1 = 0;
        int crn_2 = 0;
        int crn_3 = 0;
        byte first_tri_orient = 0;
        byte last_tri_orient = 0;
        byte first_strp_side = -1;
        byte last_strp_side = -1;
        switch (o_flag) {
            case 1: {
                closed[0] = closed[0] | 0xE;
                if (crnr_out[1] || crnr_out[2] || crnr_out[3]) {
                    return;
                }
                cx1 = xx + xd;
                cy1 = yy;
                cx2 = xx + xd;
                cy2 = yy + yd;
                cx3 = xx;
                cy3 = yy + yd;
                cc = 3;
                grd[0][0] = 1;
                grd[0][1] = 0;
                grd[1][0] = 1;
                grd[1][1] = 1;
                grd[2][0] = 0;
                grd[2][1] = 1;
                vidx_0 = 2;
                vidx_1 = 0;
                crn_1 = 4;
                crn_2 = 3;
                crn_3 = 1;
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 3;
                last_strp_side = 1;
                break;
            }
            case 2: {
                closed[0] = closed[0] | 0xD;
                if (crnr_out[0] || crnr_out[2] || crnr_out[3]) {
                    return;
                }
                cx1 = xx;
                cy1 = yy;
                cx2 = xx;
                cy2 = yy + yd;
                cx3 = xx + xd;
                cy3 = yy + yd;
                cc = 2;
                grd[0][0] = 0;
                grd[0][1] = 0;
                grd[1][0] = 0;
                grd[1][1] = 1;
                grd[2][0] = 1;
                grd[2][1] = 1;
                vidx_0 = 2;
                vidx_1 = 4;
                crn_1 = 0;
                crn_2 = 1;
                crn_3 = 3;
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 3;
                last_strp_side = 1;
                break;
            }
            case 4: {
                closed[0] = closed[0] | 0xB;
                if (crnr_out[0] || crnr_out[1] || crnr_out[3]) {
                    return;
                }
                cx1 = xx;
                cy1 = yy;
                cx2 = xx + xd;
                cy2 = yy;
                cx3 = xx + xd;
                cy3 = yy + yd;
                cc = 1;
                grd[0][0] = 0;
                grd[0][1] = 0;
                grd[1][0] = 1;
                grd[1][1] = 0;
                grd[2][0] = 1;
                grd[2][1] = 1;
                vidx_0 = 1;
                vidx_1 = 3;
                crn_1 = 0;
                crn_2 = 2;
                crn_3 = 4;
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 3;
                last_strp_side = 2;
                break;
            }
            case 7: {
                closed[0] = closed[0] | 7;
                if (crnr_out[0] || crnr_out[1] || crnr_out[2]) {
                    return;
                }
                cx1 = xx + xd;
                cy1 = yy;
                cx2 = xx;
                cy2 = yy;
                cx3 = xx;
                cy3 = yy + yd;
                cc = 0;
                grd[0][0] = 1;
                grd[0][1] = 0;
                grd[1][0] = 0;
                grd[1][1] = 0;
                grd[2][0] = 0;
                grd[2][1] = 1;
                vidx_0 = 4;
                vidx_1 = 3;
                crn_1 = 2;
                crn_2 = 0;
                crn_3 = 1;
                first_tri_orient = -1;
                last_tri_orient = -1;
                first_strp_side = 3;
                last_strp_side = 1;
            }
        }
        for (int ii = 0; ii < color_length; ++ii) {
            color[ii] = crnr_color[cc][ii];
        }
        int levIdx = crnrLevelIdx[cc];
        tri[0][crn_1] = cx1;
        tri[1][crn_1] = cy1;
        normals[0][crn_1] = grd_normals[nc + grd[0][1]][nr + grd[0][0]][0];
        normals[1][crn_1] = grd_normals[nc + grd[0][1]][nr + grd[0][0]][1];
        normals[2][crn_1] = grd_normals[nc + grd[0][1]][nr + grd[0][0]][2];
        tri[0][crn_2] = cx2;
        tri[1][crn_2] = cy2;
        normals[0][crn_2] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][0];
        normals[1][crn_2] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][1];
        normals[2][crn_2] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][2];
        tri[0][crn_3] = cx3;
        tri[1][crn_3] = cy3;
        normals[0][crn_3] = grd_normals[nc + grd[2][1]][nr + grd[2][0]][0];
        normals[1][crn_3] = grd_normals[nc + grd[2][1]][nr + grd[2][0]][1];
        normals[2][crn_3] = grd_normals[nc + grd[2][1]][nr + grd[2][0]][2];
        tri[0][vidx_0] = vx[v_idx];
        tri[1][vidx_0] = vy[v_idx];
        Contour2D.interpNormals(tri[0][vidx_0], tri[1][vidx_0], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][vidx_0] = tmp[0][0];
        normals[1][vidx_0] = tmp[1][0];
        normals[2][vidx_0] = tmp[2][0];
        tri[0][vidx_1] = vx[v_idx + dir];
        tri[1][vidx_1] = vy[v_idx + dir];
        Contour2D.interpNormals(tri[0][vidx_1], tri[1][vidx_1], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][vidx_1] = tmp[0][0];
        normals[1][vidx_1] = tmp[1][0];
        normals[2][vidx_1] = tmp[2][0];
        triStripBldr.addVerticies(levIdx, tri, normals, color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
    }

    private static void fillToSide(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int flag, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, int[] crnrLevelIdx, boolean[] crnr_out, float[][][] grd_normals, int[] closed, TriangleStripBuilder triStripBldr) {
        float[][] tri = new float[2][4];
        float[][] normals = new float[3][4];
        Contour2D.fillToSide(xx, yy, xd, yd, v_idx, o_flag, flag, dir, vx, vy, nc, nr, crnr_color, crnrLevelIdx, crnr_out, grd_normals, closed, tri, normals, triStripBldr);
    }

    private static void fillToSide(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int flag, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, int[] crnrLevelIdx, boolean[] crnr_out, float[][][] grd_normals, int[] closed, float[][] strpverts, float[][] strpnrmls, TriangleStripBuilder triStripBldr) {
        float cx1 = 0.0f;
        float cy1 = 0.0f;
        float cx2 = 0.0f;
        float cy2 = 0.0f;
        int cc = 0;
        int[][] grd = new int[2][2];
        int color_length = crnr_color[0].length;
        float[][] tri = new float[2][4];
        float[][] normals = new float[3][4];
        float[][] tmp = new float[3][1];
        byte[] color = new byte[color_length];
        int vidx_0 = 0;
        int vidx_1 = 0;
        int crn_1 = 0;
        int crn_2 = 0;
        byte first_tri_orient = 0;
        byte last_tri_orient = 0;
        byte first_strp_side = -1;
        byte last_strp_side = -1;
        block0 : switch (o_flag) {
            case 3: {
                switch (flag) {
                    case 1: {
                        closed[0] = closed[0] | 0xC;
                        if (crnr_out[2] || crnr_out[3]) {
                            return;
                        }
                        cx1 = xx;
                        cy1 = yy + yd;
                        cx2 = xx + xd;
                        cy2 = yy + yd;
                        cc = 3;
                        grd[0][0] = 0;
                        grd[0][1] = 1;
                        grd[1][0] = 1;
                        grd[1][1] = 1;
                        crn_1 = 1;
                        crn_2 = 3;
                        vidx_0 = 0;
                        vidx_1 = 2;
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 3;
                        last_strp_side = 1;
                        break;
                    }
                    case -1: {
                        closed[0] = closed[0] | 3;
                        if (crnr_out[0] || crnr_out[1]) {
                            return;
                        }
                        cx1 = xx;
                        cy1 = yy;
                        cx2 = xx + xd;
                        cy2 = yy;
                        cc = 0;
                        grd[0][0] = 0;
                        grd[0][1] = 0;
                        grd[1][0] = 1;
                        grd[1][1] = 0;
                        crn_1 = 0;
                        crn_2 = 2;
                        vidx_0 = 1;
                        vidx_1 = 3;
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 3;
                        last_strp_side = 1;
                    }
                }
                break;
            }
            case 5: {
                switch (flag) {
                    case 1: {
                        closed[0] = closed[0] | 5;
                        if (crnr_out[0] || crnr_out[2]) {
                            return;
                        }
                        cx1 = xx;
                        cy1 = yy;
                        cx2 = xx;
                        cy2 = yy + yd;
                        cc = 0;
                        grd[0][0] = 0;
                        grd[0][1] = 0;
                        grd[1][0] = 0;
                        grd[1][1] = 1;
                        crn_1 = 0;
                        crn_2 = 1;
                        vidx_0 = 2;
                        vidx_1 = 3;
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = 3;
                        last_strp_side = -1;
                        break block0;
                    }
                    case -1: {
                        closed[0] = closed[0] | 0xA;
                        if (crnr_out[1] || crnr_out[3]) {
                            return;
                        }
                        cx1 = xx + xd;
                        cy1 = yy;
                        cx2 = xx + xd;
                        cy2 = yy + yd;
                        grd[0][0] = 1;
                        grd[0][1] = 0;
                        grd[1][0] = 1;
                        grd[1][1] = 1;
                        cc = 3;
                        crn_1 = 2;
                        crn_2 = 3;
                        vidx_0 = 0;
                        vidx_1 = 1;
                        first_tri_orient = -1;
                        last_tri_orient = 1;
                        first_strp_side = -1;
                        last_strp_side = 1;
                    }
                }
            }
        }
        for (int ii = 0; ii < color_length; ++ii) {
            color[ii] = crnr_color[cc][ii];
        }
        int levIdx = crnrLevelIdx[cc];
        tri[0][crn_1] = cx1;
        tri[1][crn_1] = cy1;
        int i = grd[0][0];
        int j = grd[0][1];
        normals[0][crn_1] = grd_normals[nc + j][nr + i][0];
        normals[1][crn_1] = grd_normals[nc + j][nr + i][1];
        normals[2][crn_1] = grd_normals[nc + j][nr + i][2];
        tri[0][crn_2] = cx2;
        tri[1][crn_2] = cy2;
        i = grd[1][0];
        j = grd[1][1];
        normals[0][crn_2] = grd_normals[nc + j][nr + i][0];
        normals[1][crn_2] = grd_normals[nc + j][nr + i][1];
        normals[2][crn_2] = grd_normals[nc + j][nr + i][2];
        tri[0][vidx_0] = vx[v_idx];
        tri[1][vidx_0] = vy[v_idx];
        Contour2D.interpNormals(tri[0][vidx_0], tri[1][vidx_0], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][vidx_0] = tmp[0][0];
        normals[1][vidx_0] = tmp[1][0];
        normals[2][vidx_0] = tmp[2][0];
        tri[0][vidx_1] = vx[v_idx + dir];
        tri[1][vidx_1] = vy[v_idx + dir];
        Contour2D.interpNormals(tri[0][vidx_1], tri[1][vidx_1], xx, yy, nc, nr, xd, yd, grd_normals, tmp);
        normals[0][vidx_1] = tmp[0][0];
        normals[1][vidx_1] = tmp[1][0];
        normals[2][vidx_1] = tmp[2][0];
        if (triStripBldr != null) {
            triStripBldr.addVerticies(levIdx, tri, normals, color, first_strp_side, first_tri_orient, last_strp_side, last_tri_orient);
        }
    }

    private static void addCorner(float xx, float yy, float xd, float yd, int nc, int nr, byte cornerID, float[][][] grd_normals, int[] closed, int strpIdx, float[][] strpverts, float[][] strpnrmls) {
        float cx = 0.0f;
        float cy = 0.0f;
        int i = 0;
        int j = 0;
        if (cornerID == 0) {
            closed[0] = closed[0] | 1;
            cx = xx;
            cy = yy;
            i = 0;
            j = 0;
        } else if (cornerID == 1) {
            closed[0] = closed[0] | 2;
            cx = xx + xd;
            cy = yy;
            i = 1;
            j = 0;
        } else if (cornerID == 2) {
            closed[0] = closed[0] | 4;
            cx = xx;
            cy = yy + yd;
            i = 0;
            j = 1;
        } else if (cornerID == 3) {
            closed[0] = closed[0] | 8;
            cx = xx + xd;
            cy = yy + yd;
            i = 1;
            j = 1;
        }
        strpverts[0][strpIdx] = cx;
        strpverts[1][strpIdx] = cy;
        strpnrmls[0][strpIdx] = grd_normals[nc + j][nr + i][0];
        strpnrmls[1][strpIdx] = grd_normals[nc + j][nr + i][1];
        strpnrmls[2][strpIdx] = grd_normals[nc + j][nr + i][2];
    }

    public static int[] getTriOrientation(float[][] verts) {
        int len = verts[0].length;
        float xa = verts[0][1] - verts[0][0];
        float ya = verts[1][1] - verts[1][0];
        float xb = verts[0][2] - verts[0][0];
        float yb = verts[1][2] - verts[1][0];
        float first = xa * yb - xb * ya;
        xa = verts[0][len - 2] - verts[0][len - 3];
        ya = verts[1][len - 2] - verts[1][len - 3];
        xb = verts[0][len - 1] - verts[0][len - 3];
        yb = verts[1][len - 1] - verts[1][len - 3];
        float last = xa * yb - xb * ya;
        int firstOrient = first < 0.0f ? -1 : 1;
        int lastOrient = last < 0.0f ? -1 : 1;
        return new int[]{firstOrient, lastOrient};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ContourOutput {
        public final ContourStripSet stripSet;
        public final TriangleStripBuilder triStripBldr;

        ContourOutput(ContourStripSet set, TriangleStripBuilder tsb) {
            this.stripSet = set;
            this.triStripBldr = tsb;
        }

        boolean isLineStyled(int lvl) {
            return this.stripSet.isLevelStyled(lvl);
        }

        List<float[][][]> getLineStripCoordinates(int lvl) {
            return this.stripSet.getLineStripCoordinates(lvl);
        }

        List<byte[][][]> getLineStripColors(int lvl) {
            return this.stripSet.getLineStripColors(lvl);
        }

        int getIntervalCount() {
            return this.stripSet.vecArray.length;
        }

        List<ContourStrip> getStrips(int lvl) {
            return this.stripSet.vecArray[lvl];
        }

        int[] getLabelIndexes(int lvlIdx) {
            return this.stripSet.labelIndexes[lvlIdx];
        }

        float[] getLevels() {
            return this.stripSet.levels;
        }
    }
}

