/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib1RecordScanner {
    private static Logger log = LoggerFactory.getLogger(Grib1RecordScanner.class);
    private static final KMPMatch matcher = new KMPMatch(new byte[]{71, 82, 73, 66});
    private static final boolean debug = false;
    private static final boolean debugGds = false;
    private static final int maxScan = 16000;
    static boolean allowBadIsLength = false;
    static boolean allowBadDsLength = false;
    private Map<Long, Grib1SectionGridDefinition> gdsMap = new HashMap<Long, Grib1SectionGridDefinition>();
    private RandomAccessFile raf = null;
    private byte[] header;
    private long lastPos = 0L;

    public static void setAllowBadIsLength(boolean allowBadIsLength) {
        Grib1RecordScanner.allowBadIsLength = allowBadIsLength;
    }

    public static void setAllowBadDsLength(boolean allowBadDsLength) {
        Grib1RecordScanner.allowBadDsLength = allowBadDsLength;
    }

    public static boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            boolean found = raf.searchForward(matcher, 16000);
            if (!found) {
                return false;
            }
            raf.skipBytes(4);
            int len = GribNumbers.uint3(raf);
            int edition = raf.read();
            if (edition != 1) {
                return false;
            }
            if ((long)(len = Grib1RecordScanner.getFixedTotalLengthEcmwfLargeGrib(raf, len)) > raf.length()) {
                return false;
            }
            if (allowBadIsLength) {
                return true;
            }
            raf.skipBytes(len - 12);
            for (int i = 0; i < 4; ++i) {
                if (raf.read() == 55) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static int getFixedTotalLengthEcmwfLargeGrib(RandomAccessFile raf, int len) throws IOException {
        int lenActual = len;
        if ((len & 0x800000) == 0x800000) {
            long pos0 = raf.getFilePointer();
            int lenS1 = GribNumbers.uint3(raf);
            raf.skipBytes(1);
            if (GribNumbers.uint(raf) == 98) {
                int lenS4;
                raf.skipBytes(2);
                int s1f = GribNumbers.uint(raf);
                raf.skipBytes(lenS1 - 8);
                int lenS2 = 0;
                int lenS3 = 0;
                if ((s1f & 0x80) == 128) {
                    lenS2 = GribNumbers.uint3(raf);
                    raf.skipBytes(lenS2 - 3);
                }
                if ((s1f & 0x40) == 64) {
                    lenS3 = GribNumbers.uint3(raf);
                    raf.skipBytes(lenS3 - 3);
                }
                if ((lenS4 = GribNumbers.uint3(raf)) < 120) {
                    lenActual = (len & 0x7FFFFF) * 120 - lenS4 + 4;
                }
            }
            raf.seek(pos0);
        }
        return lenActual;
    }

    public Grib1RecordScanner(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        raf.seek(0L);
        raf.order(0);
        this.lastPos = 0L;
    }

    public boolean hasNext() throws IOException {
        boolean more;
        if (this.lastPos >= this.raf.length()) {
            return false;
        }
        long foundAt = 0L;
        while (true) {
            this.raf.seek(this.lastPos);
            more = this.raf.searchForward(matcher, -1);
            if (!more) break;
            foundAt = this.raf.getFilePointer();
            this.raf.skipBytes(7);
            int edition = this.raf.read();
            if (edition == 1) break;
            this.lastPos = this.raf.getFilePointer();
        }
        if (more) {
            int sizeHeader = (int)(foundAt - this.lastPos);
            if (sizeHeader > 100) {
                sizeHeader = 100;
            }
            long startPos = foundAt - (long)sizeHeader;
            this.header = new byte[sizeHeader];
            this.raf.seek(startPos);
            this.raf.readFully(this.header);
            this.raf.seek(foundAt);
        }
        return more;
    }

    public Grib1Record next() throws IOException {
        block10: {
            Grib1SectionIndicator is = null;
            try {
                Grib1SectionGridDefinition gds;
                is = new Grib1SectionIndicator(this.raf);
                Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(this.raf);
                Grib1SectionGridDefinition grib1SectionGridDefinition = gds = pds.gdsExists() ? new Grib1SectionGridDefinition(this.raf) : new Grib1SectionGridDefinition(pds);
                if (!pds.gdsExists()) {
                    // empty if block
                }
                Grib1SectionBitMap bitmap = pds.bmsExists() ? new Grib1SectionBitMap(this.raf) : null;
                Grib1SectionBinaryData dataSection = new Grib1SectionBinaryData(this.raf);
                long ending = is.getEndPos();
                long dataEnding = dataSection.getStartingPosition() + (long)dataSection.getLength();
                if (dataEnding > is.getEndPos()) {
                    log.warn("BAD GRIB-1 data message at " + dataSection.getStartingPosition() + " header= " + StringUtil2.cleanup(this.header) + " for=" + this.raf.getLocation());
                    throw new IllegalStateException("Illegal Grib1SectionBinaryData Message Length");
                }
                long crc = gds.calcCRC();
                Grib1SectionGridDefinition gdsCached = this.gdsMap.get(crc);
                if (gdsCached != null) {
                    gds = gdsCached;
                } else {
                    this.gdsMap.put(crc, gds);
                }
                boolean foundEnding = this.checkEnding(ending);
                if (!foundEnding && (allowBadIsLength || is.isMessageLengthFixed)) {
                    foundEnding = this.checkEnding(dataSection.getStartingPosition() + (long)dataSection.getLength());
                }
                if (!foundEnding && (allowBadDsLength || is.isMessageLengthFixed)) {
                    foundEnding = true;
                }
                if (foundEnding) {
                    this.lastPos = this.raf.getFilePointer();
                    return new Grib1Record(this.header, is, gds, pds, bitmap, dataSection);
                }
                this.lastPos += 20L;
                if (this.hasNext()) {
                    return this.next();
                }
            }
            catch (Throwable t) {
                long pos = is == null ? -1L : is.getStartPos();
                log.warn("Bad Grib1 record in file {}, skipping pos={}", (Object)this.raf.getLocation(), (Object)pos);
                this.lastPos += 20L;
                if (!this.hasNext()) break block10;
                return this.next();
            }
        }
        return null;
    }

    private boolean checkEnding(long ending) throws IOException {
        this.raf.seek(ending - 4L);
        for (int i = 0; i < 4; ++i) {
            if (this.raf.read() == 55) continue;
            String clean = StringUtil2.cleanup(this.header);
            if (clean.length() > 40) {
                clean = clean.substring(0, 40) + "...";
            }
            log.debug("Missing End of GRIB message at pos=" + ending + " header= " + clean + " for=" + this.raf.getLocation());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        int count = 0;
        RandomAccessFile raf = new RandomAccessFile("Q:/cdmUnitTest/formats/grib1/ECMWF.hybrid.grib1", "r");
        Grib1RecordScanner scan = new Grib1RecordScanner(raf);
        while (scan.hasNext()) {
            scan.next();
            ++count;
        }
        raf.close();
        System.out.printf("count=%d%n", count);
    }
}

